package com.els.base.delivery.service.impl;

import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.delivery.dao.DeliveryPackageMapper;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.entity.DeliveryPackageExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.service.DeliveryPackageService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("deliveryPackageService")
public class DeliveryPackageServiceImpl implements DeliveryPackageService {
    @Resource
    protected DeliveryPackageMapper deliveryPackageMapper;

    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;

    @CacheEvict(value = { "deliveryPackage" }, allEntries = true)
    @Override
    public void addObj(DeliveryPackage t) {
        this.deliveryPackageMapper.insertSelective(t);
    }

    @CacheEvict(value = { "deliveryPackage" }, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.deliveryPackageMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = { "deliveryPackage" }, allEntries = true)
    @Override
    public void modifyObj(DeliveryPackage t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.deliveryPackageMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "deliveryPackage", keyGenerator="redisKeyGenerator")
    @Override
    public DeliveryPackage queryObjById(String id) {
        return this.deliveryPackageMapper.selectByPrimaryKey(id);
    }

   // @Cacheable(value = "deliveryPackage", keyGenerator="redisKeyGenerator")
    @Override
    public List<DeliveryPackage> queryAllObjByExample(DeliveryPackageExample example) {
        return this.deliveryPackageMapper.selectByExample(example);
    }

    @Cacheable(value = "deliveryPackage", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<DeliveryPackage> queryObjByPage(DeliveryPackageExample example) {
        PageView<DeliveryPackage> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryPackageMapper.selectByExampleByPage(example));
        return pageView;
    }
    @CacheEvict(value = { "deliveryPackage" }, allEntries = true)
    @Transactional
    @Override
    public void save(List<DeliveryPackage> deliveryPackageList) {
        if (CollectionUtils.isEmpty(deliveryPackageList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        DeliveryOrderItem temp = this.deliveryOrderItemService.queryObjById(deliveryPackageList.get(0).getDeliveryOrderItemId());
        if (temp == null) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        int packQuantity = 0;
        int totalQuantity = 0;
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
            String id = UUIDGenerator.generateUUID();
            deliveryPackage.setId(id);
            deliveryPackage.setCreateTime(new Date());
            if (deliveryPackage.getPackageQuantity() != null) {
                packQuantity = packQuantity + deliveryPackage.getPackageQuantity().intValue();
            }
            if (deliveryPackage.getTotalQuantity() != null) {
                totalQuantity = totalQuantity + deliveryPackage.getTotalQuantity().intValue();
            }
        }
        /*if (totalQuantity != temp.getDeliveryQuantity().intValue()) {
            throw new CommonException("包装数量和发货数量不一致", "not_same","包装数量","发货数量");
        }*/

        // 先删除原来的数据
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(
                deliveryPackageList.get(0).getDeliveryOrderItemId());
        this.deliveryPackageMapper.deleteByExample(example);
        // 修改发货单中的包装个数
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        deliveryOrderItem.setId(deliveryPackageList.get(0).getDeliveryOrderItemId());
        deliveryOrderItem.setPackQuantity(String.valueOf(packQuantity));
        deliveryOrderItemService.modifyObj(deliveryOrderItem);
        // 删除后再插入新的数据
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
        	deliveryPackage.setId(null);
        	this.deliveryPackageMapper.insert(deliveryPackage);
		}
    }

	@Override
	public void deleteByExample(DeliveryPackageExample deliveryPackageExample) {
		if (deliveryPackageExample == null || CollectionUtils.isEmpty(deliveryPackageExample.getOredCriteria())) {
			return;
		}
		
		this.deliveryPackageMapper.deleteByExample(deliveryPackageExample);
	}

    @CacheEvict(value = { "deliveryPackage" }, allEntries = true)
    @Transactional
	@Override
	public void addAll(List<DeliveryPackage> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (DeliveryPackage record : arg0) {
			this.deliveryPackageMapper.insertSelective(record);
		}
	}
}