package com.els.base.delivery.utils;

import org.apache.commons.collections.OrderedMap;
import org.apache.commons.collections.map.LinkedMap;
import org.apache.commons.lang.time.DateFormatUtils;

import java.util.Date;
/**
 * 批次号码规则要求
 * 1）检查总位数=10
 * 2）检查前6位是否符合YYMMDD
 * 3）检查中间三位为供应商主数据中的检索项字段
 * 4）检查最后一位为A-Z范围字符
 * 示例： 180322XXXA
 */
public class DeliveryCodeUtil {
  /*  public static void main(String[] args) {
        for (int i = 0; i < 5; i++) {
        }
    }*/

    /**
     * 获取批次号
     * @param str
     * @return
     */
    public static String getBatchNo(String str,int i){
        String format = DateFormatUtils.format(new Date(), "yyMMdd");
        StringBuffer s=new StringBuffer();
        s.append(format).append(str);
        OrderedMap map = getOrderedMap();
        if (i == 0) {
            s.append(map.get(map.firstKey()));
        }else{
            s .append(map.get(map.nextKey(i-1)));
        }
        return s.toString();
    }

    private static OrderedMap getOrderedMap() {
        OrderedMap map = new LinkedMap();
       /* for (int i = 0; i <=9; i++) {
          map.put(i, String.valueOf(i));
        }*/
        /*for (int i = 0; i < 26; i++) {
            char c = (char) (97 + i);
            map.put(i+10, String.valueOf(c));
        }*/
       /* for (int i = 0; i < 26; i++) {
            char c = (char) (65 + i);
            map.put(i+10+26, String.valueOf(c));
        }*/
        for (int i = 0; i < 26; i++) {
            char c = (char) (65 + i);
            map.put(i, String.valueOf(c));
        }
        return map;
    }
}
