package com.els.base.delivery.utils;

/**
 * 送货单拒绝收货状态
 * @author linyuqin
 * @date 2018年3月27日10:10:28
 */
public enum RefuseDeliveryStatusEnum {

	HAD_REFUSE(1, "已拒收"),
	NO_REFUSE(null, "非拒收");
	
	private final Integer value;
	private final String desc;

	// 构造器默认也只能是private, 从而保证构造函数只能在内部使用
	RefuseDeliveryStatusEnum(Integer value, String desc) {
		this.value = value;
		this.desc = desc;
	}

	public Integer getValue() {
		return value;
	}

	public String getDesc() {
		return desc;
	}

}
