package com.els.base.delivery.web.controller;

import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang.StringUtils;
import org.assertj.core.util.DateUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyAddress;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyAddressService;
import com.els.base.company.service.CompanyPurRefService;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.entity.user.UserExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.service.user.UserService;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderPrint;
import com.els.base.delivery.service.DeliveryOrderBatchNoService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliverOrderComparator;
import com.els.base.delivery.utils.DeliveryOrderPrintUtils;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.utils.DeliveryTypeEnum;
import com.els.base.file.entity.FileData;
import com.els.base.leadtime.entity.PurLeadTimeExample;
import com.els.base.leadtime.service.PurLeadTimeService;
import com.els.base.purchase.event.DeliveryOrderCreatedEvent;
import com.els.base.purchase.utils.HKStatusEnum;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.google.zxing.WriterException;
import com.itextpdf.text.DocumentException;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jxl.write.WritableWorkbook;

@Api(value = "发货单头")
@Controller
@RequestMapping("deliveryOrder")
public class DeliveryOrderController {
    private static Logger logger = LoggerFactory.getLogger(DeliveryOrderController.class);
    @Resource
    protected CompanyPurRefService companyPurRefService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;
    @Resource
    protected CompanyService companyService;
    @Resource
    protected CompanyAddressService companyAddressService;
    @Resource
    protected UserService userService;
    @Resource
    protected DeliveryOrderBatchNoService deliveryOrderBatchNoService;
    @Resource
    protected PurLeadTimeService purLeadTimeService;

    
	
	// 送货单采购导出
	@ApiOperation(value = "送货单导出批量导出Excel", httpMethod = "GET")
	@RequestMapping(value = "service/downloadExcel")
	@ResponseBody
	public ModelAndView downloadAllExcel(String queryParams, HttpServletResponse response) {

		try {

			logger.info("--------开始查询");
			logger.info("--------开始查询"+queryParams);
			DeliveryOrderExample example = new DeliveryOrderExample();
			String companyId = CompanyUtils.currentCompanyId();
			String projectId = ProjectUtils.getProjectId();
			DeliveryOrderExample.Criteria criteria = example.createCriteria();
			criteria.andProjectIdEqualTo(projectId);
			criteria.andCompanyIdEqualTo(companyId);
			// criteria.andIsEnableEqualTo(Constant.YES_INT); 取消排除不显示是作废的功能
			criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue()); // 类型为送货单
			if (StringUtils.isNotEmpty(queryParams)) {
				QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams, QueryParamWapper.class);
				CriteriaUtils.addCriterion(criteria, queryParamWapper);
			}
			example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
			List<DeliveryOrder> queryAllObjByExample = this.deliveryOrderService.queryAllObjByExample(example);
			logger.info("--------开始查询");			
			response.reset();
			StringBuffer header = new StringBuffer("attachment;");
			String companyShortName = CompanyUtils.currentCompany().getCompanyName();
			header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "送货单明细.xls", "UTF-8") + "\";");
			response.setHeader("Content-Disposition", header.toString());
			response.setCharacterEncoding("UTF-8");
			response.setContentType("application/vnd.ms-excel");
			OutputStream outputStream = response.getOutputStream();
			WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, createExcelpurHeader(),
					queryAllObjByExample, "送货单", null, 0);

			writableWorkbook.write();
			outputStream.flush();
			writableWorkbook.close();
			outputStream.close();
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
			logger.error("送货单明细失败", e);
		}
		return null;
	}
			
			
	

   // 送货单导出
	@ApiOperation(value = "送货单导出Excel", httpMethod = "GET")
	@RequestMapping(value = "service/downloadReportExcelBySelect")
	@ResponseBody
	public ModelAndView downloadReportExcelBySelect(
			@ApiParam(value = "项目物料id", defaultValue = "") @RequestParam(defaultValue = "") String id,
			HttpServletResponse response) {
		try {
			DeliveryOrderExample example = new DeliveryOrderExample();
			logger.info("项目物料导出Excel 参数" + id);
			if (StringUtils.isNotBlank(id)) {
				// criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
				example.createCriteria().andIdIn(Arrays.asList(id.split(",")));
			}
			example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
			List<DeliveryOrder> queryAllObjByExample = this.deliveryOrderService.queryAllObjByExample(example);
			response.reset();
			StringBuffer header = new StringBuffer("attachment;");
			String companyShortName = CompanyUtils.currentCompany().getCompanyName();
			header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "送货单明细.xls", "UTF-8") + "\";");
			response.setHeader("Content-Disposition", header.toString());
			response.setCharacterEncoding("UTF-8");
			response.setContentType("application/vnd.ms-excel");
			OutputStream outputStream = response.getOutputStream();
			WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, createExcelpurHeader(),
					queryAllObjByExample, "送货单", null, 0);
			writableWorkbook.write();
			outputStream.flush();
			writableWorkbook.close();
			outputStream.close();
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
			logger.error("送货单明细失败", e);
		}
		return null;
	}
	
	    // 送货单采购导出
		@ApiOperation(value = "送货单导出批量导出Excel", httpMethod = "GET")
		@RequestMapping(value = "pur/service/downloadExcel")
		@ResponseBody
		public ModelAndView downloadAllpurExcel(String queryParams, HttpServletResponse response) {

		try {
			DeliveryOrderExample example = new DeliveryOrderExample();
			String companyId = CompanyUtils.currentCompanyId();
			String projectId = ProjectUtils.getProjectId();
			DeliveryOrderExample.Criteria criteria = example.createCriteria();
			criteria.andProjectIdEqualTo(projectId);
			criteria.andPurCompanyIdEqualTo(companyId);
			criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue());
			if (StringUtils.isNotEmpty(queryParams)) {
				QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams, QueryParamWapper.class);
				CriteriaUtils.addCriterion(criteria, queryParamWapper);
			}
			example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
			List<DeliveryOrder> queryAllObjByExample = this.deliveryOrderService.queryAllObjByExample(example);
			response.reset();
			StringBuffer header = new StringBuffer("attachment;");
			String companyShortName = CompanyUtils.currentCompany().getCompanyName();
			header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "送货单明细.xls", "UTF-8") + "\";");
			response.setHeader("Content-Disposition", header.toString());
			response.setCharacterEncoding("UTF-8");
			response.setContentType("application/vnd.ms-excel");
			OutputStream outputStream = response.getOutputStream();
			WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, createExcelpurHeader(),
					queryAllObjByExample, "送货单", null, 0);

			writableWorkbook.write();
			outputStream.flush();
			writableWorkbook.close();
			outputStream.close();
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
			logger.error("送货单明细失败", e);
		}
		return null;
	}

	// 送货单采购选中导出
	@ApiOperation(value = "送货单选中导出Excel", httpMethod = "GET")
	@RequestMapping(value = "pur/service/downloadReportExcelBySelect")
	@ResponseBody
	public ModelAndView downloadReportExcelpurBySelect(
			@ApiParam(value = "项目物料id", defaultValue = "") @RequestParam(defaultValue = "") String id,
			HttpServletResponse response) {
		try {
			DeliveryOrderExample example = new DeliveryOrderExample();
			logger.info("项目物料导出Excel 参数" + id);
			if (StringUtils.isNotBlank(id)) {
				// criteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
				example.createCriteria().andIdIn(Arrays.asList(id.split(",")));
			}
			example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
			List<DeliveryOrder> queryAllObjByExample = this.deliveryOrderService.queryAllObjByExample(example);
			response.reset();
			StringBuffer header = new StringBuffer("attachment;");
			String companyShortName = CompanyUtils.currentCompany().getCompanyName();
			header.append("filename=\"" + URLEncoder.encode("" + companyShortName + "送货单明细.xls", "UTF-8") + "\";");
			response.setHeader("Content-Disposition", header.toString());
			response.setCharacterEncoding("UTF-8");
			response.setContentType("application/vnd.ms-excel");
			OutputStream outputStream = response.getOutputStream();
			WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, createExcelpurHeader(),
					queryAllObjByExample, "送货单", null, 0);
			writableWorkbook.write();
			outputStream.flush();
			writableWorkbook.close();
			outputStream.close();
		} catch (Exception e) {
			response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
			logger.error("送货单明细失败", e);
		}
		return null;
	}

	
	   //采购商导入表头
	  private List<TitleAndModelKey> createExcelpurHeader() {
	        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("客户SAP编码", "companyCode"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "companyName"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物流单号", "logisticOrderNo"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否可用", "isEnable"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("客户编码", "purCompanyCode"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("客户名称", "purCompanyName"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("单据类型", "deliveryStatus"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发货状态", "deliveryStatus"));
	        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("创建日期", "createTime");
	        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd HH:mm：ss");
	        titleAndModelKey.setToObjConverter(dateConverter);
	        titleAndModelKey.setToStrConverter(dateConverter);
	        titleAndModelKeys.add(titleAndModelKey);
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("销售方负责人", "userName"));
	        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("预计送货日期", "expectDeliveryTime");
	        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd HH:mm：ss");
	        titleAndModelKey2.setToObjConverter(dateConverter2);
	        titleAndModelKey2.setToStrConverter(dateConverter2);
	        titleAndModelKeys.add(titleAndModelKey2);
	        TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("预计到达日期", "expectArriveTime");
	        DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd HH:mm：ss");
	        titleAndModelKey3.setToObjConverter(dateConverter3);
	        titleAndModelKey3.setToStrConverter(dateConverter3);
	        titleAndModelKeys.add(titleAndModelKey3);
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("质检报告", "attachment"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发票编号", "invoiceNo"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("车牌号码", "car"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("司机", "driverName"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("身份证", "idCard"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("快递公司	", "expressCompany"));
	        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("快递单号", "expressNumber"));
	        return titleAndModelKeys;
	    }
	  

    @ApiOperation(httpMethod = "POST", value = "供应商发货，新建送货单，发货。发货单发货：入参（整个发货单实体类）")
    @RequestMapping("service/sendDelivery")
    @ResponseBody
    public ResponseResult<String> sendDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("发货单数据不能为空", "base_canot_be_null", "发货单数据");
        }
		
        if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        if ((deliveryOrder.getDeliveryStatus() != null)
                && (!DeliveryStatusEnum.UN_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus()))) {
            throw new CommonException("该发货单已经发货，不能重复发货", "cannot_repeat_shipment");
        }
        
        
        if(jude(deliveryOrder)) {
        	throw new CommonException("当前时间段已预约，请修改别的时间段", "delivery_order_service", "送达时间");
        }
        List<DeliveryOrderItem> DeliveryOrderItemArray = deliveryOrder.getItems();

        for (DeliveryOrderItem deliveryOrderItem : DeliveryOrderItemArray) {

            logger.info("外包装件数--" + deliveryOrderItem.getPackQuantity());
            if (StringUtils.isBlank(deliveryOrderItem.getPackQuantity())) {
                //throw new CommonException("外包装件数不能为空，请先维护包装方式才能保存");
                //如果外包装件数为空 自动生成
                deliveryOrderItem.setPackQuantity("1");
            } else {
                Integer DefalutpackQuantity = new Integer(deliveryOrderItem.getPackQuantity());
                if (DefalutpackQuantity.equals(0)) {
                    deliveryOrderItem.setPackQuantity("1");
                }
            }
        }


        // 类型为送货单
        deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
        // 默认未香港到货
        deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
        deliveryOrder.setCompanyCode(CompanyUtils.currentCompany().getCompanySapCode());
        deliveryOrder.setProjectId(ProjectUtils.getProjectId());
        deliveryOrder.setCompanyId(CompanyUtils.currentCompanyId());
        deliveryOrder.setUserId(SpringSecurityUtils.getLoginUserId());
        deliveryOrder.setUserName(SpringSecurityUtils.getLoginUserName());
        deliveryOrder.setIsEnable(Constant.YES_INT);
        this.deliveryOrderService.sendDelivery(deliveryOrder);
        return ResponseResult.success();
    }
    
    
    //判断送货前预约到达时期是否超过6家
    private boolean jude(DeliveryOrder deliveryOrder) {
 		int minuteOf = DateUtil.minuteOf(deliveryOrder.getExpectArriveTime());
 		Calendar calendar = Calendar.getInstance();
 		calendar.setTime(deliveryOrder.getExpectArriveTime());
 		String timeStart = "";
 		String timeEnd = "";
 		if (minuteOf < 30) {
 			calendar.set(Calendar.MINUTE, 0);
 			calendar.set(Calendar.SECOND, 0);
 			calendar.set(Calendar.MILLISECOND, 0);
 			timeStart =DateUtil.formatAsDatetime(calendar.getTime()) ;
 			calendar.set(Calendar.MINUTE, 30);
 			calendar.set(Calendar.SECOND, 0);
 			calendar.set(Calendar.MILLISECOND, 0);
 			timeEnd =DateUtil.formatAsDatetime(calendar.getTime()) ;
 		} else {
 			calendar.set(Calendar.MINUTE, 30);
 			calendar.set(Calendar.SECOND, 0);
 			calendar.set(Calendar.MILLISECOND, 0);
 			timeStart =DateUtil.formatAsDatetime(calendar.getTime()) ;
 			calendar.set(Calendar.MINUTE, 59);
 			calendar.set(Calendar.SECOND, 59);
 			calendar.set(Calendar.MILLISECOND, 59);
 			timeEnd =DateUtil.formatAsDatetime(calendar.getTime()) ;
 		}
		List<DeliveryOrder> list = this.deliveryOrderService.queryAllExpectArriveTime(timeStart, timeEnd);
		if (list.size() > 5) {
			List<String> companyCode = list.stream().map(DeliveryOrder::getCompanyCode).collect(Collectors.toList());
			if(companyCode.contains(deliveryOrder.getCompanyCode())) {
				return false;
			};
			return true;
		}
		return false;
	}




	@ApiOperation(httpMethod = "POST", value = "送货单管理-批量发货。发货单批量发货：入参（发货单头id数组）")
    @RequestMapping("service/sendDeliveryForBatch")
    @ResponseBody
    public ResponseResult<String> sendDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("发货单不能为空", "base_canot_be_null", "发货单");
        }
        for (String id : deliveryOrderIdList) {
            DeliveryOrder deliveryOrder = this.deliveryOrderService.queryObjById(id);
            if (deliveryOrder == null) {
                throw new CommonException("没有找到该发货单", "do_not_exists", "发货单");
            }
            // 默认未香港到货
            deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
            deliveryOrder.setCompanyCode(CompanyUtils.currentCompany().getCompanySapCode());
            // 类型为送货单
            deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
            deliveryOrder.setIsEnable(Constant.YES_INT);
            this.deliveryOrderService.sendDelivery(deliveryOrder);
        }
        return ResponseResult.success();
    }

    // @ApiOperation(httpMethod = "POST", value = "送货单管理-撤销发货。撤销发货单：入参（整个发货单实体类）")
    // @RequestMapping("service/cancelDelivery")
    // @ResponseBody
    // public ResponseResult<String> cancelDelivery(@RequestBody DeliveryOrder deliveryOrder) {
    // if (deliveryOrder == null) {
    // throw new CommonException("发货单数据不能为空", "base_canot_be_null", "发货单数据");
    // }
    // if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
    // throw new CommonException("行数据不存在", "do_not_exists", "行数据");
    // }
    // if ((deliveryOrder.getDeliveryStatus() == null)) {
    // throw new CommonException("送货单状态不能为空", "base_canot_be_null", "送货单状态");
    // }
    // if (deliveryOrder.getDeliveryStatus() == DeliveryStatusEnum.ALL_RECEIVED.getValue()
    // || deliveryOrder.getDeliveryStatus() == DeliveryStatusEnum.HK_RECEIVED.getValue()) {
    // throw new CommonException("该送货单客户有收货，不可撤销发货，谢谢！", "the_customer_has_received_the_goods");
    // }
    //
    // // 送货单已创建在XXXXXXXXX物流单内，请删除物流单后再撤销发货，谢谢！
    // if (StringUtils.isNotEmpty(deliveryOrder.getLogisticOrderNo())) {
    // throw new CommonException("该送货单已创建在" + deliveryOrder.getLogisticOrderNo() +
    // "物流单内，请删除物流单后再撤销发货",
    // "delivery_order_backout_error", deliveryOrder.getLogisticOrderNo());
    // }
    //
    // this.deliveryOrderService.cancelDelivery(deliveryOrder);
    // return ResponseResult.success();
    // }

    // @ApiOperation(httpMethod = "POST", value = "送货单管理-批量撤销发货。批量撤销发货单：入参（发货单头id数组）")
    // @RequestMapping("service/cancelDeliveryForBatch")
    // @ResponseBody
    // public ResponseResult<String> cancelDeliveryForBatch(@RequestBody List<String>
    // deliveryOrderIdList) {
    // if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
    // throw new CommonException("发货单不能为空", "base_canot_be_null", "发货单");
    // }
    // // 发货单ID集合遍历
    // for (String id : deliveryOrderIdList) {
    // DeliveryOrder deliveryOrder = this.deliveryOrderService.queryObjById(id);
    // if (deliveryOrder == null) {
    // throw new CommonException("没有找到该发货单", "do_not_exists", "发货单");
    // }
    // /*
    // * if ((deliveryOrder.getDeliveryStatus() != null) &&
    // * (!(deliveryOrder.getDeliveryStatus() == DeliveryStatusEnum.ONWAY.getValue()))) {
    // * throw new CommonException("不能撤销！", "irrevocable"); }
    // */
    // if ((deliveryOrder.getDeliveryStatus() == null)) {
    // throw new CommonException("送货单状态不能为空", "base_canot_be_null", "送货单状态");
    // }
    // if (deliveryOrder.getDeliveryStatus() == DeliveryStatusEnum.ALL_RECEIVED.getValue()
    // || deliveryOrder.getDeliveryStatus() == DeliveryStatusEnum.HK_RECEIVED.getValue()) {
    // throw new CommonException("该送货单客户有收货，不可撤销发货，谢谢！", "the_customer_has_received_the_goods");
    // }
    // // 送货单已创建在XXXXXXXXX物流单内，请删除物流单后再撤销发货，谢谢！
    // if (StringUtils.isNotEmpty(deliveryOrder.getLogisticOrderNo())) {
    // throw new CommonException("该送货单已创建在" + deliveryOrder.getLogisticOrderNo()
    // + "物流单内，请删除物流单后再撤销发货", "delivery_order_backout_error",
    // deliveryOrder.getLogisticOrderNo());
    // }
    // this.deliveryOrderService.cancelDelivery(deliveryOrder);
    // }
    // return ResponseResult.success();
    // }

    @ApiOperation(httpMethod = "POST", value = "送货单管理-批量作废发货。批量撤销发货单：入参（发货单头id数组）")
    @RequestMapping("service/cancellationDeliveryForBatch")
    @ResponseBody
    public ResponseResult<String> cancellationDeliveryForBatch(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("提交数据不能为空", "not_query_to_data");
        }
        this.deliveryOrderService.cancellation(deliveryOrderIdList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "送货单管理-批量作废发货。批量撤销发货单：入参（发货单头id数组）")
    @RequestMapping("service/cancellationDeliveryForBatchByExample")
    @ResponseBody
    public ResponseResult<String> cancellationDeliveryForBatchByExample(@RequestBody(required = true) QueryParamWapper wapper) {
        if (wapper == null) {
            throw new CommonException("提交数据不能为空", "not_query_to_data");
        }

        DeliveryOrderExample example = new DeliveryOrderExample();
        CriteriaUtils.addCriterion(example.createCriteria(), wapper);
        List<DeliveryOrder> list = this.deliveryOrderService.queryAllObjByExample(example);
        if (CollectionUtils.isEmpty(list)) {
            throw new CommonException("查询出来的送货单为空");
        }

        List<String> idList = new ArrayList<>();
        for (DeliveryOrder deliveryOrder : list) {
            idList.add(deliveryOrder.getId());
        }

        this.deliveryOrderService.cancellation(idList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "供应商发货，新建送货单，保存操作。发货单保存：入参（整个发货单实体类）")
    @RequestMapping("service/saveDelivery")
    @ResponseBody
    public ResponseResult<String> saveDelivery(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("发货单数据不能为空", "do_not_exists", "发货单数据");
        }
        if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
//        if (!DeliveryStatusEnum.UN_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) {
//            if (DeliveryStatusEnum.ONWAY.getValue().equals(deliveryOrder.getDeliveryStatus())) {
//                // 只上传文件
//                if (StringUtils.isNotEmpty(deliveryOrder.getAttachment())) {
//                    DeliveryOrder order = new DeliveryOrder();
//                    order.setId(deliveryOrder.getId());
//                    order.setAttachment(deliveryOrder.getAttachment());
//                    deliveryOrderService.modifyObj(order);
//                }
//                for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
//                    if (StringUtils.isNotEmpty(deliveryOrderItem.getAttachment())) {
//                        DeliveryOrderItem orderItem = new DeliveryOrderItem();
//                        orderItem.setId(deliveryOrderItem.getId());
//                        orderItem.setAttachment(deliveryOrderItem.getAttachment());
//                    }
//                }
//            } else {
//                throw new CommonException("只有未发货的订单才能修改");
//            }
//        }

        Collections.sort(deliveryOrder.getItems(), new DeliverOrderComparator());

        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            // 如果要保存送货单，包装数不能为空
            //去掉校验 系统自动生成
            logger.info("外包装件数--" + deliveryOrderItem.getPackQuantity());
            if (StringUtils.isBlank(deliveryOrderItem.getPackQuantity())) {
                //throw new CommonException("外包装件数不能为空，请先维护包装方式才能保存");
                //如果外包装件数为空 自动生成
                deliveryOrderItem.setPackQuantity("1");
            } else {
                Integer packQuantity = new Integer(deliveryOrderItem.getPackQuantity());
                if (packQuantity.equals(0)) {
                    deliveryOrderItem.setPackQuantity("1");
                }
            }
            if ((deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255)
                    || (deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255)
                    || (deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255)
                    || (deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea()
                    .length() > 255)
                    || (deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255)
                    || (deliveryOrderItem.getCaseNo() != null && deliveryOrderItem.getCaseNo().length() > 30)) {
                throw new CommonException("参数长度超标", "database_length_error");
            }

        }
        if(jude(deliveryOrder)) {
        	throw new CommonException("当前时间段已预约，请修改别的时间段", "delivery_order_service", "送达时间");
        }

        deliveryOrder.setProjectId(ProjectUtils.getProjectId());
        deliveryOrder.setCompanyId(CompanyUtils.currentCompanyId());
        deliveryOrder.setUserId(SpringSecurityUtils.getLoginUserId());
        deliveryOrder.setUserName(SpringSecurityUtils.getLoginUserName());
        deliveryOrder.setIsEnable(Constant.YES_INT);
        deliveryOrder.setCompanyCode(CompanyUtils.currentCompany().getCompanySapCode());
        // 默认未香港到货
        deliveryOrder.setIsHk(HKStatusEnum.UN_HK.getValue());
        // 类型为送货单
        deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
        if (StringUtils.isNotBlank(deliveryOrder.getId())) {
            logger.info("更新送货单  送货单代码--" + deliveryOrder.getLogisticOrderNo());
            this.deliveryOrderService.updateDeliveryOrder(deliveryOrder);
        } else {
            logger.info("新增送货单  送货单代码--" + deliveryOrder.getLogisticOrderNo());
//            //插入批次号
//            String batchNo = deliveryOrderBatchNoService.getBatchNo(deliveryOrder.getCompanyCode());
//            deliveryOrder.setBatch(batchNo);

            this.deliveryOrderService.addObj(deliveryOrder);
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "删除发货单：入参（发货单头id数组）")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestBody List<String> deliveryOrderIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderIdList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        this.deliveryOrderService.deleteDelivery(deliveryOrderIdList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "送货单管理-列表。查询发货头")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        System.out.print("--------开始查询");
        logger.info("--------开始查询");
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        //criteria.andIsEnableEqualTo(Constant.YES_INT); 取消排除不显示是作废的功能
        criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue()); // 类型为送货单
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        System.out.print("--------开始查询数据库");
        logger.info("--------开始查询数据库");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "送货单管理-列表。查询发货头")
    @RequestMapping("service/pur/findByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findDeliveryOrderForPurByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andPurCompanyIdEqualTo(companyId);
        //criteria.andIsEnableEqualTo(Constant.YES_INT); 取消排除不显示是作废的功能
        criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "新建送货单。生成发货单数据：入参（采购订单行id数组）")
    @RequestMapping("service/createDeliveryData")
    @ResponseBody
    public ResponseResult<DeliveryOrder> createDeliveryData(@RequestBody List<String> orderItemIdList) {
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        deliveryOrder = this.deliveryOrderService.createDeliveryData(orderItemIdList,
                ProjectUtils.getProjectId());
        return ResponseResult.success(deliveryOrder);
    }

    @ApiOperation(httpMethod = "GET", value = "通过id查询发货单头历史")
    @RequestMapping("service/findHisById")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findHisById(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("发货单头id") String id) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        if (StringUtils.isBlank(id)) {
            throw new CommonException("id为空，操作失败", "id_is_blank");
        }
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "查询香港到货发货头")
    @RequestMapping("service/findByPageForHK")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForHK(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        String loginUserId = SpringSecurityUtils.getLoginUserId();

        CompanyExample companyEx = new CompanyExample();
        List<Company> queryAllCompanyByUserId = this.companyPurRefService.queryAllCompanyByUserId(
                loginUserId, companyEx);
        List<String> comanyIds = new ArrayList<String>();
        if (CollectionUtils.isNotEmpty(queryAllCompanyByUserId)) {
            for (Company company : queryAllCompanyByUserId) {
                comanyIds.add(company.getId());
            }
        }
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        List<Integer> statusList = new ArrayList<Integer>();
        statusList.add(DeliveryStatusEnum.ONWAY.getValue());
        statusList.add(DeliveryStatusEnum.UN_RECEIVED.getValue());
        // 查询发货在途的
        criteria.andDeliveryStatusIn(statusList);
        criteria.andPurCompanyIdEqualTo(companyId);
        if (!CollectionUtils.isEmpty(comanyIds)) {
            criteria.andCompanyIdIn(comanyIds);
            // 香港到货过滤(是否香港到货；1未到货，2已到货)
            // criteria.andCompanyCodeLike("2%");
            criteria.andIsHkEqualTo(1);
        } else {
            return ResponseResult.success(new PageView<DeliveryOrder>());
        }
        // invoice类型
        criteria.andTypeEqualTo(DeliveryTypeEnum.INVOICE.getValue());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "香港到货：入参（发货单头id数组）")
    @RequestMapping("service/updateForHK")
    @ResponseBody
    public ResponseResult<String> updateForHK(@RequestBody List<String> deliveryOrderIdList) {
        this.deliveryOrderService.updateForHK(deliveryOrderIdList);
        SpringContextHolder.getApplicationContext().publishEvent(
                new DeliveryOrderCreatedEvent(deliveryOrderIdList, CompanyUtils.currentCompanyId(),
                        ProjectUtils.getProject()));
        // for (String id : deliveryOrderIdList) {
        // // 发布监听
        // DeliveryOrder deliveryOrder = this.deliveryOrderService.queryObjById(id);
        // }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购员查询发货头")
    @RequestMapping("service/findByPageForPurchase")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForPurchase(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andPurCompanyIdEqualTo(companyId);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "采购员发货单保存：入参（整个发货单实体类）")
    @RequestMapping("service/saveDeliveryForPurchase")
    @ResponseBody
    public ResponseResult<String> saveDeliveryForPurchase(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("发货单数据不能为空", "do_not_exists", "发货单数据");
        }
        if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        deliveryOrder.setProjectId(ProjectUtils.getProjectId());
        deliveryOrder.setPurCompanyId(CompanyUtils.currentCompanyId());
        deliveryOrder.setPurUserId(SpringSecurityUtils.getLoginUserId());
        deliveryOrder.setIsEnable(Constant.YES_INT);
        deliveryOrder.setPurUserName(SpringSecurityUtils.getLoginUserName());
        this.deliveryOrderService.addObj(deliveryOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "采购员发货单发货：入参（整个发货单实体类）")
    @RequestMapping("service/sendDeliveryForPurchase")
    @ResponseBody
    public ResponseResult<String> sendDeliveryForPurchase(@RequestBody DeliveryOrder deliveryOrder) {
        if (deliveryOrder == null) {
            throw new CommonException("发货单不能为空", "base_canot_be_null", "发货单");
        }
        /*
         * if (StringUtils.isBlank(deliveryOrder.getLogisticOrderNo())) { throw new
         * CommonException("物流单号为空，不能发货"); }
         */
        if (CollectionUtils.isEmpty(deliveryOrder.getItems())) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        if ((deliveryOrder.getDeliveryStatus() != null)
                && (!DeliveryStatusEnum.UN_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus()))) {
            throw new CommonException("该发货单已经发货，不能重复发货", "cannot_repeat_shipment");
        }
        deliveryOrder.setProjectId(ProjectUtils.getProjectId());
        deliveryOrder.setPurCompanyId(CompanyUtils.currentCompanyId());
        deliveryOrder.setPurUserId(SpringSecurityUtils.getLoginUserId());
        deliveryOrder.setPurUserName(SpringSecurityUtils.getLoginUserName());
        deliveryOrder.setIsEnable(Constant.YES_INT);
        this.deliveryOrderService.sendDelivery(deliveryOrder);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "查询仓库送货单/质检送货单")
    @RequestMapping("service/findByPageForWarehouse")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrder>> findByPageForWarehouse(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrder") @RequestBody(required = false) QueryParamWapper wapper) {
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.setPageView(new PageView<DeliveryOrder>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        DeliveryOrderExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        List<Integer> values = new ArrayList<Integer>();
        values.add(DeliveryStatusEnum.ONWAY.getValue());
        values.add(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        criteria.andDeliveryStatusIn(values);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC,LAST_UPDATE_TIME DESC");
        PageView<DeliveryOrder> pageData = this.deliveryOrderService.queryDeliveryOrderByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商送货-送货单管理-打印送货单PDF。送货单打印:入参:DeliveryOrderPrint对象包括行项目")
    @RequestMapping("service/print")
    @ResponseBody
    public ResponseResult<FileData> print(@RequestBody DeliveryOrderPrint deliveryOrderPrint)
            throws WriterException, IOException, DocumentException, InterruptedException {
        // 数据校验
        List<DeliveryOrderItem> items = deliveryOrderPrint.getItems();
        if (CollectionUtils.isEmpty(items)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        List<DeliveryOrderItem> itemsCanPrintArray = new ArrayList<>();
        for (DeliveryOrderItem item : items) {
            if (DeliveryStatusEnum.ONWAY.getValue().equals(item.getDeliveryStatus())) {
                itemsCanPrintArray.add(item);
            }
           if (item.getIsEnable()==0) {
            	itemsCanPrintArray.remove(item);
            	 //throw new CommonException("所选送货单已经废弃，无法打印");
            }
        }
        if (CollectionUtils.isEmpty(itemsCanPrintArray)) {
            throw new CommonException("所选送货单不存在在途状态明细，无法打印");
        }
        deliveryOrderPrint.setItems(itemsCanPrintArray);
        //deliveryOrderPrint.setItems(items);
        // 设置收货地址
        if (StringUtils.isBlank(deliveryOrderPrint.getPurCompanyId())) {
            throw new CommonException("送货单中缺乏采购商的信息", "not_query_to_data");
        }

        if (StringUtils.isBlank(deliveryOrderPrint.getReceiveAddress())) {
            // 查询地址
            String addressCode = items.get(0).getSapPurCompanyCode();
            String companyId = deliveryOrderPrint.getPurCompanyId();
            String languageCode = "";
            List<CompanyAddress> companyAddressList = this.companyAddressService
                    .queryByCompanyIdAndAddressCodeAndLanguageCode(companyId, addressCode, languageCode);
            if (CollectionUtils.isNotEmpty(companyAddressList)) {
                for (CompanyAddress companyAddress : companyAddressList) {
                    if (companyAddress.getLanguageCode().equals("zh-CN")) {// 简体中文地址
                        deliveryOrderPrint.setReceiveAddress(companyAddress.getAddress());
                        break;
                    }
                }
            }
        }

        // User currentUser = SpringSecurityUtils.getLoginUser();
        // 设置基础信息
        Company company = CompanyUtils.currentCompany();
        deliveryOrderPrint.setSupplierTel(StringUtils.defaultIfBlank(company.getTelephone(),
                company.getMobilephone()));
        deliveryOrderPrint.setSupplierPerson(company.getContacts());
        deliveryOrderPrint.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        // 第一步：通过供应商主数据中“采购员”字段中用户账号，到用户账号表中取当前用户账号的用户名和电话，分别填入“客户联系人”
        String purchasingStaff = company.getPurchasingStaff();// 采购员
        if (StringUtils.isNotBlank(purchasingStaff)) {
            UserExample userExample = new UserExample();
            userExample.createCriteria().andLoginNameEqualTo(purchasingStaff);
            List<User> userInfo = this.userService.queryAllObjByExample(userExample);
            if (CollectionUtils.isNotEmpty(userInfo)) {
                if (StringUtils.isBlank(userInfo.get(0).getNickName())) {
                    deliveryOrderPrint.setPurchasePerson(purchasingStaff);
                } else {
                    deliveryOrderPrint.setPurchasePerson(userInfo.get(0).getNickName());
                }
                deliveryOrderPrint.setPurchaseTel(userInfo.get(0).getMobilePhone().equals(null) ? ""
                        : userInfo.get(0).getMobilePhone());
            } else {
                deliveryOrderPrint.setPurchasePerson(purchasingStaff);
            }
        }
        
        // 加一个条件，如果送货单行在供应商送货提前期维护了“工厂、供应商编码、物料编码”，且限制天数为“2”天，则需要在送货单备注显示JIT字样
        PurLeadTimeExample example = new PurLeadTimeExample();
        for (DeliveryOrderItem deliveryOrderItem : items) {
        	example.clear();
        	example.createCriteria().andDaysNumberEqualTo(2).andFactoryTypeEqualTo(deliveryOrderItem.getFactoryCode())
        	.andSupCompanySapCodeEqualTo(deliveryOrderPrint.getCompanyCode()).andMaterialCodeEqualTo(deliveryOrderItem.getMaterialNo());
        	if (CollectionUtils.isNotEmpty(purLeadTimeService.queryAllObjByExample(example))) {
        		deliveryOrderItem.setRemark("JIT");
        	}
        }

        /*
         * FriendGroup friendGroup = companyPurRefService.queryPurchaseFriendGroup(
         * CompanyUtils.currentCompanyId(), deliveryOrderPrint.getPurCompanyId()); if (friendGroup
         * != null) { //
         * deliveryOrderPrint.setPurCompanyName(friendGroup.getCompany().getCompanyFullName()); //
         * deliveryOrderPrint.setReceiveAddress(friendGroup.getCompany().getAddress()); // if
         * (CollectionUtils.isNotEmpty(friendGroup.getUserList())) { } }
         */
        FileData fileData = DeliveryOrderPrintUtils.generateDeliveryOrderPdf(deliveryOrderPrint,
                deliveryOrderPrint.getPrintSizeType());
        return ResponseResult.success(fileData);
    }

    private DeliveryOrderPrint printDeliveryOrderData(DeliveryOrderPrint deliveryOrderPrint) {
        // 数据校验
        List<DeliveryOrderItem> items = deliveryOrderPrint.getItems();
        if (CollectionUtils.isEmpty(items)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }

        // 设置收货地址
        if (StringUtils.isBlank(deliveryOrderPrint.getPurCompanyId())) {
            throw new CommonException("送货单中缺乏采购商的信息", "not_query_to_data");
        }

        if (StringUtils.isBlank(deliveryOrderPrint.getReceiveAddress())) {
            // 查询地址
            String addressCode = items.get(0).getSapPurCompanyCode();
            String companyId = deliveryOrderPrint.getPurCompanyId();
            String languageCode = "";
            List<CompanyAddress> companyAddressList = this.companyAddressService
                    .queryByCompanyIdAndAddressCodeAndLanguageCode(companyId, addressCode, languageCode);
            if (CollectionUtils.isNotEmpty(companyAddressList)) {
                for (CompanyAddress companyAddress : companyAddressList) {
                    if (companyAddress.getLanguageCode().equals("zh-CN")) {// 简体中文地址
                        deliveryOrderPrint.setReceiveAddress(companyAddress.getAddress());
                        break;
                    }
                }
            }
        }

        // User currentUser = SpringSecurityUtils.getLoginUser();
        // 设置基础信息
        Company company = CompanyUtils.currentCompany();
        deliveryOrderPrint.setSupplierTel(StringUtils.defaultIfBlank(company.getTelephone(),
                company.getMobilephone()));
        deliveryOrderPrint.setSupplierPerson(company.getContacts());
        deliveryOrderPrint.setCompanyName(CompanyUtils.currentCompany().getCompanyFullName());
        // 第一步：通过供应商主数据中“采购员”字段中用户账号，到用户账号表中取当前用户账号的用户名和电话，分别填入“客户联系人”
        String purchasingStaff = company.getPurchasingStaff();// 采购员
        if (StringUtils.isNotBlank(purchasingStaff)) {
            UserExample userExample = new UserExample();
            userExample.createCriteria().andLoginNameEqualTo(purchasingStaff);
            List<User> userInfo = this.userService.queryAllObjByExample(userExample);
            if (CollectionUtils.isNotEmpty(userInfo)) {
                if (StringUtils.isBlank(userInfo.get(0).getNickName())) {
                    deliveryOrderPrint.setPurchasePerson(purchasingStaff);
                } else {
                    deliveryOrderPrint.setPurchasePerson(userInfo.get(0).getNickName());
                }
                deliveryOrderPrint.setPurchaseTel(userInfo.get(0).getMobilePhone().equals(null) ? ""
                        : userInfo.get(0).getMobilePhone());
            } else {
                deliveryOrderPrint.setPurchasePerson(purchasingStaff);
            }
        }
        return deliveryOrderPrint;
    }

    @ApiOperation(httpMethod = "POST", value = "供应商送货-送货单管理-根据工厂打印送货单PDF。送货单打印:入参:DeliveryOrderPrint对象包括行项目")
    @RequestMapping("service/printByFactory")
    @ResponseBody
    public ResponseResult<List<FileData>> printByFactory(@RequestBody DeliveryOrderPrint deliveryOrderPrint)
            throws WriterException, IOException, DocumentException, InterruptedException {

        this.printDeliveryOrderData(deliveryOrderPrint);

        Map<String, List<DeliveryOrderItem>> deliveryOrderItemMap = new HashMap<>();
        List<DeliveryOrderItem> deliveryOrderItems = deliveryOrderPrint.getItems();
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrderItems) {
            String factoryCode = deliveryOrderItem.getFactoryCode();
            List<DeliveryOrderItem> listItems = null;
            if (deliveryOrderItemMap.containsKey(factoryCode)) {
                listItems = deliveryOrderItemMap.get(factoryCode);
            } else {
                listItems = new ArrayList<>();
            }
            listItems.add(deliveryOrderItem);
            deliveryOrderItemMap.put(factoryCode, listItems);
        }

        List<DeliveryOrderPrint> deliveryOrderPrints = new ArrayList<>();
        if (deliveryOrderItemMap.entrySet() != null) {
            for (Map.Entry<String, List<DeliveryOrderItem>> entry : deliveryOrderItemMap.entrySet()) {
                DeliveryOrderPrint newPrint = new DeliveryOrderPrint();
                BeanUtils.copyProperties(deliveryOrderPrint, newPrint);
                newPrint.setItems(entry.getValue());
                deliveryOrderPrints.add(newPrint);
            }
        }

        /*
         * FriendGroup friendGroup = companyPurRefService.queryPurchaseFriendGroup(
         * CompanyUtils.currentCompanyId(), deliveryOrderPrint.getPurCompanyId()); if (friendGroup
         * != null) { //
         * deliveryOrderPrint.setPurCompanyName(friendGroup.getCompany().getCompanyFullName()); //
         * deliveryOrderPrint.setReceiveAddress(friendGroup.getCompany().getAddress()); // if
         * (CollectionUtils.isNotEmpty(friendGroup.getUserList())) { } }
         */
        List<FileData> pdfFiles = new ArrayList<>();
        for (DeliveryOrderPrint entiy : deliveryOrderPrints) {
            FileData fileData = DeliveryOrderPrintUtils.generateDeliveryOrderPdf(entiy,
                    deliveryOrderPrint.getPrintSizeType());
            pdfFiles.add(fileData);
        }

        return ResponseResult.success(pdfFiles);
    }

    @ApiOperation(httpMethod = "POST", value = "测试pdf生成功能，传入html生成pdf")
    @RequestMapping("service/testprint")
    @ResponseBody
    public ResponseResult<FileData> testprint(
            @ApiParam(value = "PDF类型:A4, A5, PACKING_LIST, QRCODE_SMALL, QRCODE_LARGE ") String type,
            MultipartHttpServletRequest request) throws UnsupportedEncodingException, IOException,
            DocumentException, InterruptedException {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        String isEncrypt;
        isEncrypt = request.getParameter("isEncrypt"); // 标识上传文件是否需要加密
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }

        Set<String> fileKeySet = fileMap.keySet();
        if (fileKeySet.size() > 1) {
            throw new CommonException("不接受多个文件上传", "file_upload_not_accepted");
        }

        MultipartFile multifile = null;

        Iterator<String> keyIterator = fileKeySet.iterator();
        while (keyIterator.hasNext()) {
            multifile = fileMap.get(keyIterator.next());
        }

        if (multifile == null || multifile.isEmpty()) {
            throw new CommonException("不接受多个文件上传", "file_upload_not_accepted");
        }

        String fileSuffix = FilenameUtils.getExtension(multifile.getOriginalFilename());
        if (StringUtils.isBlank(fileSuffix)) {
            throw new CommonException("不接受后缀名为空的文件", "file_upload_not_accepted");
        }

        String html = new String(multifile.getBytes(), "UTF-8");

        FileData pdfFile = DeliveryOrderPrintUtils.createEmptyPDF("6", "20170701054612-901656210d5542639",
                "测试文件");
        File file = pdfFile.toFile();

        switch (type) {
            case "Letter2":
                HtmlToPdfUtils.generatePdf(html, file, 216f, 139.5f, "测试Letter2");
                break;
            case "Letter":
                HtmlToPdfUtils.generatePdf(html, file, "Letter", true, "测试Letter");
                break;
            case "A4":
                HtmlToPdfUtils.generatePdf(html, file, HtmlToPdfUtils.PAGE_SIZE_A4, true, "测试A4");
                break;
            case "A5":
                HtmlToPdfUtils.generatePdf(html, file, HtmlToPdfUtils.PAGE_SIZE_A5, false, "测试A5");
                break;
            case "INVOCIE":
                HtmlToPdfUtils.generatePdf(html, file, HtmlToPdfUtils.PAGE_SIZE_A4, false, "测试invoice");
                break;
            case "PACKING_LIST":
                HtmlToPdfUtils.generatePdf(html, file, HtmlToPdfUtils.PAGE_SIZE_A4, false, "测试packinglist");
                break;
            case "QRCODE_SMALL":
                HtmlToPdfUtils.generatePdf(html, file, 70, 45, "测试二维码70x45");
                break;
            case "QRCODE_LARGE":
                HtmlToPdfUtils.generatePdf(html, file, 80, 80, "测试二维码80x80");
                break;
            default:
                break;
        }
        return ResponseResult.success(pdfFile);
    }

    @ApiOperation(httpMethod = "POST", value = "订单行转为发货单行：入参（采购订单行id数组）")
    @RequestMapping("service/orderItemToDeliveryData")
    @ResponseBody
    public ResponseResult<List<DeliveryOrderItem>> orderItemToDeliveryData(
            @RequestBody List<String> orderItemIdList) {
        List<DeliveryOrderItem> items = new ArrayList<DeliveryOrderItem>();
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            throw new CommonException("没有查询到数据", "not_query_to_data");
        }
        items = this.deliveryOrderService.orderItemToDeliveryData(orderItemIdList,
                ProjectUtils.getProjectId());
        return ResponseResult.success(items);
    }

    @ApiOperation(httpMethod = "POST", value = "送货单管理-修改-通过发货id查询发货行:")
    @RequestMapping("service/findByDeliveryOrderId")
    @ResponseBody
    public ResponseResult<DeliveryOrder> findByDeliveryOrderId(@ApiParam("发货单号Id") String deliveryOrderId) {
        if (StringUtils.isBlank(deliveryOrderId)) {
            throw new CommonException("查询失败,发货号不存在", "do_not_exists", "发货号");
        }
        DeliveryOrder deliveryOrder = this.deliveryOrderService.queryDeliveryOrderId(deliveryOrderId);
        return ResponseResult.success(deliveryOrder);
    }

}