package com.els.base.delivery.web.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.els.base.delivery.entity.DeliveryOrderReport;
import com.els.base.delivery.entity.DeliveryOrderReportItemExample;
import com.els.base.delivery.utils.DeliveryTypeEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import jxl.write.WritableWorkbook;
import net.sf.json.JSON;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import org.springframework.web.servlet.ModelAndView;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;


@Api(value = "发货行")
@Controller
@RequestMapping("deliveryOrderItem")
public class DeliveryOrderItemController {

    Logger logger = LoggerFactory.getLogger(DeliveryOrderItemController.class);

    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;

    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @ApiOperation(httpMethod = "POST", value = "通过发货号查询采购订单行:")
    @RequestMapping("service/findByDeliveryOrder")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findByDeliveryOrder(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("发货单号Id") String deliveryOrderId) {

        if (StringUtils.isBlank(deliveryOrderId)) {
            throw new CommonException("查询失败,发货号不存在", "do_not_exists", "发货号");
        }

        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));

        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andDeliveryOrderIdEqualTo(deliveryOrderId);

        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "GET", value = "通过id查询发货单行历史")
    @RequestMapping("service/findHisById")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> findHisById(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("发货单行id") String id) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        if (StringUtils.isBlank(id)) {
            throw new CommonException("id为空，操作失败", "id_is_blank");
        }

        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andIdEqualTo(id);
        example.setOrderByClause("last_update_time DESC");
        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryHisObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "物流进度报表")
    @RequestMapping("service/queryDeliveryOrderItemForLogisticByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForLogisticByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrderItem,原型图") @RequestBody(required = false) QueryParamWapper wapper) {
        logger.info("进入物流进度报表");
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        String companyId = CompanyUtils.currentCompanyId();
        String projectId = ProjectUtils.getProjectId();

        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "物流进度报表（采购方）")
    @RequestMapping("service/queryDeliveryOrderItemForPurchaseByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderItem>> queryDeliveryOrderItemForPurchaseByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrderItem,原型图") @RequestBody(required = false) QueryParamWapper wapper) {
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.setPageView(new PageView<DeliveryOrderItem>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();

        DeliveryOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andProjectIdEqualTo(projectId);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        PageView<DeliveryOrderItem> pageData = this.deliveryOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "送货单明细--批量作废发货行。批量撤销发货单行：入参（发货单行id数组）")
    @RequestMapping("service/cancellationDeliveryItemForBatch")
    @ResponseBody
    public ResponseResult<String> cancellationDeliveryItemForBatch(@RequestBody List<String> deliveryOrderItemIdList) {
        if (CollectionUtils.isEmpty(deliveryOrderItemIdList)) {
            throw new CommonException("提交数据不能为空", "not_query_to_data");
        }
        this.deliveryOrderItemService.cancellation(deliveryOrderItemIdList);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "送货单报表查询(供应商)")
    @RequestMapping("service/queryDeliveryOrderReportByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderReport>> queryDeliveryOrderReportByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrderReport,原型图") @RequestBody(required = false) QueryParamWapper wapper) {
        logger.info("送货单报表查询 （供应商） queryDeliveryOrderReportByPage");
        DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
        example.setPageView(new PageView<DeliveryOrderReport>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        String companyId = CompanyUtils.currentCompanyId();
        logger.info("送货单报表查询 （供应商） 供应商公司ID" + companyId);
        DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
        //criteria.andMdeliveryStatusNotEqualTo("1");
        criteria.andProjectIdEqualTo(projectId);
        criteria.andCompanyIdEqualTo(companyId);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        //criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue()); // 类型为送货单
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
        logger.info("送货单报表查询 （供应商） 参数初始化完成");
        PageView<DeliveryOrderReport> pageData = this.deliveryOrderItemService.queryDeliveryOrderReportByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "送货单报表查询(供应商)导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            logger.info("送货单报表查询(供应商)导出Excel 参数" + queryParams);
            DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
            DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
            String projectId = ProjectUtils.getProjectId();
            //criteria.andMdeliveryStatusNotEqualTo("1");
            criteria.andProjectIdEqualTo(projectId);
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
            List<DeliveryOrderReport> DeliveryOrderReportList = this.deliveryOrderItemService.queryDeliveryOrderReportForExcel(example);
            logger.info("送货单报表查询(供应商)导出Excel 数据条数" + DeliveryOrderReportList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "送货单报表报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("送货单报表报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("送货单报表查询(供应商)导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单行", "deliveryOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发货状态", "mDeliveryStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否可用", "sourceArea"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂名称", "factoryName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单", "purOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单项", "purOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
            TitleAndModelKey titleAndModelKeyJ = ExcelUtils.createTitleAndModelKey("交货日期", "deliveryDate");
            DateConverter dateConverterJ = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyJ.setToObjConverter(dateConverterJ);
            titleAndModelKeyJ.setToStrConverter(dateConverterJ);
            titleAndModelKeys.add(titleAndModelKeyJ);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货数量", "deliveryQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiptQuantity"));
            TitleAndModelKey titleAndModelKeyS = ExcelUtils.createTitleAndModelKey("预计送货日期", "expectDeliveryTime");
            DateConverter dateConverterS = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyS.setToObjConverter(dateConverterS);
            titleAndModelKeyS.setToStrConverter(dateConverterS);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyD = ExcelUtils.createTitleAndModelKey("预计到达日期", "expectArriveTime");
            DateConverter dateConverterD = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyD.setToObjConverter(dateConverterD);
            titleAndModelKeyD.setToStrConverter(dateConverterD);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyC = ExcelUtils.createTitleAndModelKey("送货单创建日期", "createDate");
            DateConverter dateConverterC = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyC.setToObjConverter(dateConverterC);
            titleAndModelKeyC.setToStrConverter(dateConverterC);
            titleAndModelKeys.add(titleAndModelKeyS);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS号描述", "wbsNoDesc"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("批次号", "batch"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("包装件数", "packingNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));

            if (DeliveryOrderReportList != null && DeliveryOrderReportList.size() > 0) {
                DeliveryOrderReportList.forEach(item -> {
                    if (item.getIsEnable().equals(Constant.NO_INT)) {
                        item.setSourceArea("作废");
                    } else {
                        item.setSourceArea("正常");
                    }
                });
            }
            logger.info("送货单报表查询(供应商)导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    DeliveryOrderReportList, "送货单报表报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("送货单报表查询(供应商)导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    @ApiOperation(value = "送货单报表查询(供应商)导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "发运行ID", defaultValue = "") @RequestParam(defaultValue = "") String deliveryOrderItemList,
            HttpServletResponse response) {
        try {
            logger.info("送货单报表查询(供应商)导出Excel 参数" + deliveryOrderItemList);
            DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
            DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
            String projectId = ProjectUtils.getProjectId();
            //criteria.andMdeliveryStatusNotEqualTo("1");
            criteria.andProjectIdEqualTo(projectId);
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());

            if (StringUtils.isNotBlank(deliveryOrderItemList)) {
                criteria.andIdIn(Arrays.asList(deliveryOrderItemList.split(",")));
            }
            example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
            List<DeliveryOrderReport> DeliveryOrderReportList = this.deliveryOrderItemService.queryDeliveryOrderReportForExcel(example);
            logger.info("送货单报表查询(供应商)导出Excel 数据条数" + DeliveryOrderReportList);
            logger.info("送货单报表查询(供应商)导出Excel 数据条数" + DeliveryOrderReportList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "送货单报表报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("送货单报表报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("送货单报表查询(供应商)导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单行", "deliveryOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发货状态", "mDeliveryStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否可用", "sourceArea"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂名称", "factoryName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单", "purOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单项", "purOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));
            TitleAndModelKey titleAndModelKeyJ = ExcelUtils.createTitleAndModelKey("交货日期", "deliveryDate");
            DateConverter dateConverterJ = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyJ.setToObjConverter(dateConverterJ);
            titleAndModelKeyJ.setToStrConverter(dateConverterJ);
            titleAndModelKeys.add(titleAndModelKeyJ);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货数量", "deliveryQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiptQuantity"));
            TitleAndModelKey titleAndModelKeyS = ExcelUtils.createTitleAndModelKey("预计送货日期", "expectDeliveryTime");
            DateConverter dateConverterS = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyS.setToObjConverter(dateConverterS);
            titleAndModelKeyS.setToStrConverter(dateConverterS);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyD = ExcelUtils.createTitleAndModelKey("预计到达日期", "expectArriveTime");
            DateConverter dateConverterD = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyD.setToObjConverter(dateConverterD);
            titleAndModelKeyD.setToStrConverter(dateConverterD);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyC = ExcelUtils.createTitleAndModelKey("送货单创建日期", "createDate");
            DateConverter dateConverterC = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyC.setToObjConverter(dateConverterC);
            titleAndModelKeyC.setToStrConverter(dateConverterC);
            titleAndModelKeys.add(titleAndModelKeyS);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS号描述", "wbsNoDesc"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("批次号", "batch"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("包装件数", "packingNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            if (DeliveryOrderReportList != null && DeliveryOrderReportList.size() > 0) {
                DeliveryOrderReportList.forEach(item -> {
                    if (item.getIsEnable().equals(Constant.NO_INT)) {
                        item.setSourceArea("作废");
                    } else {
                        item.setSourceArea("正常");
                    }
                });
            }

            logger.info("送货单报表查询(供应商)导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    DeliveryOrderReportList, "送货单报表报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("送货单报表查询(供应商)导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    @ApiOperation(httpMethod = "POST", value = "送货单报表查询(采购)")
    @RequestMapping("service/queryDeliveryOrderReportBuyerByPage")
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderReport>> queryDeliveryOrderReportBuyerByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam(value = "查询条件,属性名请参考 DeliveryOrderReport,原型图") @RequestBody(required = false) QueryParamWapper wapper) {
        logger.info("送货单报表查询 （采购） queryDeliveryOrderReportByPage");
        DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
        example.setPageView(new PageView<DeliveryOrderReport>(pageNo, pageSize));
        String projectId = ProjectUtils.getProjectId();
        String companyId = CompanyUtils.currentCompanyId();
        logger.info("送货单报表查询 （采购） 供应商公司ID" + companyId);
        DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
        //criteria.andMdeliveryStatusNotEqualTo("1");
        criteria.andProjectIdEqualTo(projectId);
        //criteria.andCompanyIdEqualTo(companyId);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        //criteria.andTypeEqualTo(DeliveryTypeEnum.DELIVERY.getValue()); // 类型为送货单
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
        logger.info("送货单报表查询 （采购） 参数初始化完成");
        PageView<DeliveryOrderReport> pageData = this.deliveryOrderItemService.queryDeliveryOrderReportByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "送货单报表查询(采购)导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadBuyerReportExcel")
    @ResponseBody
    public ModelAndView downloadBuyerReportExcel(String queryParams, HttpServletResponse response) {
        try {
            logger.info("送货单报表查询(采购)导出Excel 参数" + queryParams);
            DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
            DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
            String projectId = ProjectUtils.getProjectId();
            //criteria.andMdeliveryStatusNotEqualTo("1");
            criteria.andProjectIdEqualTo(projectId);
            //criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
            List<DeliveryOrderReport> DeliveryOrderReportList = this.deliveryOrderItemService.queryDeliveryOrderReportForExcel(example);
            logger.info("送货单报表查询(采购)导出Excel 数据条数" + DeliveryOrderReportList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "送货单报表报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("送货单报表报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("送货单报表查询(采购)导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单行", "deliveryOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发货状态", "mDeliveryStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否可用", "sourceArea"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂名称", "factoryName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单", "purOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单项", "purOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));

            TitleAndModelKey titleAndModelKeyJ = ExcelUtils.createTitleAndModelKey("交货日期", "deliveryDate");
            DateConverter dateConverterJ = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyJ.setToObjConverter(dateConverterJ);
            titleAndModelKeyJ.setToStrConverter(dateConverterJ);
            titleAndModelKeys.add(titleAndModelKeyJ);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货数量", "deliveryQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiptQuantity"));
            TitleAndModelKey titleAndModelKeyS = ExcelUtils.createTitleAndModelKey("预计送货日期", "expectDeliveryTime");
            DateConverter dateConverterS = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyS.setToObjConverter(dateConverterS);
            titleAndModelKeyS.setToStrConverter(dateConverterS);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyD = ExcelUtils.createTitleAndModelKey("预计到达日期", "expectArriveTime");
            DateConverter dateConverterD = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyD.setToObjConverter(dateConverterD);
            titleAndModelKeyD.setToStrConverter(dateConverterD);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyC = ExcelUtils.createTitleAndModelKey("送货单创建日期", "createDate");
            DateConverter dateConverterC = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyC.setToObjConverter(dateConverterC);
            titleAndModelKeyC.setToStrConverter(dateConverterC);
            titleAndModelKeys.add(titleAndModelKeyS);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS号描述", "wbsNoDesc"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("批次号", "batch"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("包装件数", "packingNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            if (DeliveryOrderReportList != null && DeliveryOrderReportList.size() > 0) {
                DeliveryOrderReportList.forEach(item -> {
                    if (item.getIsEnable().equals(Constant.NO_INT)) {
                        item.setSourceArea("作废");
                    } else {
                        item.setSourceArea("正常");
                    }
                });
            }
            logger.info("送货单报表查询(采购)导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    DeliveryOrderReportList, "送货单报表报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("送货单报表查询(采购)导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


    @ApiOperation(value = "送货单报表查询(采购)导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadBuyerReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadBuyerReportExcelBySelect(
            @ApiParam(value = "发运行ID", defaultValue = "") @RequestParam(defaultValue = "") String deliveryOrderItemList,
            HttpServletResponse response) {
        try {
            logger.info("送货单报表查询(采购)导出Excel 参数" + deliveryOrderItemList);
            DeliveryOrderReportItemExample example = new DeliveryOrderReportItemExample();
            DeliveryOrderReportItemExample.Criteria criteria = example.createCriteria();
            String projectId = ProjectUtils.getProjectId();
            //criteria.andMdeliveryStatusNotEqualTo("1");
            criteria.andProjectIdEqualTo(projectId);
            //criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());

            if (StringUtils.isNotBlank(deliveryOrderItemList)) {
                criteria.andIdIn(Arrays.asList(deliveryOrderItemList.split(",")));
            }
            example.setOrderByClause("CREATE_TIME DESC, DELIVERY_DATE DESC,DELIVERY_ORDER_NO,DELIVERY_ORDER_ITEM_NO");
            List<DeliveryOrderReport> DeliveryOrderReportList = this.deliveryOrderItemService.queryDeliveryOrderReportForExcel(example);
            logger.info("送货单报表查询(采购)导出Excel 数据条数" + DeliveryOrderReportList);
            logger.info("送货单报表查询(采购)导出Excel 数据条数" + DeliveryOrderReportList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "送货单报表报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("送货单报表报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("送货单报表查询(采购)导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单号", "deliveryOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货单行", "deliveryOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发货状态", "mDeliveryStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否可用", "sourceArea"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂名称", "factoryName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单", "purOrderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单项", "purOrderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialDesc"));

            TitleAndModelKey titleAndModelKeyJ = ExcelUtils.createTitleAndModelKey("交货日期", "deliveryDate");
            DateConverter dateConverterJ = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyJ.setToObjConverter(dateConverterJ);
            titleAndModelKeyJ.setToStrConverter(dateConverterJ);
            titleAndModelKeys.add(titleAndModelKeyJ);


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("送货数量", "deliveryQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receiptQuantity"));


            TitleAndModelKey titleAndModelKeyS = ExcelUtils.createTitleAndModelKey("预计送货日期", "expectDeliveryTime");
            DateConverter dateConverterS = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyS.setToObjConverter(dateConverterS);
            titleAndModelKeyS.setToStrConverter(dateConverterS);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyD = ExcelUtils.createTitleAndModelKey("预计到达日期", "expectArriveTime");
            DateConverter dateConverterD = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyD.setToObjConverter(dateConverterD);
            titleAndModelKeyD.setToStrConverter(dateConverterD);
            titleAndModelKeys.add(titleAndModelKeyS);

            TitleAndModelKey titleAndModelKeyC = ExcelUtils.createTitleAndModelKey("送货单创建日期", "createDate");
            DateConverter dateConverterC = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKeyC.setToObjConverter(dateConverterC);
            titleAndModelKeyC.setToStrConverter(dateConverterC);
            titleAndModelKeys.add(titleAndModelKeyS);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS号描述", "wbsNoDesc"));


            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("批次号", "batch"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("包装件数", "packingNumber"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));

            if (DeliveryOrderReportList != null && DeliveryOrderReportList.size() > 0) {
                DeliveryOrderReportList.forEach(item -> {
                    if (item.getIsEnable().equals(Constant.NO_INT)) {
                        item.setSourceArea("作废");
                    } else {
                        item.setSourceArea("正常");
                    }
                });
            }
            logger.info("送货单报表查询(采购)导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    DeliveryOrderReportList, "送货单报表报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("送货单报表查询(采购)导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

}