package com.els.base.delivery.web.controller;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.entity.DeliveryPackageExample;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.service.DeliveryPackageService;
import com.els.base.delivery.utils.DeliveryStatusEnum;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value = "送货包装")
@Controller
@RequestMapping("deliveryPackage")
public class DeliveryPackageController {
    @Resource
    protected DeliveryPackageService deliveryPackageService;
    
    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @ApiOperation(httpMethod = "POST", value = "保存或者修改送货包装:入参：对象数组（对象字段参考DeliveryPackage）")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody List<DeliveryPackage> deliveryPackageList) {
    	if (CollectionUtils.isEmpty(deliveryPackageList)) {
			throw new CommonException("提交数据为空，无法保存");
		}
    	
    	DeliveryOrder deliveryOrder = this.deliveryOrderService.queryObjById(deliveryPackageList.get(0).getDeliveryOrderId());
    	if (!DeliveryStatusEnum.UN_RECEIVED.getValue().equals(deliveryOrder.getDeliveryStatus())) {
			throw new CommonException("只能未发货的单据才能被修改");
		}
    	
        Company company=CompanyUtils.currentCompany();
        for (DeliveryPackage deliveryPackage : deliveryPackageList) {
            deliveryPackage.setProjectId(ProjectUtils.getProjectId());
            deliveryPackage.setCompanyId(company.getId());
            deliveryPackage.setCompanyCode(company.getCompanyCode());
            deliveryPackage.setCompanyName(company.getCompanyName());
            deliveryPackage.setUserId(SpringSecurityUtils.getLoginUserId());
            deliveryPackage.setUserName(SpringSecurityUtils.getLoginUserName());
        }
        this.deliveryPackageService.save(deliveryPackageList);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "通过送货单行Id查询送货包装：入参：送货单行Id")
    @RequestMapping("service/findByDeliveryOrderItemId")
    @ResponseBody
    public ResponseResult<List<DeliveryPackage>> findByDeliveryOrderItemId(
            @ApiParam(value = "送货单行Id") @RequestParam(required = true) String deliveryOrderItemId) {
        if (StringUtils.isBlank(deliveryOrderItemId)) {
            throw new CommonException("id为空，操作失败", "id_is_blank");
        }
        DeliveryPackageExample example = new DeliveryPackageExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(deliveryOrderItemId);
        List<DeliveryPackage> list = this.deliveryPackageService.queryAllObjByExample(example);
        return ResponseResult.success(list);
    }
}