package com.els.base.leadtime.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.auth.entity.User;
import com.els.base.company.entity.Company;
import com.els.base.company.entity.CompanyExample;
import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.project.Project;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.leadtime.dao.PurLeadTimeMapper;
import com.els.base.leadtime.entity.PurLeadTime;
import com.els.base.leadtime.entity.PurLeadTimeExample;
import com.els.base.leadtime.service.PurLeadTimeService;
import com.els.base.material.entity.Material;
import com.els.base.material.entity.MaterialExample;
import com.els.base.material.service.MaterialService;

@Service("defaultPurLeadTimeService")
public class PurLeadTimeServiceImpl implements PurLeadTimeService {
    @Resource
    protected PurLeadTimeMapper purLeadTimeMapper;
    @Resource
    private CompanyService companyService;
    @Resource
    private MaterialService materialService;

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Transactional
    @Override
    public void edit(Project project, Company company, User loginUser, PurLeadTime purLeadTime) {

        Assert.isNotNull(purLeadTime,"控制提前期信息不能为空！");
        Assert.isNotBlank(purLeadTime.getId(),"控制提前期信息ID不能为空！");

        PurLeadTime purLeadTime1 = purLeadTimeMapper.selectByPrimaryKey(purLeadTime.getId());
        Assert.isNotNull(purLeadTime1,"控制提前期信息不存在！");

        //会变更的几个信息

        //工厂
        purLeadTime1.setFactoryType(purLeadTime.getFactoryType());

        //供应商编码
        String s = StringUtils.defaultIfBlank(purLeadTime.getSupCompanySapCode(), null);
        purLeadTime1.setSupCompanySapCode(s);

        //供应商名称
        purLeadTime1.setSupCompanyFullName(purLeadTime.getSupCompanyFullName());
        purLeadTime1.setSupCompanyName(purLeadTime.getSupCompanyName());

        //物料名称
        purLeadTime1.setMaterialDesc(purLeadTime.getMaterialDesc());

        //物料编码
        String s1 = StringUtils.defaultIfBlank(purLeadTime.getMaterialCode(), null);
        purLeadTime1.setMaterialCode(s1);

        //限制天数
        Integer daysNumber = purLeadTime.getDaysNumber();
        Assert.isNotNull(daysNumber,"限制天数不能为空！");
        purLeadTime1.setDaysNumber(daysNumber);

        purLeadTime1.setProjectId(project.getId());
        purLeadTime1.setPurCompanyId(company.getId());
        purLeadTime1.setPurCompanyName(company.getCompanyName());
        purLeadTime1.setPurCompanyFullName(company.getCompanyFullName());
        purLeadTime1.setPurCompanySapCode(company.getCompanySapCode());
        purLeadTime1.setPurCompanySrmCode(company.getCompanyCode());
        purLeadTime1.setPurUserId(loginUser.getId());
        purLeadTime1.setPurUserName(loginUser.getNickName());

        //purLeadTime1.setCreateTime(new Date());
        purLeadTime1.setUpdateTime(new Date());
        purLeadTime1.setIsEnable(Constant.YES_INT);


        //更新前需要校验一下
        this.filterForUpdate(purLeadTime);

        this.purLeadTimeMapper.updateByPrimaryKey(purLeadTime1);

    }

    private void filterForUpdate(PurLeadTime purLeadTime) {

        String factoryType = purLeadTime.getFactoryType();
        String materialCode = purLeadTime.getMaterialCode();
        String supCompanySapCode = purLeadTime.getSupCompanySapCode();

        //1、工厂，物料编码，供应商编码都不为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isNotBlank(materialCode)
                &&StringUtils.isNotBlank(supCompanySapCode)){

            PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())
                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andMaterialCodeEqualTo(materialCode)
                    .andIdNotEqualTo(purLeadTime.getId())//不等于自身
                    .andSupCompanySapCodeEqualTo(supCompanySapCode);

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if(i>0){
                throw new CommonException("已存在相同的工厂，物料编码，供应商编码的数据，不能再新建!");
            }

        }

        //2、工厂，供应商编码不为空，但是物料编码为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isNotBlank(supCompanySapCode)
                &&StringUtils.isBlank(materialCode)){

            PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())
                    .andIdNotEqualTo(purLeadTime.getId())//不等于其本身
                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)
                    .andMaterialCodeIsNull();

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if(i>0){
                throw new CommonException("已存在相同的工厂,供应商编码的数据，不能再新建!");
            }

        }

        //3、工厂，供应商编码为空和物料编码都为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isBlank(supCompanySapCode)
                &&StringUtils.isBlank(materialCode)) {

            PurLeadTimeExample purLeadTimeExample = new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())
                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andIdNotEqualTo(purLeadTime.getId())//不等于其本身
                    .andSupCompanySapCodeIsNull()
                    .andMaterialCodeIsNull();

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if (i > 0) {
                throw new CommonException("已存在相同的工厂，不能再新建!");
            }
        }
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Transactional
    @Override
    public void deleteObjByIds(List<String> ids) {
        PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
        purLeadTimeExample.createCriteria().andIdIn(ids);
        this.purLeadTimeMapper.deleteByExample(purLeadTimeExample);
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Transactional
    @Override
    public void create(Project project, Company company, User loginUser, PurLeadTime purLeadTime) {

        Assert.isNotNull(purLeadTime,"提前控制期信息不能为空！");
        Assert.isNotNull(purLeadTime.getFactoryType(),"工厂不能为空！");

        purLeadTime.setId(null);
        purLeadTime.setProjectId(project.getId());
        purLeadTime.setPurCompanyId(company.getId());
        purLeadTime.setPurCompanyName(company.getCompanyName());
        purLeadTime.setPurCompanyFullName(company.getCompanyFullName());
        purLeadTime.setPurCompanySapCode(company.getCompanySapCode());
        purLeadTime.setPurCompanySrmCode(company.getCompanyCode());

        purLeadTime.setPurUserId(loginUser.getId());
        purLeadTime.setPurUserName(loginUser.getNickName());

        purLeadTime.setCreateTime(new Date());
        purLeadTime.setUpdateTime(new Date());
        purLeadTime.setIsEnable(Constant.YES_INT);

        //转换一下格式，数据库里面为null值的情况,防止前端传入字符串空值""
        String materialCode = purLeadTime.getMaterialCode();
        String supCompanySapCode = purLeadTime.getSupCompanySapCode();
        if(StringUtils.isBlank(materialCode)){
            purLeadTime.setMaterialCode(null);
        }
        if(StringUtils.isBlank(supCompanySapCode)){
            purLeadTime.setSupCompanySapCode(null);
        }

        //创建的时候需要校验
        this.filter(purLeadTime);

        this.purLeadTimeMapper.insert(purLeadTime);

    }

    /**
     * 校验一下是否可以创建
     * @param purLeadTime
     */
    private void filter(PurLeadTime purLeadTime) {

        String factoryType = purLeadTime.getFactoryType();
        String materialCode = purLeadTime.getMaterialCode();
        String supCompanySapCode = purLeadTime.getSupCompanySapCode();

        //1、工厂，物料编码，供应商编码都不为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isNotBlank(materialCode)
                &&StringUtils.isNotBlank(supCompanySapCode)){

            PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())

                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andMaterialCodeEqualTo(materialCode)
                    .andSupCompanySapCodeEqualTo(supCompanySapCode);

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if(i>0){
                throw new CommonException("已存在相同的工厂，物料编码，供应商编码的数据，不能再新建!");
            }

        }

        //2、工厂，供应商编码不为空，但是物料编码为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isNotBlank(supCompanySapCode)
                &&StringUtils.isBlank(materialCode)){

            PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())

                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)

                    .andMaterialCodeIsNull();

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if(i>0){
                throw new CommonException("已存在相同的工厂,供应商编码的数据，不能再新建!");
            }


            /*PurLeadTimeExample purLeadTimeExample2 =new PurLeadTimeExample();
            purLeadTimeExample2.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())

                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())
                    .andSupCompanySapCodeEqualTo(supCompanySapCode)

                    .andMaterialCodeNotEqualTo("");

            int i2 = this.purLeadTimeMapper.countByExample(purLeadTimeExample2);
            if(i2>0){
                throw new CommonException("已存在相同的工厂,供应商编码的数据，不能再新建!");
            }*/

        }

        //3、工厂，供应商编码为空和物料编码都为空的时候
        if(StringUtils.isNotBlank(factoryType)
                &&StringUtils.isBlank(supCompanySapCode)
                &&StringUtils.isBlank(materialCode)){

            PurLeadTimeExample purLeadTimeExample =new PurLeadTimeExample();
            purLeadTimeExample.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())
                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())

                    .andSupCompanySapCodeIsNull()
                    .andMaterialCodeIsNull();

            int i = this.purLeadTimeMapper.countByExample(purLeadTimeExample);
            if(i>0){
                throw new CommonException("已存在相同的工厂，不能再新建!");
            }


           /* PurLeadTimeExample purLeadTimeExample2 =new PurLeadTimeExample();
            purLeadTimeExample2.createCriteria()
                    .andIsEnableEqualTo(Constant.YES_INT)
                    .andPurCompanyIdEqualTo(purLeadTime.getPurCompanyId())
                    .andFactoryTypeEqualTo(purLeadTime.getFactoryType())

                    .andSupCompanySapCodeNotEqualTo("")
                    .andMaterialCodeNotEqualTo("");

            int i2 = this.purLeadTimeMapper.countByExample(purLeadTimeExample2);
            if(i2>0){
                throw new CommonException("已存在相同的工厂，不能再新建!");
            }*/

        }
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Override
    public void addObj(PurLeadTime t) {
        this.purLeadTimeMapper.insertSelective(t);
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.purLeadTimeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Override
    public void modifyObj(PurLeadTime t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.purLeadTimeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="purLeadTime", keyGenerator="redisKeyGenerator")
    @Override
    public PurLeadTime queryObjById(String id) {
        return this.purLeadTimeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="purLeadTime", keyGenerator="redisKeyGenerator")
    @Override
    public List<PurLeadTime> queryAllObjByExample(PurLeadTimeExample example) {
        return this.purLeadTimeMapper.selectByExample(example);
    }

    @Cacheable(value="purLeadTime", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<PurLeadTime> queryObjByPage(PurLeadTimeExample example) {
        PageView<PurLeadTime> pageView = example.getPageView();
        pageView.setQueryResult(this.purLeadTimeMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<PurLeadTime> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (PurLeadTime record : arg0) {
			this.purLeadTimeMapper.insertSelective(record);
		}
	}

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
	@Override
	public void deleteByExample(PurLeadTimeExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.purLeadTimeMapper.deleteByExample(arg0);
	}

    @CacheEvict(value={"purLeadTime"}, allEntries=true)
	@Override
	public void importFromExcel(Project project, Company currentCompany, User loginUser, List<PurLeadTime> list) {
    	if (CollectionUtils.isEmpty(list)) {
    		return;
    	}
		
		this.validAndFillData(project, currentCompany, loginUser, list);
		this.addAll(list);
		
	}

    /**
     * 校验数据的有效性并填充数据
     * @param project
     * @param currentCompany
     * @param loginUser
     * @param list
     */
	private void validAndFillData(Project project, Company currentCompany, User loginUser, List<PurLeadTime> list) {

		String projectId = project.getId();
		String purCompanyId = currentCompany.getId();
		String purCompanyName = currentCompany.getCompanyName();
		String purCompanyFullName = currentCompany.getCompanyFullName();
		String purCompanySapCode = currentCompany.getCompanySapCode();
		String purCompanySrmCode = currentCompany.getCompanyCode();
		String purUserId = loginUser.getId();
		String purUserName = loginUser.getUsername();
		Set<String> supCompanySapCodeSet = new HashSet<>();
		Set<String> materialCodeSet = new HashSet<>();
		for (PurLeadTime purLeadTime : list) {
			String supCompanySapCode = purLeadTime.getSupCompanySapCode();
			String materialCode = purLeadTime.getMaterialCode();
			if (StringUtils.isBlank(supCompanySapCode)) {
				throw new CommonException("供应商编码不能为空，请检查！");
			}
			if (StringUtils.isBlank(materialCode)) {
				throw new CommonException("物料编码不能为空，请检查！");
			}
			supCompanySapCodeSet.add(supCompanySapCode);
			materialCodeSet.add(materialCode);
		}
		Map<String, Company> companyMap = this.validSupCompanySapCode(supCompanySapCodeSet);
		Map<String, Material> materialMap = this.validMaterialCode(materialCodeSet);
		Date now = new Date();
		for (PurLeadTime purLeadTime : list) {
			purLeadTime.setProjectId(projectId);
			purLeadTime.setPurCompanyId(purCompanyId);
			purLeadTime.setPurCompanyName(purCompanyName);
			purLeadTime.setPurCompanyFullName(purCompanyFullName);
			purLeadTime.setPurCompanySapCode(purCompanySapCode);
			purLeadTime.setPurCompanySrmCode(purCompanySrmCode);
			purLeadTime.setPurUserId(purUserId);
			purLeadTime.setPurUserName(purUserName);
			purLeadTime.setCreateTime(now);
			purLeadTime.setIsEnable(Constant.YES_INT);
			Company company = companyMap.get(purLeadTime.getSupCompanySapCode());
			purLeadTime.setSupCompanyId(company.getId());
			purLeadTime.setSupCompanyName(company.getCompanyName());
			purLeadTime.setSupCompanyFullName(company.getCompanyFullName());
			purLeadTime.setSupCompanySrmCode(company.getCompanyCode());
			Material material = materialMap.get(purLeadTime.getMaterialCode());
			purLeadTime.setMaterialDesc(material.getMaterialName());
		}
        
	}

	private Map<String, Material> validMaterialCode(Set<String> materialCodeSet) {
		MaterialExample example = new MaterialExample();
		example.createCriteria().andMaterialCodeIn(new ArrayList<>(materialCodeSet));
		List<Material> materials = this.materialService.queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(materials)) {
			throw new CommonException("填写的物料编码在物料主数据中都不存在");
		}
		Set<String> materialCodes = materials.stream().map(Material::getMaterialCode).collect(Collectors.toSet());
		materialCodeSet.removeAll(materialCodes);
        if (CollectionUtils.isNotEmpty(materialCodeSet)) {
            throw new CommonException(String.format("填写的物料编码必须存在于物料主数据中，请检查：%s", StringUtils.join(materialCodeSet, ";")));
        }
		Map<String, Material> materialMap = new HashMap<>();
		for (Material material : materials) {
			materialMap.put(material.getMaterialCode(), material);
		}
		return materialMap;
	}

	private Map<String, Company> validSupCompanySapCode(Set<String> supCompanySapCodeSet) {
		CompanyExample example = new CompanyExample();
		example.createCriteria().andCompanySapCodeIn(new ArrayList<>(supCompanySapCodeSet));
		List<Company> companies = this.companyService.queryAllObjByExample(example);
		if (CollectionUtils.isEmpty(companies)) {
            throw new CommonException("填写的供应商代码在系统中不存在");
        }
        Set<String> supCompanySapCodes = companies.stream().map(Company::getCompanySapCode).collect(Collectors.toSet());
        supCompanySapCodeSet.removeAll(supCompanySapCodes);
        if (CollectionUtils.isNotEmpty(supCompanySapCodeSet)) {
            throw new CommonException(String.format("填写的供应商代码必须存在于系统中，请检查：%s", StringUtils.join(supCompanySapCodeSet, ";")));
        }
        Map<String, Company> companyMap = new HashMap<>();
        for (Company company : companies) {
        	companyMap.put(company.getCompanySapCode(), company);
        }
		return companyMap;
	}
}