package com.els.base.leadtime.web.controller;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.leadtime.entity.PurLeadTime;
import com.els.base.leadtime.entity.PurLeadTimeExample;
import com.els.base.leadtime.service.PurLeadTimeService;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import jxl.write.WritableWorkbook;

@Api(value="订单管理-交货单提前期")
@Controller
@RequestMapping("purLeadTime")
public class PurLeadTimeController {
    @Resource
    protected PurLeadTimeService purLeadTimeService;

    @ApiOperation(httpMethod="POST", value="创建订单管理-交货单提前期")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody PurLeadTime purLeadTime) {
        this.purLeadTimeService.create(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(),purLeadTime);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑订单管理-交货单提前期")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurLeadTime purLeadTime) {
        Assert.isNotBlank(purLeadTime.getId(), "id 为空，保存失败");
        this.purLeadTimeService.edit(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(),purLeadTime);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除订单管理-交货单提前期")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        Assert.isNotBlank(id, "删除失败,id不能为空");
        this.purLeadTimeService.deleteObjById(id);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod="POST", value="批量删除订单管理-交货单提前期")
    @RequestMapping("service/deleteByIds")
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, "删除失败,ids不能为空");
        this.purLeadTimeService.deleteObjByIds(ids);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询订单管理-交货单提前期")
    @ApiImplicitParams({ 
		@ApiImplicitParam( name = "pageNo",required = false,value = "所在页", paramType = "query", dataType = "String", defaultValue = "0" ),  
		@ApiImplicitParam( name = "pageSize", required = false, value = "每页数量", paramType = "query", dataType = "String", defaultValue = "10" ),  
		@ApiImplicitParam( name = "wapper", required = false, value = "查询条件,属性名请参考 PurLeadTime", paramType = "body", dataType = "QueryParamWapper" )  
	}) 
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<PurLeadTime>> findByPage( 
		@RequestParam(defaultValue="0") int pageNo,  
		@RequestParam(defaultValue="10") int pageSize, 
		@RequestBody(required=false) QueryParamWapper wapper) {
        PurLeadTimeExample example = new PurLeadTimeExample();
        example.setPageView(new PageView<PurLeadTime>(pageNo, pageSize));
        
        PurLeadTimeExample.Criteria criteria = example.createCriteria();
        //填写具体的查询条件，例如
        criteria.andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
                .andIsEnableEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample(example, wapper);
        }
        
        PageView<PurLeadTime> pageData = this.purLeadTimeService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod = "GET", value = "下载EXCEL模版")
    @RequestMapping("service/downloadExcelTemplate")
    @ResponseBody
    public void downloadExcelTemplate(HttpServletResponse response) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = this.getImportExcelHeader();
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        header.append("filename=\"" + URLEncoder.encode("送货单提前期控制.xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        OutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, null, "送货单提前期控制", null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
    }
    
    @ApiOperation(value = "导入Excel", httpMethod = "POST")
    @RequestMapping(value = "service/importFromExcel")
    @ResponseBody
    public ResponseResult<String> importFromExcel(MultipartHttpServletRequest request) {
        Map<String, MultipartFile> fileMap = request.getFileMap();
        MultipartFile file = this.vaildExcelFile(fileMap);

        List<TitleAndModelKey> titleAndModelKeys = this.getImportExcelHeader();

        try {
            List<PurLeadTime> list = ExcelUtils.importExcelDataToMap(file.getInputStream(), 0, 1, 0, titleAndModelKeys,
            		PurLeadTime.class);

            purLeadTimeService.importFromExcel(ProjectUtils.getProject(), CompanyUtils.currentCompany(), SpringSecurityUtils.getLoginUser(), list);

        } catch (Exception e) {
            e.printStackTrace();
            throw new CommonException("导入异常：" + e.getMessage());
        }

        return ResponseResult.success();
    }
    
    @ApiOperation(httpMethod = "GET", value = "送货单提前期控制excel导出")
    @RequestMapping("service/exportExcel")
    @ResponseBody
    public void exportExcel(String queryParams, HttpServletResponse response) throws Exception {
        List<TitleAndModelKey> titleAndModelKeys = this.getExportExcelHeader();
        PurLeadTimeExample example = new PurLeadTimeExample();
        PurLeadTimeExample.Criteria criteria = example.createCriteria();
        criteria.andPurCompanyIdEqualTo(ProjectUtils.getCompanyId())
        .andIsEnableEqualTo(Constant.YES_INT);
        if (StringUtils.isNotEmpty(queryParams)) {
            QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                    QueryParamWapper.class);
            CriteriaUtils.addCriterion(criteria, queryParamWapper);
        }
        example.setOrderByClause(" CREATE_TIME DESC");
        List<PurLeadTime> purLeadTimes = this.purLeadTimeService.queryAllObjByExample(example);
        response.reset();
        StringBuffer header = new StringBuffer("attachment;");
        String now = new SimpleDateFormat("yyyyMMddHHmmss").format(new Date());
        header.append("filename=\"" + URLEncoder.encode("送货单提前期控制" + now + ".xls", "UTF-8") + "\";");
        response.setHeader("Content-Disposition", header.toString());
        response.setCharacterEncoding("UTF-8");
        response.setContentType("application/vnd.ms-excel");
        OutputStream outputStream = response.getOutputStream();
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, purLeadTimes, "送货单提前期控制" + now, null, 0);
        writableWorkbook.write();
        outputStream.flush();
        writableWorkbook.close();
        outputStream.close();
    }

	private List<TitleAndModelKey> getImportExcelHeader() {
		List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("限制天数", "daysNumber"));


        return titleAndModelKeys;
	}
	
	private List<TitleAndModelKey> getExportExcelHeader() {
		List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factoryType"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanySapCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料名称", "materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("限制天数", "daysNumber"));


        return titleAndModelKeys;
	}
	
	private MultipartFile vaildExcelFile(Map<String, MultipartFile> fileMap) {
        if (MapUtils.isEmpty(fileMap)) {
            throw new CommonException("上传文件为空", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("只接受单个文件导入");
        }

        Set<String> fileKeySet = fileMap.keySet();// 获取所有的key集合

        Iterator<String> keyIterator = fileKeySet.iterator();
        MultipartFile file = null;
        while (keyIterator.hasNext()) {
            file = fileMap.get(keyIterator.next());
        }

        if (!file.getOriginalFilename().endsWith(".xls")) {
            throw new CommonException("导入文件的格式不正确，目前只支持xls");
        }

        return file;
    }
    
}