package com.els.base.orderchange.command;

import com.els.base.command.AbstractPurchaseCommand;
import com.els.base.command.PurchaseInvorker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.orderchange.entity.PurchaseOrderChange;
import com.els.base.orderchange.entity.PurchaseOrderChangeExample;
import com.els.base.orderchange.util.BillStatusConfirmEnum;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.List;
import java.util.stream.Collectors;

/**
 * 供应商变更清单确认命令
 */
public class SupConfirmCommand extends AbstractPurchaseCommand<String> {

    Logger logger = LoggerFactory.getLogger(this.getClass());

    List<PurchaseOrderChange> purchaseOrderChangeList;

    public SupConfirmCommand(List<PurchaseOrderChange> purchaseOrderChangeList) {
        this.purchaseOrderChangeList = purchaseOrderChangeList;
    }

    @Override
    public String execute(PurchaseInvorker billInvorker) {

        //校验
        this.validate(purchaseOrderChangeList);

        //数据处理
        this.process(purchaseOrderChangeList);

        return null;
    }

    private void process(List<PurchaseOrderChange> list) {

        boolean debugEnabled = logger.isDebugEnabled();
        if (debugEnabled){
            logger.info("1、采购订单需要变更为已经确认");
        }
        this.updatePurOrder(list);


        if (debugEnabled) {
            logger.info("2、变更供应商端订单为已确认");
        }
        this.updateSupOrder(list);


        if (debugEnabled) {
            logger.info("3、订单变更订单里面的状态也变为已确认");
        }
        this.updateOrderChange(list);

    }


    /**
     * 3、订单变更订单里面的状态也变为已确认
     *
     * @param list
     */
    private void updateOrderChange(List<PurchaseOrderChange> list) {
        PurchaseOrderChange purchaseOrderChange = new PurchaseOrderChange();
        purchaseOrderChange.setConfirmStatus(BillStatusConfirmEnum.STATUS_CONFIRM.getCode());

        List<String> ids = list.stream().map(PurchaseOrderChange::getId).collect(Collectors.toList());

        PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
        example.createCriteria().andIdIn(ids);
        this.getPurchaseInvorker().getPurchaseOrderChangeService().updateByExampleSelective(purchaseOrderChange, example);
    }


    /**
     * 2、变更供应商端订单为已确认
     *
     * @param list
     */
    private void updateSupOrder(List<PurchaseOrderChange> list) {

        // TODO
    }

    /**
     * 1、采购订单需要变更为已经确认
     *
     * @param list
     */
    private void updatePurOrder(List<PurchaseOrderChange> list) {

        // TODO
    }


    /**
     * 校验逻辑，待优化 TODO
     *
     * @param list
     */
    private void validate(List<PurchaseOrderChange> list) {

        Assert.isNotEmpty(list, "请选择需要操作的数据");
        for (int i = 0; i < list.size(); i++) {
            Assert.isNotNull(list.get(i), "变更对象不能为空！");
            String id = list.get(i).getId();
            Assert.isNotBlank(id, "变更ID不能为空！");
            PurchaseOrderChangeExample example = new PurchaseOrderChangeExample();
            PurchaseOrderChangeExample.Criteria criteria = example.createCriteria();
            criteria.andIdEqualTo(id);
            criteria.andStatusEqualTo("NEW");
            List<PurchaseOrderChange> changeOrders = this.getPurchaseInvorker().getPurchaseOrderChangeService().queryAllObjByExample(example);
            Assert.isNotEmpty(changeOrders, "未找到此订单");
            PurchaseOrderChange changeOrder = changeOrders.get(0);
            if (changeOrder != null && changeOrder.getConfirmStatus().equals("2")) {
                throw new CommonException("该变更申请已再次发送，此次操作的数据为旧数据，请重新选择确认的数据。", "old_data", "该变更申请已再次发送，");
            }
        }
    }

}
