package com.els.base.orderchange.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="采购变更查询")
public class PurchaseOrderChange implements Serializable {
    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("供应商ID")
    private String supCompanyId;

    @ApiModelProperty("供应商编码")
    private String supCompanySapCode;

    @ApiModelProperty("供应商SAP编码")
    private String supCompanySrmCode;

    @ApiModelProperty("供应商srm编码")
    private String supCompanyFullName;

    @ApiModelProperty("供应商简称")
    private String supCompanyName;

    @ApiModelProperty("采购订单号")
    private String orderNo;

    @ApiModelProperty("采购订单行项目")
    private String orderItemNo;

    @ApiModelProperty("物料编码")
    private String materialCode;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("订单数量")
    private BigDecimal quantity;

    @ApiModelProperty("申请取消（数量）")
    private BigDecimal cancellApplyNum;

    @ApiModelProperty("单位")
    private String unit;

    @ApiModelProperty("净价")
    private BigDecimal noTaxPrice;

    @ApiModelProperty("价格单位")
    private BigDecimal priceUnit;

    @ApiModelProperty("单价")
    private String price;

    @ApiModelProperty("金额")
    private String amount;

    @ApiModelProperty("币别")
    private String currency;

    @ApiModelProperty("凭证日期")
    private Date voucherDate;

    @ApiModelProperty("最新交货日期")
    private Date deliveryDate;

    @ApiModelProperty("申请日期(变更单据产生的日期)")
    private Date applyDate;

    @ApiModelProperty("状态:new为新的变更申请、close为更改订单")
    private String status;

    @ApiModelProperty("同意取消数量")
    private BigDecimal agreeCancelQuantity;

    @ApiModelProperty("供应商物料编码")
    private String supplierMaterialCode;

    @ApiModelProperty("供应商物料描述")
    private String supplierMaterialDesc;

    @ApiModelProperty("已收货数量")
    private BigDecimal receiveQuantity;

    @ApiModelProperty("在途数量")
    private BigDecimal onwayQuantity;

    @ApiModelProperty("备注")
    private String remark;

    @ApiModelProperty("确认状态: 0,未确认 1,已确认")
    private String confirmStatus;

    @ApiModelProperty("订单日期")
    private Date orderDate;

    @ApiModelProperty("采购订单头金额")
    private String orderHeadAmount;

    @ApiModelProperty("头价税合计")
    private BigDecimal headPriceTaxTotal;

    @ApiModelProperty("行价税合计")
    private BigDecimal itemPriceTaxTotal;

    @ApiModelProperty("变更次数")
    private Integer changeTimes;

    @ApiModelProperty("变更前交货日期")
    private Date beforeDeliveryDate;

    @ApiModelProperty("以前交货数量")
    private BigDecimal beforeDeliveryNum;

    @ApiModelProperty("采购公司ID")
    private String purCompanyId;

    @ApiModelProperty("采购公司名称")
    private String purCompanyName;

    @ApiModelProperty("采购公司srm编码")
    private String purCompanySrmCode;

    @ApiModelProperty("采购公司sap编码")
    private String purCompanySapCode;

    @ApiModelProperty("项目描述：具体的项目，比如说南京的地铁1号线，广州地铁一号线等")
    private String projectDesc;

    @ApiModelProperty("WBS号")
    private String wbsNo;

    @ApiModelProperty("WBS号描述")
    private String wbsNoDesc;

    @ApiModelProperty("项目类别描述：一般指的是标准的订单还是外协的订单行")
    private String itemDescription;

    @ApiModelProperty("工厂")
    private String factory;

    @ApiModelProperty("工厂名称")
    private String factoryName;

    @ApiModelProperty("需求跟踪号")
    private String needFollowNo;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getSupCompanyId() {
        return supCompanyId;
    }

    public void setSupCompanyId(String supCompanyId) {
        this.supCompanyId = supCompanyId == null ? null : supCompanyId.trim();
    }

    public String getSupCompanySapCode() {
        return supCompanySapCode;
    }

    public void setSupCompanySapCode(String supCompanySapCode) {
        this.supCompanySapCode = supCompanySapCode == null ? null : supCompanySapCode.trim();
    }

    public String getSupCompanySrmCode() {
        return supCompanySrmCode;
    }

    public void setSupCompanySrmCode(String supCompanySrmCode) {
        this.supCompanySrmCode = supCompanySrmCode == null ? null : supCompanySrmCode.trim();
    }

    public String getSupCompanyFullName() {
        return supCompanyFullName;
    }

    public void setSupCompanyFullName(String supCompanyFullName) {
        this.supCompanyFullName = supCompanyFullName == null ? null : supCompanyFullName.trim();
    }

    public String getSupCompanyName() {
        return supCompanyName;
    }

    public void setSupCompanyName(String supCompanyName) {
        this.supCompanyName = supCompanyName == null ? null : supCompanyName.trim();
    }

    public String getOrderNo() {
        return orderNo;
    }

    public void setOrderNo(String orderNo) {
        this.orderNo = orderNo == null ? null : orderNo.trim();
    }

    public String getOrderItemNo() {
        return orderItemNo;
    }

    public void setOrderItemNo(String orderItemNo) {
        this.orderItemNo = orderItemNo == null ? null : orderItemNo.trim();
    }

    public String getMaterialCode() {
        return materialCode;
    }

    public void setMaterialCode(String materialCode) {
        this.materialCode = materialCode == null ? null : materialCode.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public BigDecimal getQuantity() {
        return quantity;
    }

    public void setQuantity(BigDecimal quantity) {
        this.quantity = quantity;
    }

    public BigDecimal getCancellApplyNum() {
        return cancellApplyNum;
    }

    public void setCancellApplyNum(BigDecimal cancellApplyNum) {
        this.cancellApplyNum = cancellApplyNum;
    }

    public String getUnit() {
        return unit;
    }

    public void setUnit(String unit) {
        this.unit = unit == null ? null : unit.trim();
    }

    public BigDecimal getNoTaxPrice() {
        return noTaxPrice;
    }

    public void setNoTaxPrice(BigDecimal noTaxPrice) {
        this.noTaxPrice = noTaxPrice;
    }

    public BigDecimal getPriceUnit() {
        return priceUnit;
    }

    public void setPriceUnit(BigDecimal priceUnit) {
        this.priceUnit = priceUnit;
    }

    public String getPrice() {
        return price;
    }

    public void setPrice(String price) {
        this.price = price == null ? null : price.trim();
    }

    public String getAmount() {
        return amount;
    }

    public void setAmount(String amount) {
        this.amount = amount == null ? null : amount.trim();
    }

    public String getCurrency() {
        return currency;
    }

    public void setCurrency(String currency) {
        this.currency = currency == null ? null : currency.trim();
    }

    public Date getVoucherDate() {
        return voucherDate;
    }

    public void setVoucherDate(Date voucherDate) {
        this.voucherDate = voucherDate;
    }

    public Date getDeliveryDate() {
        return deliveryDate;
    }

    public void setDeliveryDate(Date deliveryDate) {
        this.deliveryDate = deliveryDate;
    }

    public Date getApplyDate() {
        return applyDate;
    }

    public void setApplyDate(Date applyDate) {
        this.applyDate = applyDate;
    }

    public String getStatus() {
        return status;
    }

    public void setStatus(String status) {
        this.status = status == null ? null : status.trim();
    }

    public BigDecimal getAgreeCancelQuantity() {
        return agreeCancelQuantity;
    }

    public void setAgreeCancelQuantity(BigDecimal agreeCancelQuantity) {
        this.agreeCancelQuantity = agreeCancelQuantity;
    }

    public String getSupplierMaterialCode() {
        return supplierMaterialCode;
    }

    public void setSupplierMaterialCode(String supplierMaterialCode) {
        this.supplierMaterialCode = supplierMaterialCode == null ? null : supplierMaterialCode.trim();
    }

    public String getSupplierMaterialDesc() {
        return supplierMaterialDesc;
    }

    public void setSupplierMaterialDesc(String supplierMaterialDesc) {
        this.supplierMaterialDesc = supplierMaterialDesc == null ? null : supplierMaterialDesc.trim();
    }

    public BigDecimal getReceiveQuantity() {
        return receiveQuantity;
    }

    public void setReceiveQuantity(BigDecimal receiveQuantity) {
        this.receiveQuantity = receiveQuantity;
    }

    public BigDecimal getOnwayQuantity() {
        return onwayQuantity;
    }

    public void setOnwayQuantity(BigDecimal onwayQuantity) {
        this.onwayQuantity = onwayQuantity;
    }

    public String getRemark() {
        return remark;
    }

    public void setRemark(String remark) {
        this.remark = remark == null ? null : remark.trim();
    }

    public String getConfirmStatus() {
        return confirmStatus;
    }

    public void setConfirmStatus(String confirmStatus) {
        this.confirmStatus = confirmStatus == null ? null : confirmStatus.trim();
    }

    public Date getOrderDate() {
        return orderDate;
    }

    public void setOrderDate(Date orderDate) {
        this.orderDate = orderDate;
    }

    public String getOrderHeadAmount() {
        return orderHeadAmount;
    }

    public void setOrderHeadAmount(String orderHeadAmount) {
        this.orderHeadAmount = orderHeadAmount == null ? null : orderHeadAmount.trim();
    }

    public BigDecimal getHeadPriceTaxTotal() {
        return headPriceTaxTotal;
    }

    public void setHeadPriceTaxTotal(BigDecimal headPriceTaxTotal) {
        this.headPriceTaxTotal = headPriceTaxTotal;
    }

    public BigDecimal getItemPriceTaxTotal() {
        return itemPriceTaxTotal;
    }

    public void setItemPriceTaxTotal(BigDecimal itemPriceTaxTotal) {
        this.itemPriceTaxTotal = itemPriceTaxTotal;
    }

    public Integer getChangeTimes() {
        return changeTimes;
    }

    public void setChangeTimes(Integer changeTimes) {
        this.changeTimes = changeTimes;
    }

    public Date getBeforeDeliveryDate() {
        return beforeDeliveryDate;
    }

    public void setBeforeDeliveryDate(Date beforeDeliveryDate) {
        this.beforeDeliveryDate = beforeDeliveryDate;
    }

    public BigDecimal getBeforeDeliveryNum() {
        return beforeDeliveryNum;
    }

    public void setBeforeDeliveryNum(BigDecimal beforeDeliveryNum) {
        this.beforeDeliveryNum = beforeDeliveryNum;
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getPurCompanySrmCode() {
        return purCompanySrmCode;
    }

    public void setPurCompanySrmCode(String purCompanySrmCode) {
        this.purCompanySrmCode = purCompanySrmCode == null ? null : purCompanySrmCode.trim();
    }

    public String getPurCompanySapCode() {
        return purCompanySapCode;
    }

    public void setPurCompanySapCode(String purCompanySapCode) {
        this.purCompanySapCode = purCompanySapCode == null ? null : purCompanySapCode.trim();
    }

    public String getProjectDesc() {
        return projectDesc;
    }

    public void setProjectDesc(String projectDesc) {
        this.projectDesc = projectDesc == null ? null : projectDesc.trim();
    }

    public String getWbsNo() {
        return wbsNo;
    }

    public void setWbsNo(String wbsNo) {
        this.wbsNo = wbsNo == null ? null : wbsNo.trim();
    }

    public String getWbsNoDesc() {
        return wbsNoDesc;
    }

    public void setWbsNoDesc(String wbsNoDesc) {
        this.wbsNoDesc = wbsNoDesc == null ? null : wbsNoDesc.trim();
    }

    public String getItemDescription() {
        return itemDescription;
    }

    public void setItemDescription(String itemDescription) {
        this.itemDescription = itemDescription == null ? null : itemDescription.trim();
    }

    public String getFactory() {
        return factory;
    }

    public void setFactory(String factory) {
        this.factory = factory == null ? null : factory.trim();
    }

    public String getFactoryName() {
        return factoryName;
    }

    public void setFactoryName(String factoryName) {
        this.factoryName = factoryName == null ? null : factoryName.trim();
    }

    public String getNeedFollowNo() {
        return needFollowNo;
    }

    public void setNeedFollowNo(String needFollowNo) {
        this.needFollowNo = needFollowNo == null ? null : needFollowNo.trim();
    }
}