package com.els.base.purchase.dao;

import com.els.base.purchase.entity.*;

import org.apache.ibatis.annotations.Param;

import java.util.Date;
import java.util.List;
import java.util.Map;

public interface PurchaseOrderItemMapper {
    int countByExample(PurchaseOrderItemExample example);

    int deleteByExample(PurchaseOrderItemExample example);

    int deleteByPrimaryKey(String id);

    int insert(PurchaseOrderItem record);

    int insertSelective(PurchaseOrderItem record);

    List<PurchaseOrderItem> selectByExample(PurchaseOrderItemExample example);

    PurchaseOrderItem selectByPrimaryKey(String id);

    int updateByExampleSelective(@Param("record") PurchaseOrderItem record, @Param("example") PurchaseOrderItemExample example);

    int updateByExample(@Param("record") PurchaseOrderItem record, @Param("example") PurchaseOrderItemExample example);

    int updateByPrimaryKeySelective(PurchaseOrderItem record);

    int updateByPrimaryKey(PurchaseOrderItem record);

    int insertBatch(List<PurchaseOrderItem> list);

    List<PurchaseOrderItem> selectByExampleByPage(PurchaseOrderItemExample example);

    List<PurchaseOrderItem> selectFirstOrderByExampleByPage(PurchaseOrderItemExample example);
    /**
     * 根据订单id号，保存当前数据到历史记录表
     * @param id
     * @param cause
     * @param version
     * @return
     */
    int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId, @Param("cause") String cause, @Param("version") String version);

    /**
     * 根据查询条件，查询历史纪录
     * @param example
     * @return
     */
    List<PurchaseOrderItem> selectHisByExampleByPage(PurchaseOrderItemExample example);
    /**
     * 分页查询采购订单行
     * @param map
     * @return
     */
    List<PurchaseOrderItem> selectPurchaseOrderItemByPage(Map<String, Object> map);
    /**
     * 查看最新的历史版本
     * @return
     */
    String selectMaxVersion();
    /**
     * 根据查询条件，查询历史纪录
     * @param example
     * @return
     */
    List<PurchaseOrderItem> selectHisByExample(PurchaseOrderItem purchaseOrderItem);
    /**
     * 采购订单导出查询
     * @param supplierOrder
     * @return
     */
    List<PurchaseOrderItem> selectForExcel(PurchaseOrderExample purchaseOrder);


    List<PurchaseOrderItem> selectForExcelFirst(PurchaseOrderExample purchaseOrder);

    /**
     * 采购订单报表
     * @param supplierOrder
     * @return
     */
    List<PurchaseOrderReport> selectPurchOrderReportByPage(PurchaseOrderReportExample example);
    /**
     * 采购订单报表导出excel
     * @param supplierOrder
     * @return
     */
    List<PurchaseOrderReport> selectPurchOrderReportforExcel(PurchaseOrderReportExample example);

    /**
     * 采购订单报表
     * @param supplierOrder
     * @return
     */
    List<PurchaseOrderReport> selectReturnPOByPage(PurchaseOrderReportExample example);

    /**
     *
     * @param map
     * @return
     */
    int countOrderHisByExample(Map<String, Object> map);

    /**
     * 计算在途数量,进行累加
     * @param materialCode
     * @param companySapCode
     * @return
     */
    double calculateOnwayQuantity(@Param("materialCode")String materialCode,@Param("companySapCode") String companySapCode);

    /**
     * 根据登录用户查询订单号
     * @param userName 登录用户
     */
    List<String> queryOrderNoByUserName(@Param("userName") String userName,
                                        @Param("isEnable") Integer isEnable);
    
    /**
     * 根据登录用户查询订单号
     * @param userName 登录用户
     */
    List<String> queryOrderNoAll(@Param("firstFlag") Integer firstFlag,
                                        @Param("isEnable") Integer isEnable);
    
    /**
     * 超期订单行
     * 
     */
	List<PurchaseOrderItem> purFindOverdue(@Param("purUserId")String purUserId, @Param("date")Date date);
}

