package com.els.base.purchase.dao.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.utils.SpringContextHolder;

public class PurchaseOrderItemTypeHandler implements TypeHandler<List<PurchaseOrderItem>> {

	@Override
	public void setParameter(PreparedStatement ps, int i, List<PurchaseOrderItem> parameter, JdbcType jdbcType)
			throws SQLException {
		// TODO Auto-generated method stub

	}

	@Override
	public List<PurchaseOrderItem> getResult(ResultSet rs, String columnName) throws SQLException {
		PurchaseOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(PurchaseOrderItemService.class);
		String poId = rs.getString(columnName);

		PurchaseOrderItemExample example = new PurchaseOrderItemExample();
		example.createCriteria().andOrderIdEqualTo(poId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

	@Override
	public List<PurchaseOrderItem> getResult(ResultSet rs, int columnIndex) throws SQLException {
		PurchaseOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(PurchaseOrderItemService.class);
		String poId = rs.getString(columnIndex);

		PurchaseOrderItemExample example = new PurchaseOrderItemExample();
		example.createCriteria().andOrderIdEqualTo(poId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

	@Override
	public List<PurchaseOrderItem> getResult(CallableStatement cs, int columnIndex) throws SQLException {
		PurchaseOrderItemService purchaseOrderItemService = SpringContextHolder.getOneBean(PurchaseOrderItemService.class);
		String poId = cs.getString(columnIndex);

		PurchaseOrderItemExample example = new PurchaseOrderItemExample();
		example.createCriteria().andOrderIdEqualTo(poId);

		return purchaseOrderItemService.queryAllObjByExample(example);
	}

}
