package com.els.base.purchase.dao.handler;

import java.sql.CallableStatement;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

import org.apache.ibatis.type.JdbcType;
import org.apache.ibatis.type.TypeHandler;

import com.els.base.purchase.entity.ReceiveOrder;
import com.els.base.purchase.service.ReceiveOrderService;
import com.els.base.utils.SpringContextHolder;

public class ReceiveOrderTypeHandler implements TypeHandler<ReceiveOrder> {

	@Override
	public void setParameter(PreparedStatement ps, int i, ReceiveOrder parameter, JdbcType jdbcType)
			throws SQLException {
		// TODO Auto-generated method stub
		
	}

	@Override
	public ReceiveOrder getResult(ResultSet rs, String columnName) throws SQLException {
		String receiveOrderId= rs.getString(columnName);
		
		ReceiveOrderService service = SpringContextHolder.getOneBean(ReceiveOrderService.class);
		ReceiveOrder receiveOrder = service.queryObjById(receiveOrderId);
		
		return receiveOrder;
	}

	@Override
	public ReceiveOrder getResult(ResultSet rs, int columnIndex) throws SQLException {
        String receiveOrderId= rs.getString(columnIndex);
		
		ReceiveOrderService service = SpringContextHolder.getOneBean(ReceiveOrderService.class);
		ReceiveOrder receiveOrder = service.queryObjById(receiveOrderId);
		
		return receiveOrder;
	}

	@Override
	public ReceiveOrder getResult(CallableStatement cs, int columnIndex) throws SQLException {
		String receiveOrderId = cs.getString(columnIndex);
		
		ReceiveOrderService service = SpringContextHolder.getOneBean(ReceiveOrderService.class);
		ReceiveOrder receiveOrder = service.queryObjById(receiveOrderId);
		
		return receiveOrder;
	}

}
