package com.els.base.purchase.entity;

import io.swagger.annotations.ApiModel;
import io.swagger.annotations.ApiModelProperty;
import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;

@ApiModel(value="标签打印记录")
public class LabelPrintRecord implements Serializable {
    @ApiModelProperty("ID")
    private String id;

    @ApiModelProperty("项目ID")
    private String projectId;

    @ApiModelProperty("唯一码，系统自动产生,共19位")
    private String rid;

    @ApiModelProperty("由“供应商代码#生产日期D/C#批次LOT”构成")
    private String ln;

    @ApiModelProperty("供应商id")
    private String companyId;

    @ApiModelProperty("供应商编码")
    private String supplierCode;

    @ApiModelProperty("供应商物料")
    private String supplierMaterial;

    @ApiModelProperty("华阳物料")
    private String material;

    @ApiModelProperty("物料描述")
    private String materialDesc;

    @ApiModelProperty("华阳物料版本")
    private String materialVersion;

    @ApiModelProperty("软件版本SVER")
    private String version;

    @ApiModelProperty("采购单号")
    private String purchaseOrderNo;

    @ApiModelProperty("采购单行号")
    private String purchaseOrderItemNo;

    @ApiModelProperty("采购订单号#采购单行号")
    private String poitem;

    @ApiModelProperty("由“湿敏度MSD等级MsLv（1-2位）#静电防护等级ESDLv（1-2位）#LED亮度等级LedLv（7位）#PCB定义（5位）”构成")
    private String spec;

    @ApiModelProperty("品牌")
    private String brand;

    @ApiModelProperty("产地")
    private String productArea;

    @ApiModelProperty("打印尺寸")
    private String printSize;

    @ApiModelProperty("送货单号")
    private String deliveryOrderNo;

    @ApiModelProperty("生产批次LOT")
    private String productBatch;

    @ApiModelProperty("生产日期")
    private Date productDate;

    @ApiModelProperty("创建日期+时间")
    private Date createTime;

    @ApiModelProperty("创建人")
    private String createUser;

    @ApiModelProperty("最后更新时间")
    private Date lastUpdateTime;

    @ApiModelProperty("最后修改人")
    private String lastUpdateUser;

    @ApiModelProperty("每个内箱包装的物料的数量")
    private String innerPackageQuantity;

    @ApiModelProperty("MSD等级")
    private String msdRank;

    @ApiModelProperty("ESD等级")
    private String esdRank;

    @ApiModelProperty("PCB等级")
    private String pcbRank;

    @ApiModelProperty("LED等级")
    private String ledRank;

    @ApiModelProperty("送货数量")
    private BigDecimal deliveryQuantity;

    @ApiModelProperty("外箱装箱数")
    private Long outterPackageQuantity;

    @ApiModelProperty("物料id")
    private String materialId;

    @ApiModelProperty("供应商名称")
    private String supplierName;

    @ApiModelProperty("客户公司编码")
    private String purCompanyId;

    @ApiModelProperty("客户公司名称")
    private String purCompanyName;

    @ApiModelProperty("供应商物料描述")
    private String supplierMaterialDesc;

    @ApiModelProperty("二维码打印状态,0未打印，1已打印")
    private String printStatus;

    @ApiModelProperty("打印日期")
    private Date printTime;

    @ApiModelProperty("内箱数量")
    private Long innerBoxQuantity;

    @ApiModelProperty("外箱数量")
    private Long outterBoxQuantity;

    @ApiModelProperty("供应商sap编码")
    private String companySapCode;

    @ApiModelProperty("毛重")
    private BigDecimal grossWeight;

    @ApiModelProperty("净重")
    private BigDecimal netWeight;

    @ApiModelProperty("供应商物料ID")
    private String supplierMaterialId;

    private static final long serialVersionUID = 1L;

    public String getId() {
        return id;
    }

    public void setId(String id) {
        this.id = id == null ? null : id.trim();
    }

    public String getProjectId() {
        return projectId;
    }

    public void setProjectId(String projectId) {
        this.projectId = projectId == null ? null : projectId.trim();
    }

    public String getRid() {
        return rid;
    }

    public void setRid(String rid) {
        this.rid = rid == null ? null : rid.trim();
    }

    public String getLn() {
        return ln;
    }

    public void setLn(String ln) {
        this.ln = ln == null ? null : ln.trim();
    }

    public String getCompanyId() {
        return companyId;
    }

    public void setCompanyId(String companyId) {
        this.companyId = companyId == null ? null : companyId.trim();
    }

    public String getSupplierCode() {
        return supplierCode;
    }

    public void setSupplierCode(String supplierCode) {
        this.supplierCode = supplierCode == null ? null : supplierCode.trim();
    }

    public String getSupplierMaterial() {
        return supplierMaterial;
    }

    public void setSupplierMaterial(String supplierMaterial) {
        this.supplierMaterial = supplierMaterial == null ? null : supplierMaterial.trim();
    }

    public String getMaterial() {
        return material;
    }

    public void setMaterial(String material) {
        this.material = material == null ? null : material.trim();
    }

    public String getMaterialDesc() {
        return materialDesc;
    }

    public void setMaterialDesc(String materialDesc) {
        this.materialDesc = materialDesc == null ? null : materialDesc.trim();
    }

    public String getMaterialVersion() {
        return materialVersion;
    }

    public void setMaterialVersion(String materialVersion) {
        this.materialVersion = materialVersion == null ? null : materialVersion.trim();
    }

    public String getVersion() {
        return version;
    }

    public void setVersion(String version) {
        this.version = version == null ? null : version.trim();
    }

    public String getPurchaseOrderNo() {
        return purchaseOrderNo;
    }

    public void setPurchaseOrderNo(String purchaseOrderNo) {
        this.purchaseOrderNo = purchaseOrderNo == null ? null : purchaseOrderNo.trim();
    }

    public String getPurchaseOrderItemNo() {
        return purchaseOrderItemNo;
    }

    public void setPurchaseOrderItemNo(String purchaseOrderItemNo) {
        this.purchaseOrderItemNo = purchaseOrderItemNo == null ? null : purchaseOrderItemNo.trim();
    }

    public String getPoitem() {
        return poitem;
    }

    public void setPoitem(String poitem) {
        this.poitem = poitem == null ? null : poitem.trim();
    }

    public String getSpec() {
        return spec;
    }

    public void setSpec(String spec) {
        this.spec = spec == null ? null : spec.trim();
    }

    public String getBrand() {
        return brand;
    }

    public void setBrand(String brand) {
        this.brand = brand == null ? null : brand.trim();
    }

    public String getProductArea() {
        return productArea;
    }

    public void setProductArea(String productArea) {
        this.productArea = productArea == null ? null : productArea.trim();
    }

    public String getPrintSize() {
        return printSize;
    }

    public void setPrintSize(String printSize) {
        this.printSize = printSize == null ? null : printSize.trim();
    }

    public String getDeliveryOrderNo() {
        return deliveryOrderNo;
    }

    public void setDeliveryOrderNo(String deliveryOrderNo) {
        this.deliveryOrderNo = deliveryOrderNo == null ? null : deliveryOrderNo.trim();
    }

    public String getProductBatch() {
        return productBatch;
    }

    public void setProductBatch(String productBatch) {
        this.productBatch = productBatch == null ? null : productBatch.trim();
    }

    public Date getProductDate() {
        return productDate;
    }

    public void setProductDate(Date productDate) {
        this.productDate = productDate;
    }

    public Date getCreateTime() {
        return createTime;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public String getCreateUser() {
        return createUser;
    }

    public void setCreateUser(String createUser) {
        this.createUser = createUser == null ? null : createUser.trim();
    }

    public Date getLastUpdateTime() {
        return lastUpdateTime;
    }

    public void setLastUpdateTime(Date lastUpdateTime) {
        this.lastUpdateTime = lastUpdateTime;
    }

    public String getLastUpdateUser() {
        return lastUpdateUser;
    }

    public void setLastUpdateUser(String lastUpdateUser) {
        this.lastUpdateUser = lastUpdateUser == null ? null : lastUpdateUser.trim();
    }

    public String getInnerPackageQuantity() {
        return innerPackageQuantity;
    }

    public void setInnerPackageQuantity(String innerPackageQuantity) {
        this.innerPackageQuantity = innerPackageQuantity == null ? null : innerPackageQuantity.trim();
    }

    public String getMsdRank() {
        return msdRank;
    }

    public void setMsdRank(String msdRank) {
        this.msdRank = msdRank == null ? null : msdRank.trim();
    }

    public String getEsdRank() {
        return esdRank;
    }

    public void setEsdRank(String esdRank) {
        this.esdRank = esdRank == null ? null : esdRank.trim();
    }

    public String getPcbRank() {
        return pcbRank;
    }

    public void setPcbRank(String pcbRank) {
        this.pcbRank = pcbRank == null ? null : pcbRank.trim();
    }

    public String getLedRank() {
        return ledRank;
    }

    public void setLedRank(String ledRank) {
        this.ledRank = ledRank == null ? null : ledRank.trim();
    }

    public BigDecimal getDeliveryQuantity() {
        return deliveryQuantity;
    }

    public void setDeliveryQuantity(BigDecimal deliveryQuantity) {
        this.deliveryQuantity = deliveryQuantity;
    }

    public Long getOutterPackageQuantity() {
        return outterPackageQuantity;
    }

    public void setOutterPackageQuantity(Long outterPackageQuantity) {
        this.outterPackageQuantity = outterPackageQuantity;
    }

    public String getMaterialId() {
        return materialId;
    }

    public void setMaterialId(String materialId) {
        this.materialId = materialId == null ? null : materialId.trim();
    }

    public String getSupplierName() {
        return supplierName;
    }

    public void setSupplierName(String supplierName) {
        this.supplierName = supplierName == null ? null : supplierName.trim();
    }

    public String getPurCompanyId() {
        return purCompanyId;
    }

    public void setPurCompanyId(String purCompanyId) {
        this.purCompanyId = purCompanyId == null ? null : purCompanyId.trim();
    }

    public String getPurCompanyName() {
        return purCompanyName;
    }

    public void setPurCompanyName(String purCompanyName) {
        this.purCompanyName = purCompanyName == null ? null : purCompanyName.trim();
    }

    public String getSupplierMaterialDesc() {
        return supplierMaterialDesc;
    }

    public void setSupplierMaterialDesc(String supplierMaterialDesc) {
        this.supplierMaterialDesc = supplierMaterialDesc == null ? null : supplierMaterialDesc.trim();
    }

    public String getPrintStatus() {
        return printStatus;
    }

    public void setPrintStatus(String printStatus) {
        this.printStatus = printStatus == null ? null : printStatus.trim();
    }

    public Date getPrintTime() {
        return printTime;
    }

    public void setPrintTime(Date printTime) {
        this.printTime = printTime;
    }

    public Long getInnerBoxQuantity() {
        return innerBoxQuantity;
    }

    public void setInnerBoxQuantity(Long innerBoxQuantity) {
        this.innerBoxQuantity = innerBoxQuantity;
    }

    public Long getOutterBoxQuantity() {
        return outterBoxQuantity;
    }

    public void setOutterBoxQuantity(Long outterBoxQuantity) {
        this.outterBoxQuantity = outterBoxQuantity;
    }

    public String getCompanySapCode() {
        return companySapCode;
    }

    public void setCompanySapCode(String companySapCode) {
        this.companySapCode = companySapCode == null ? null : companySapCode.trim();
    }

    public BigDecimal getGrossWeight() {
        return grossWeight;
    }

    public void setGrossWeight(BigDecimal grossWeight) {
        this.grossWeight = grossWeight;
    }

    public BigDecimal getNetWeight() {
        return netWeight;
    }

    public void setNetWeight(BigDecimal netWeight) {
        this.netWeight = netWeight;
    }

    public String getSupplierMaterialId() {
        return supplierMaterialId;
    }

    public void setSupplierMaterialId(String supplierMaterialId) {
        this.supplierMaterialId = supplierMaterialId == null ? null : supplierMaterialId.trim();
    }
}