package com.els.base.purchase.event;

import java.util.List;

import org.springframework.context.ApplicationEvent;

import com.els.base.core.entity.project.Project;

public class DeliveryOrderCreatedEvent extends ApplicationEvent{

	private List<String> deliveryOrderIdList;
	public DeliveryOrderCreatedEvent(List<String> source) {
		super(source);
		this.deliveryOrderIdList = source;
	}
	
	/**
	 * @param source
	 * @param companyId 所属公司id
	 * @param projectId 项目id
	 */
	public DeliveryOrderCreatedEvent(List<String> source,String companyId,Project project) {
		super(source);
		this.deliveryOrderIdList = source;
	}

	private static final long serialVersionUID = 1L;
	public List<String> getDeliveryOrder() {
		return deliveryOrderIdList;
	}

}
