package com.els.base.purchase.event;

import java.util.ArrayList;
import java.util.List;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.ApplicationEvent;

import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.event.listener.PurchaseOrderUpdateSuccessListener;

public class PurchaseOrderUpdateSuccessEvent extends ApplicationEvent{
    private static Logger logger= LoggerFactory.getLogger(PurchaseOrderUpdateSuccessEvent.class);
	List<PurchaseOrderItem> items=new ArrayList<PurchaseOrderItem>();
	private static final long serialVersionUID = 1L;

	public List<PurchaseOrderItem> getItems() {
		return items;
	}

	public void setItems(List<PurchaseOrderItem> items) {
		this.items = items;
	}

	public PurchaseOrderUpdateSuccessEvent(List<PurchaseOrderItem> source) {
		super(source);
		items=source;
		logger.info("----触发事件---PurchaseOrderUpdateSuccessEvent-----source--------"+source.toString());
	}

}
