package com.els.base.purchase.service;

import java.util.Date;
import java.util.List;
import java.util.Map;

import org.apache.ibatis.annotations.Param;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.purchase.entity.PurchaseOrderExample;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.entity.PurchaseOrderReport;
import com.els.base.purchase.entity.PurchaseOrderReportExample;



public interface PurchaseOrderItemService extends BaseService<PurchaseOrderItem, PurchaseOrderItemExample, String> {
    /**
     * 查询采购订单行历史
     *
     * @param purchaseOrderItemExample
     * @return
     */
    public PageView<PurchaseOrderItem> queryHisAllObjByExample(PurchaseOrderItemExample example);

    /**
     * 查询采购订单行历史
     *
     * @param purchaseOrderItemExample
     * @return
     */
    public PageView<PurchaseOrderItem> queryFirstOrderByExample(PurchaseOrderItemExample example);

    /**
     * 根据订单id删除下面的订单行
     *
     * @param id
     */
    public void deleteByOrderId(String orderId);

    /**
     * 根据订单id，与订单历史记录id,添加订单行的历史纪录
     *
     * @param orderHisId
     * @param orderId
     * @param cause
     */
    public void insertHisByOrderId(String orderHisId, String orderId, String cause, String version);

    /**
     * 根据订单id号，保存当前数据到历史记录表
     *
     * @param id
     * @param cause
     * @return
     */
    int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId, @Param("cause") String cause,
                  @Param("version") String version);

    /**
     * 分页查询采购订单行
     *
     * @param
     */
    public PageView<PurchaseOrderItem> queryPurchaseOrderItemByPage(Map<String, Object> map);

    /**
     * 查看最新的历史版本
     *
     * @return
     */
    String selectMaxVersion();

    /**
     * 批量修改采购单行
     *
     * @param record
     * @param example
     */
    public void updateByPurcahseOrder(PurchaseOrderItem record, PurchaseOrderItemExample example);

    /**
     * 通过采购物料号和供应商编码查询采购订单行
     *
     * @param materialCode
     * @param supCompanyCode
     * @return
     */
    public PurchaseOrderItem queryByMaterialCode(String materialCode, String supCompanyCode);

    /**
     * @param supplierOrder
     * @return
     */
    public List<PurchaseOrderItem> selectForExcel(PurchaseOrderExample purchaseOrder);


    public List<PurchaseOrderItem> selectForExcelFirst(PurchaseOrderExample purchaseOrder);

    /**
     * 采购订单报表
     *
     * @param supplierOrder
     * @return
     */
    public PageView<PurchaseOrderReport> selectPurchOrderReportByPage(PurchaseOrderReportExample example);

    /**
     * 采购订单报表
     *
     * @param supplierOrder
     * @return
     */
    public List<PurchaseOrderReport> selectPurchOrderReportforExcel(PurchaseOrderReportExample example);


    /**
     * 采购订单报表
     *
     * @param supplierOrder
     * @return
     */
    public PageView<PurchaseOrderReport> selectReturnPoByPage(PurchaseOrderReportExample example);

    /**
     *
     * @param purchaseOrderItem
     */
//	public void updateByPrimaryKey(PurchaseOrderItem purchaseOrderItem);

    /**
     * 根据登录用户查询订单号
     * @param userName
     * @return
     */
    public List<String> queryOrderNoByUserName(String userName);

     /**
     * 根据查询所有订单号
     * @param userName
     * @return
     */
    public List<String> queryOrderNoAll();

    
    /**
     * 发布订单给供应商
     * @param list
     * @return
     */
    public void sendOrderItem(List<PurchaseOrderItem> list);
    
    /**
     * 超期订单行
     * @param list
     * @return
     */
	public List<PurchaseOrderItem> purFindOverdue(String purUserId, Date date);

	public void updateByExampleSelective(PurchaseOrderItem purchaseOrderItem,
			PurchaseOrderItemExample purchaseOrderItemExample);

	 /**
     * 批量修改不为空的
     * @param list
     * @return
     */
	public void modifyByExample(PurchaseOrderItem availableItems,
			PurchaseOrderItemExample purchaseOrderItemExample);
}