package com.els.base.purchase.service;

import java.util.List;

import org.apache.ibatis.annotations.Param;

import com.els.base.core.entity.PageView;
import com.els.base.core.service.BaseService;
import com.els.base.file.entity.FileData;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderExample;

public interface PurchaseOrderService extends BaseService<PurchaseOrder, PurchaseOrderExample, String> {

    void  updateByPrimaryKeySelective(PurchaseOrder purchaseOrder);
    /**
     * 修改采购单
     * 
     * @param purchaseOrder
     * @param cause
     */
    public void modifyObj(PurchaseOrder purchaseOrder, String cause);

    /**
     * 发送采购订单
     * 
     * @param purchaseOrder
     */
//    public void sendPurchaseOrder(PurchaseOrder purchaseOrder);

    /**
     * 供应商确认或者退回采购订单
     * 
     * @param purchaseOrder
     */
//    public void supplyOperate(PurchaseOrder purchaseOrder);

    /**
     * 查询采购订单头历史
     * 
     * @param t
     */
    public PageView<PurchaseOrder> queryHisObjByPage(PurchaseOrderExample example);

    /**
     * 是否启用或禁用
     * 
     * @param isEnable true启用，false禁用
     */
    public void setIsEnable(String id, boolean isEnable);

    /**
     * 批量导入
     * 
     * @param orders
     */
    public void importPurchaseOrder(List<PurchaseOrder> orders);

    /**
     * 根据订单id号，保存当前数据到历史记录表
     * 
     * @param id
     * @param cause
     * @return
     */
    int insertHis(@Param("orderHisId") String hisId, @Param("orderId") String orderId,
            @Param("cause") String cause, @Param("version") String version);

    /**
     * 查看最新的历史版本
     * 
     * @return
     */
    String selectMaxVersion();

    /**
     * 修改采购单提交sap
     * 
     * @param purchaseOrder
     * @param cause
     */
    public void updateForSap(PurchaseOrder purchaseOrder);

    /**
     * 批量修改采购单头
     * 
     * @param record
     * @param example
     */
    public void updateByPurcahseOrder(PurchaseOrder record, PurchaseOrderExample example);

    /**
     * 根据采购员关联的供应商，做表关联查询
     * @param example
     * @param purUserId
     * @return
     */
    public PageView<PurchaseOrder> queryObjNoItemsByPage(PurchaseOrderExample example, String purUserId);

    /**
     * 发送采购订单（新）
     * 
     * @param purchaseOrder
     */
    public void sendOrder(PurchaseOrder purchaseOrder);

    /**
     * 通过id修改采购单
     * 
     * @param purchaseOrder
     */
    public void modifyObjByKey(PurchaseOrder purchaseOrder);
    
    /**
     * sap采购订单变更
     * @param purchaseOrder
     */
    void orderChangeBySap(PurchaseOrder purchaseOrder);

    /**
     * 根据id查询采购订单，返回文件信息
     * @param orderNoList 采购订单id集合
     * @return pdf文件信息集合
     */
	public List<FileData> getPdfFiles(List<String> orderNoList);

    /**
     * 修改订单头状态
     * @param purchaseOrder 订单
     */
	public void modifyOrderStatus(PurchaseOrder purchaseOrder);

	/**
     *  订单删除
     * */
    public void deleteOrder(PurchaseOrder purchaseOrder);
    
	int countByExample(PurchaseOrderExample purchaseOrderexample);
	
}