package com.els.base.purchase.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.purchase.dao.SaleOrderMapper;
import com.els.base.purchase.entity.SaleOrder;
import com.els.base.purchase.entity.SaleOrderExample;
import com.els.base.purchase.service.SaleOrderService;

@Service("saleOrderService")
public class SaleOrderServiceImpl implements SaleOrderService {
    @Resource
    protected SaleOrderMapper saleOrderMapper;

    @CacheEvict(value={"saleOrder"}, allEntries=true)
    @Override
    public void addObj(SaleOrder t) {
        this.saleOrderMapper.insertSelective(t);
    }

    @CacheEvict(value={"saleOrder"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.saleOrderMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"saleOrder"}, allEntries=true)
    @Override
    public void modifyObj(SaleOrder t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.saleOrderMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="saleOrder", keyGenerator="redisKeyGenerator")
    @Override
    public SaleOrder queryObjById(String id) {
        return this.saleOrderMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="saleOrder", keyGenerator="redisKeyGenerator")
    @Override
    public List<SaleOrder> queryAllObjByExample(SaleOrderExample example) {
        return this.saleOrderMapper.selectByExample(example);
    }

    @Cacheable(value="saleOrder", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<SaleOrder> queryObjByPage(SaleOrderExample example) {
        PageView<SaleOrder> pageView = example.getPageView();
        pageView.setQueryResult(this.saleOrderMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value={"saleOrder"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<SaleOrder> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (SaleOrder record : arg0) {
			this.saleOrderMapper.insertSelective(record);
		}
	}
    
    @CacheEvict(value={"saleOrder"}, allEntries=true)
	@Override
	public void deleteByExample(SaleOrderExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.saleOrderMapper.deleteByExample(arg0);
	}
}