//package com.css.aicmap.util.barcode;
package com.els.base.purchase.utils;

import java.awt.image.BufferedImage;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;

import javax.imageio.ImageIO;

import org.krysalis.barcode4j.impl.code39.Code39Bean;
import org.krysalis.barcode4j.output.bitmap.BitmapCanvasProvider;
import org.krysalis.barcode4j.tools.UnitConv;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.util.StringUtils;

import com.els.base.core.utils.Constant;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.BinaryBitmap;
import com.google.zxing.LuminanceSource;
import com.google.zxing.MultiFormatReader;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.Result;
import com.google.zxing.client.j2se.BufferedImageLuminanceSource;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.HybridBinarizer;

/** */
/**
 * 符合BarCode 39规范的条码图像生成器
 * 
 * @author 
 */
public class BarCodeImage {
    private static Logger logger= LoggerFactory.getLogger(BarCodeImage.class);
	/**
	 * 生成文件
	 *
	 * @param msg
	 * @param path
	 * @return
	 */
	public static File generateFile(String msg, String path) {
		File file = new File(path);
		try {
			generate(msg, new FileOutputStream(file));
		} catch (FileNotFoundException e) {
			throw new RuntimeException(e);
		}
		return file;
	}
	/**
	 * 生成条形码文件(显示底部编码)
	 *
	 * @param msg
	 * @param path
	 * @return
	 */
	public static File encodeBar(String msg,String projectId,String companyId) {
		FileData pdfFile = new FileData();
//		Properties properties = SpringContextHolder.getBean("sysConfig");
//		String location = properties.getProperty("resource.location", ""); //
		pdfFile.setProjectId(projectId);
		pdfFile.setCompanyId(companyId);
		pdfFile.setFileName(SysUtil.getNextFileName()+".png");
		pdfFile.setFileSuffix("png");
		pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
		File file=null;
		try {
//			pdfFile = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")) , pdfFile);
//		    file = new File(location + "/" + pdfFile.getLocalRelatPath() + pdfFile.getFileRename());
			OutputStream outputStream = FileManagerFactory.getFileManager().createOutputStream(pdfFile);
			generate(msg, outputStream);
		} catch (Exception e) {
			throw new RuntimeException(e);
		}
		return file;
	}

	/**
	 * 生成字节
	 *
	 * @param msg
	 * @return
	 */
	public static byte[] generate(String msg) {
		ByteArrayOutputStream ous = new ByteArrayOutputStream();
		generate(msg, ous);
		return ous.toByteArray();
	}

	/**
	 * 生成到流
	 *
	 * @param msg
	 * @param ous
	 */
	public static void generate(String msg, OutputStream ous) {
		if (StringUtils.isEmpty(msg) || ous == null) {
			return;
		}
		Code39Bean bean = new Code39Bean();
		// 精细度
		final int dpi = 150;
		// module宽度
		final double moduleWidth = UnitConv.in2mm(1.0f / dpi);
		// 配置对象
		bean.setModuleWidth(moduleWidth);
		bean.setWideFactor(3);
		bean.doQuietZone(false);
		String format = "image/png";
		try {
			// 输出到流
			BitmapCanvasProvider canvas = new BitmapCanvasProvider(ous, format, dpi, BufferedImage.TYPE_BYTE_BINARY,
					false, 0);
			// 生成条形码
			bean.generateBarcode(canvas, msg);
			// 结束绘制
			canvas.finish();
		} catch (IOException e) {
			throw new RuntimeException(e);
		}
	}
	/**
	 * 针对条形码进行解析
	 * 
	 * @param imgPath
	 * @return
	 */
	public static String decodeBar(String imgPath) {
		BufferedImage image = null;
		Result result = null;
		try {
			image = ImageIO.read(new File(imgPath));
			if (image == null) {
				logger.info("the decode image may be not exit.");
			}
			LuminanceSource source = new BufferedImageLuminanceSource(image);
			BinaryBitmap bitmap = new BinaryBitmap(new HybridBinarizer(source));

			result = new MultiFormatReader().decode(bitmap, null);
			return result.getText();
		} catch (Exception e) {
			e.printStackTrace();
		}
		return null;
	}
	 public static void main(String[] args) {
	        String msg = "6923450657713";
	        String imgPath = "D:/test/fdsafdsa.png";
	     // 条形码的生成与解析
			encodeBar(msg, 105, 50, imgPath);
			logger.info("生成条形码成功");
			logger.info(decodeBar(imgPath));
	        //encodeBar(msg, 100, 1, path);
	    }
	 /**
		 * 创建条形码
		 * 
		 * @param contents
		 * @param width
		 * @param height
		 * @param imgPath
		 */
		public static void encodeBar(String contents, int width, int height, String imgPath) {
			// 条形码的最小宽度
			int codeWidth = 98;
			codeWidth = Math.max(codeWidth, width);
			try {
				com.google.zxing.common.BitMatrix bitMatrix = new MultiFormatWriter().encode(contents,
						BarcodeFormat.CODE_128, codeWidth, height, null);
				MatrixToImageWriter.writeToStream(bitMatrix, "png",
						new FileOutputStream(imgPath));

			} catch (Exception e) {
				e.printStackTrace();
			}
		}
		/**
		 * 生成条形码文件(不显示底部编码)
		 * @param msg
		 * @param projectId
		 * @param companyId
		 * @param width
		 * @param height
		 */
		public static FileData encodeBar(String msg,String projectId,String companyId,int width, int height) {
			// 条形码的最小宽度
			int codeWidth = 98;
			codeWidth = Math.max(codeWidth, width);
			FileData pngFile = new FileData();
//			Properties properties = SpringContextHolder.getBean("sysConfig");
//			String location = properties.getProperty("resource.location", ""); //
			pngFile.setProjectId(projectId);
			pngFile.setCompanyId(companyId);
			pngFile.setFileName(SysUtil.getNextFileName()+".png");
			pngFile.setFileSuffix("png");
			pngFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
			try {
//				pngFile = FileManagerFactory.getFileManager().write(new ByteArrayInputStream("".getBytes("UTF-8")) , pngFile);
//			    file = new File(location + "/" + pngFile.getLocalRelatPath() + pngFile.getFileRename());
				
				OutputStream outputStream = FileManagerFactory.getFileManager().createOutputStream(pngFile);
				
				com.google.zxing.common.BitMatrix bitMatrix = new MultiFormatWriter().encode(msg,
						BarcodeFormat.CODE_128, codeWidth, height, null);
				MatrixToImageWriter.writeToStream(bitMatrix, "png", outputStream);
				
			} catch (Exception e) {
				e.printStackTrace();
			}
			return pngFile;
		}
	
}