package com.els.base.purchase.vo;

import com.els.base.delivery.entity.DeliveryOrderPrint;

import io.swagger.annotations.ApiModelProperty;

/**
 * 送货单二维码打印需要的数据对象
 * 二维码标签内容（不换行）：
 * [S]PLANT_NO[M]{0}
 * [S]MATERIAL_NO[M]{1}
 * [S]QTY[M]{2}
 * [S]BATCH_NO[M]{3}
 * [S]PRODUCT_ORDER_NO[M]{4}
 * [E]
 * @author zhoulongpeng
 *
 */
public class KnMaterialQrcodeVO {
	
	public static final String DEFAULT_FONT_PATH = DeliveryOrderPrint.class.getClassLoader().getResource("").toString() + "fonts/nsimsum.ttf";
	
	/**
	 * 工厂号
	 */
	private String plantNo;
	/**
	 * 物料号
	 */
//	private String materialNo;
	/**
	 * 数量
	 */
	private String quantity;
	/**
	 * 批次号
	 */
	private String batchNo;
	/**
	 * 入库任务单号
	 */
	private String productOrderNo;
	/**
	 * 名称
	 */
	private String materialName;
	/**
	 * 图号
	 */
	private String figureType;
	/**
	 * 仓库
	 */
	private String store;
	/**
	 * 规格
	 */
	private String specification;
	/**
	 * 物料号
	 */
	private String materialCode;
	/**
	 * 特殊库存标识，如Q（项目库存）
	 */
	private String siString;
	/**
	 * 特殊库存值，如项目号
	 */
	private String sivString;
	/**
	 * 单元包装量
	 */
	private String checkBatch;
	/**
	 * 质检
	 */
	private String quanlityCheck;
	
	/**
	 * 仓位
	 */
	private String position;
	
	@ApiModelProperty("仓库")
	private String location;
	
	@ApiModelProperty("ASN订单号（送货单号）")
	private String deliverOrderNo;
	
	@ApiModelProperty("ASN订单行号（送货单行号）")
	private String deliverOrderItemNo;
	
	
	@ApiModelProperty("条形码路径")
	private String scanPicPath;
	
	@ApiModelProperty("项目")
	private String projectId;
	
	@ApiModelProperty("采购公司")
	private String purCompanyId;

	@ApiModelProperty("是否自动检测")
	private String automaticDetection;

	@ApiModelProperty("字体路径")
	private String fontPath = DEFAULT_FONT_PATH;
	
	public String getPlantNo() {
		return plantNo;
	}
	public void setPlantNo(String plantNo) {
		this.plantNo = plantNo;
	}
//	public String getMaterialNo() {
//		return materialNo;
//	}
//	public void setMaterialNo(String materialNo) {
//		this.materialNo = materialNo;
//	}
	public String getQuantity() {
		return quantity;
	}
	public void setQuantity(String quantity) {
		this.quantity = quantity;
	}
	public String getBatchNo() {
		return batchNo;
	}
	public void setBatchNo(String batchNo) {
		this.batchNo = batchNo;
	}
	public String getProductOrderNo() {
		return productOrderNo;
	}
	public void setProductOrderNo(String productOrderNo) {
		this.productOrderNo = productOrderNo;
	}
	public String getMaterialName() {
		return materialName;
	}
	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}
	public String getFigureType() {
		return figureType;
	}
	public void setFigureType(String figureType) {
		this.figureType = figureType;
	}
	public String getStore() {
		return store;
	}
	public void setStore(String store) {
		this.store = store;
	}
	public String getSpecification() {
		return specification;
	}
	public void setSpecification(String specification) {
		this.specification = specification;
	}
	public String getMaterialCode() {
		return materialCode;
	}
	public void setMaterialCode(String materialCode) {
		this.materialCode = materialCode;
	}
	public String getSiString() {
		return siString;
	}
	public void setSiString(String siString) {
		this.siString = siString;
	}
	public String getSivString() {
		return sivString;
	}
	public void setSivString(String sivString) {
		this.sivString = sivString;
	}
	public String getCheckBatch() {
		return checkBatch;
	}
	public void setCheckBatch(String checkBatch) {
		this.checkBatch = checkBatch;
	}
	public String getQuanlityCheck() {
		return quanlityCheck;
	}
	public void setQuanlityCheck(String quanlityCheck) {
		this.quanlityCheck = quanlityCheck;
	}
	public String getScanPicPath() {
		return scanPicPath;
	}
	public void setScanPicPath(String scanPicPath) {
		this.scanPicPath = scanPicPath;
	}
	public String getProjectId() {
		return projectId;
	}
	public void setProjectId(String projectId) {
		this.projectId = projectId;
	}
	public String getPurCompanyId() {
		return purCompanyId;
	}
	public void setPurCompanyId(String purCompanyId) {
		this.purCompanyId = purCompanyId;
	}
	
	public String getFontPath() {
		return fontPath;
	}

	public void setFontPath(String fontPath) {
		this.fontPath = fontPath;
	}
	
	public String getLocation() {
		return location;
	}
	public void setLocation(String location) {
		this.location = location;
	}
	public String getDeliverOrderNo() {
		return deliverOrderNo;
	}
	public void setDeliverOrderNo(String deliverOrderNo) {
		this.deliverOrderNo = deliverOrderNo;
	}
	public String getDeliverOrderItemNo() {
		return deliverOrderItemNo;
	}
	public void setDeliverOrderItemNo(String deliverOrderItemNo) {
		this.deliverOrderItemNo = deliverOrderItemNo;
	}
	
	public String getPosition() {
		return position;
	}
	public void setPosition(String position) {
		this.position = position;
	}

	public String getAutomaticDetection() {
		return automaticDetection;
	}

	public void setAutomaticDetection(String automaticDetection) {
		this.automaticDetection = automaticDetection;
	}
}
