package com.els.base.purchase.vo;

import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.Date;

import io.swagger.annotations.ApiModelProperty;

/**
 * 供应商PDF导出条目信息VO
 * 
 * @author linyuqin
 * @date 2018年3月22日16:15:17
 */
public class KnSupOrderPdfItemVO {

	@ApiModelProperty("采购凭证的项目编号 ")
	private String orderItemNo;

	@ApiModelProperty("项目类别")
	private String itemDescription;

	@ApiModelProperty("物料号 (客户端物料编码)")
	private String materialCode;

	@ApiModelProperty("供应商物料号（供应商物料编码）")
	private String supMaterialCode;

	// @ApiModelProperty("物料名称")
	// private String deliveryMaterialName;

	@ApiModelProperty("物料名称")
	private String materialName;

	@ApiModelProperty("WBS号")
	private String wbsNo;

	@ApiModelProperty("WBS描述")
	private String wbsNoDesc;

	@ApiModelProperty("数量")
	private BigDecimal quantity;

	@ApiModelProperty("单位")
	private String priceUnit;

	@ApiModelProperty("无税单价")
	private BigDecimal noTaxPrice;

	@ApiModelProperty("无税金额")
	private String orderValue;

	@ApiModelProperty("备注")
	private String remark;

	@ApiModelProperty("税码")
	private String saleTaxCode;

	@ApiModelProperty("工厂")
	private String factory;

	@ApiModelProperty("理论交货日期")
	private Date theoryDeliverDate;

	@ApiModelProperty("理论交货日期")
	private Date deliverDate;
	public String getOrderItemNo() {
		return orderItemNo;
	}

	public void setOrderItemNo(String orderItemNo) {
		this.orderItemNo = orderItemNo;
	}

	public String getItemDescription() {
		return itemDescription;
	}

	public void setItemDescription(String itemDescription) {
		this.itemDescription = itemDescription;
	}

	public String getMaterialCode() {
		return materialCode;
	}

	public void setMaterialCode(String materialCode) {
		this.materialCode = materialCode;
	}

	public String getSupMaterialCode() {
		return supMaterialCode;
	}

	public void setSupMaterialCode(String supMaterialCode) {
		this.supMaterialCode = supMaterialCode;
	}

	public String getWbsNo() {
		return wbsNo;
	}

	public void setWbsNo(String wbsNo) {
		this.wbsNo = wbsNo;
	}

	public String getWbsNoDesc() {
		return wbsNoDesc;
	}

	public void setWbsNoDesc(String wbsNoDesc) {
		this.wbsNoDesc = wbsNoDesc;
	}

	public BigDecimal getNoTaxPrice() {
		return noTaxPrice;
	}

	public void setNoTaxPrice(BigDecimal noTaxPrice) {
		this.noTaxPrice = noTaxPrice;
	}

	public String getOrderValue() {
		return orderValue;
	}

	public void setOrderValue(String orderValue) {
		this.orderValue = orderValue;
	}

	public String getRemark() {
		return remark;
	}

	public void setRemark(String remark) {
		this.remark = remark;
	}

	public String getSaleTaxCode() {
		return saleTaxCode;
	}

	public void setSaleTaxCode(String saleTaxCode) {
		this.saleTaxCode = saleTaxCode;
	}

	public String getFactory() {
		return factory;
	}

	public void setFactory(String factory) {
		this.factory = factory;
	}

	public BigDecimal getQuantity() {
		return quantity;
	}

	public void setQuantity(BigDecimal quantity) {
		this.quantity = quantity;
	}

	public String getPriceUnit() {
		return priceUnit;
	}

	public void setPriceUnit(String priceUnit) {
		this.priceUnit = priceUnit;
	}

	public String getTheoryDeliverDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");
		
		if (this.theoryDeliverDate != null) {
			return sdf.format(this.theoryDeliverDate);
		}
		
		return "";
	}

	public void setTheoryDeliverDate(Date theoryDeliverDate) {
		this.theoryDeliverDate = theoryDeliverDate;
	}

	public String getMaterialName() {
		return materialName;
	}

	public void setMaterialName(String materialName) {
		this.materialName = materialName;
	}

	public String getDeliverDate() {
		SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd");

		if (this.theoryDeliverDate != null) {
			return sdf.format(this.theoryDeliverDate);
		}

		return "";
	}

	public void setDeliverDate(Date deliverDate) {
		this.deliverDate = deliverDate;
	}
}
