package com.els.base.purchase.web.controller;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.purchase.entity.PurchaseOrderReport;
import com.els.base.purchase.entity.PurchaseOrderReportExample;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import com.els.base.company.service.CompanyService;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;

import java.io.OutputStream;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Api(value = "采购订单行")
@Controller
@RequestMapping("purchaseOrderItem")
public class PurchaseOrderItemController {

    private static Logger logger = LoggerFactory.getLogger(PurchaseOrderItemController.class);

    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;
    @Resource
    protected CompanyService companyService;

    @ApiOperation(httpMethod = "POST", value = "删除采购订单行：入参（采购方订单行id）")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required = true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空", "id_is_blank");
        }
        // 删除头（删除标识）
        PurchaseOrderItem returnObj = this.purchaseOrderItemService.queryObjById(id);
        if (returnObj == null) {
            throw new CommonException("删除失败,采购方订单行不存在", "do_not_exists", "采购方订单行");
        }

        // returnObj.setIsEnable(1);
        returnObj.setIsEnable(Constant.NO_INT);
        purchaseOrderItemService.modifyObj(returnObj);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod = "POST", value = "通过采购订单号查询采购订单行")
    @RequestMapping("service/findByPurchaseOrder")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPurchaseOrder(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("采购订单号") String orderId) {

        if (StringUtils.isBlank(orderId)) {
            throw new CommonException("查询失败,采购订单号不存在", "do_not_exists", "采购订单号");
        }

        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));
        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
//        criteria.andIsEnableNotEqualTo(0);
        // criteria.andIsEnableEqualTo(0);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "通过id查询采购订单行历史")
    @RequestMapping("service/findItemHisById")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findItemHisById(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("采购订单号") String orderNo, @ApiParam("采购订单行号") String orderItemNo) {

        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));
        if (StringUtils.isBlank(orderNo)) {
            throw new CommonException("查询失败,id不能为空", "id_is_blank");
        }

        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderNoEqualTo(orderNo);
        criteria.andOrderItemNoEqualTo(orderItemNo);
        example.setOrderByClause("version DESC,UPDATE_TIME DESC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryHisAllObjByExample(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "分页查询订单行")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {

        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));

        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        // 过滤首批订单
        //criteria.andFirstFlagEqualTo(Constant.NO_INT);
        PurchaseOrderItemExample.Criteria orCriteria = example.or();
        orCriteria.andFirstFlagIsNull();
        orCriteria.andBackGoodsItemNotEqualTo("X");
        //过滤退货行
        criteria.andBackGoodsItemNotEqualTo("X");
        
        if (wapper != null) {
            CriteriaUtils.addCriterion(orCriteria, wapper);
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        // criteria.andIsEnableEqualTo(0);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "查询未完成的订单行")
    @RequestMapping("service/findUnFinshByPage")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderItem>> findUnFinshByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {

        PurchaseOrderItemExample example = new PurchaseOrderItemExample();
        example.setPageView(new PageView<PurchaseOrderItem>(pageNo, pageSize));

        PurchaseOrderItemExample.Criteria criteria = example.createCriteria();
        // 过滤首批订单
        criteria.andFirstFlagEqualTo(Constant.NO_INT);
        PurchaseOrderItemExample.Criteria orCriteria = example.or();
        orCriteria.andFirstFlagIsNull();
        orCriteria.andBackGoodsItemNotEqualTo("X");
        orCriteria.andFinishFlagEqualTo(Constant.NO_STRING);
        //过滤退货行
        criteria.andBackGoodsItemNotEqualTo("X");
        orCriteria.andFinishFlagEqualTo(Constant.NO_STRING);
        if (wapper != null) {
            CriteriaUtils.addCriterion(orCriteria, wapper);
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        // criteria.andIsEnableEqualTo(0);
        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView<PurchaseOrderItem> pageData = this.purchaseOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }



    @ApiOperation(httpMethod = "POST", value = "退货订单查询")
    @RequestMapping("service/findReturnPOByPage")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderReport>> findReturnPOByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {
        logger.info("分页查询订单报表findReportByPage");
        logger.info(String.valueOf(pageSize));
        PurchaseOrderReportExample example = new PurchaseOrderReportExample();
        example.setPageView(new PageView<PurchaseOrderReport>(pageNo, pageSize));
        PurchaseOrderReportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
        logger.info("分页查询订单报表findReportByPage 参数初始化完成");
        PageView<PurchaseOrderReport> pageData = this.purchaseOrderItemService.selectReturnPoByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "批量发送采购订单（退货）单行：入参（订单行id数组）")
    @RequestMapping("service/send")
    @ResponseBody
    public ResponseResult<String> send(@RequestBody List<String> orderIdList) {

        if (CollectionUtils.isEmpty(orderIdList)) {
            throw new CommonException("id为空，操作失败", "id_is_blank");
        }
        logger.info("数据处理");
        List<PurchaseOrderItem> list = new ArrayList<>();
        for (String itemid : orderIdList) {
            logger.info("获取订单行" + itemid);
            PurchaseOrderItem purchaseOrderItem = this.purchaseOrderItemService.queryObjById(itemid);
            if (purchaseOrderItem == null) {
                throw new CommonException("采购方订单行[ " + itemid + " ]不存在", "do_not_exists", "采购方订单行");
            }

            logger.info("如果是已发送或者变更已发送" + itemid);
            // 如果是已发送或者变更已发送
            if (purchaseOrderItem.getAttribute1() != null) {
                if (purchaseOrderItem.getAttribute1().equals(String.valueOf(PurchaseOrderSendStatusEnum.SENDED.getValue()))) {
                    // 如果是未确认或者已确认
                    throw new CommonException("采购方订单[ " + purchaseOrderItem.getOrderNo() + " ]订单行[" + purchaseOrderItem.getOrderItemNo() + "]已经发送,请勿重复发送");
                }
            }
            list.add(purchaseOrderItem);
        }
        logger.info("sendOrderItem");
        this.purchaseOrderItemService.sendOrderItem(list);
        return ResponseResult.success();
    }


    @ApiOperation(httpMethod = "POST", value = "分页查询订单报表")
    @RequestMapping("service/findReportByPage")
    @ResponseBody
    public ResponseResult<PageView<PurchaseOrderReport>> findReportByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = false) QueryParamWapper wapper) {
        logger.info("分页查询订单报表findReportByPage");
        logger.info(String.valueOf(pageSize));
        PurchaseOrderReportExample example = new PurchaseOrderReportExample();
        example.setPageView(new PageView<PurchaseOrderReport>(pageNo, pageSize));
        PurchaseOrderReportExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        //criteria.andIsEnableEqualTo(Constant.YES_INT);
        example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
        logger.info("分页查询订单报表findReportByPage 参数初始化完成");
        PageView<PurchaseOrderReport> pageData = this.purchaseOrderItemService.selectPurchOrderReportByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "订单报表导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {
            logger.info("订单报表导出Excel 参数" + queryParams);
            PurchaseOrderReportExample example = new PurchaseOrderReportExample();
            PurchaseOrderReportExample.Criteria createCriteria = example.createCriteria();
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams,
                        QueryParamWapper.class);
                CriteriaUtils.addCriterion(createCriteria, queryParamWapper);
            }
            example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
            List<PurchaseOrderReport> purOrderitemList = this.purchaseOrderItemService.selectPurchOrderReportforExcel(example);
            logger.info("订单报表导出Excel 数据条数" + purOrderitemList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "采购订单报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("订单报表导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");

            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单类型描述", "orderTypeDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行项目号", "orderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("确认状态", "orderStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("删除标识", "isEnable"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("退货项目", "backGoodsItem"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("规格", "specification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单单位", "orderUnit"));
            TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate");
            DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter);
            titleAndModelKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(titleAndModelKey);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receivedQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待收货数量", "waitReceiveQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货已完成", "finishFlag"));
            // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("凭证日期", "orderDate"));

            // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate"));
            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("订单日期", "mOrderDate");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey2.setToObjConverter(dateConverter2);
            titleAndModelKey2.setToStrConverter(dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购员名称", "buyerName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("净价", "noTaxPrice"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("金额", "orderValue"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价税合计", "priceTaxTotal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币别", "currency"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目号", "wbsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目描述", "wbsNoDesc"));

            TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("理论交货日期", "theoryDeliverDate");
            DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey3.setToObjConverter(dateConverter3);
            titleAndModelKey3.setToStrConverter(dateConverter3);
            titleAndModelKeys.add(titleAndModelKey3);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否紧急", "isUrgency"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购周期", "purchasePeriod"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("库存地点", "storageSite"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购信息记录", "purchaseInfoRecord"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议号", "purchaseProtocalNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议项目", "purchaseProtocalItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请号", "purReqNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请行号", "purchaseApplyItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请创建人", "purApplyCreator"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求者", "needer"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("可发货数量", "deliveryAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("在途数量", "onwayQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("预制发票数量", "preInvoiceQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发票已过账数量", "postAccountQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待开发票数量", "waitInvoiceQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            logger.info("订单报表导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    purOrderitemList, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("订单报表导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    @ApiOperation(value = "订单报表导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "采购订单行id", defaultValue = "") @RequestParam(defaultValue = "") String orderItemIdList,
            HttpServletResponse response) {
        try {
            logger.info("订单报表导出Excel 参数" + orderItemIdList);
            PurchaseOrderReportExample example = new PurchaseOrderReportExample();
            PurchaseOrderReportExample.Criteria createCriteria = example.createCriteria();
            if (StringUtils.isNotBlank(orderItemIdList)) {
                //createCriteria.andOrderNoIn(Arrays.asList(orderNOList.split(",")));
                createCriteria.andIdIn(Arrays.asList(orderItemIdList.split(",")));
            }
            example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
            List<PurchaseOrderReport> purOrderitemList = this.purchaseOrderItemService.selectPurchOrderReportforExcel(example);
            logger.info("订单报表导出Excel 数据条数" + purOrderitemList.size());
            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            String filename = "采购订单报表" + System.currentTimeMillis() + ".xls";
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            logger.info("订单报表导出Excel 文件名称" + filename);
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();
            List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单类型描述", "orderTypeDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行项目号", "orderItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("确认状态", "orderStatus"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("删除标识", "isEnable"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("退货项目", "backGoodsItem"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factory"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("规格", "specification"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单单位", "orderUnit"));
            TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate");
            DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey.setToObjConverter(dateConverter);
            titleAndModelKey.setToStrConverter(dateConverter);
            titleAndModelKeys.add(titleAndModelKey);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receivedQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待收货数量", "waitReceiveQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货已完成", "finishFlag"));
            // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("凭证日期", "orderDate"));

            // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate"));
            TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("订单日期", "mOrderDate");
            DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey2.setToObjConverter(dateConverter2);
            titleAndModelKey2.setToStrConverter(dateConverter2);
            titleAndModelKeys.add(titleAndModelKey2);
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购员名称", "buyerName"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("净价", "noTaxPrice"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("金额", "orderValue"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价税合计", "priceTaxTotal"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币别", "currency"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目号", "wbsNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目描述", "wbsNoDesc"));

            TitleAndModelKey titleAndModelKey3 = ExcelUtils.createTitleAndModelKey("理论交货日期", "theoryDeliverDate");
            DateConverter dateConverter3 = new DateConverter().setDateFormat("yyyy-MM-dd");
            titleAndModelKey3.setToObjConverter(dateConverter3);
            titleAndModelKey3.setToStrConverter(dateConverter3);
            titleAndModelKeys.add(titleAndModelKey3);

            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否紧急", "isUrgency"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购周期", "purchasePeriod"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("库存地点", "storageSite"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购信息记录", "purchaseInfoRecord"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议号", "purchaseProtocalNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议项目", "purchaseProtocalItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请号", "purReqNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请行号", "purchaseApplyItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请创建人", "purApplyCreator"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求者", "needer"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("可发货数量", "deliveryAmount"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("在途数量", "onwayQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("预制发票数量", "preInvoiceQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发票已过账数量", "postAccountQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待开发票数量", "waitInvoiceQuantity"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
            logger.info("订单报表导出Excel 开始导出文件");
            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys,
                    purOrderitemList, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();
            logger.info("订单报表导出Excel 文件导出成功");
        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }


}