package com.els.base.supperorder.service.impl;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.purchase.utils.OrderBusinessTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.supperorder.dao.SupplierOrderItemMapper;
import com.els.base.supperorder.entity.SupplierOrderExample;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.entity.SupplierOrderReport;
import com.els.base.supperorder.entity.SupplierOrderReportExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.utils.uuid.UUIDGenerator;

@Service("supplierOrderItemService")
public class SupplierOrderItemServiceImpl implements SupplierOrderItemService {
    @Resource
    protected SupplierOrderItemMapper supplierOrderItemMapper;

    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Override
    public void addObj(SupplierOrderItem t) {
        this.supplierOrderItemMapper.insertSelective(t);
    }

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Override
    public void deleteObjById(String id) {
        this.supplierOrderItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Override
    public void modifyObj(SupplierOrderItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.supplierOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public SupplierOrderItem queryObjById(String id) {
        return this.supplierOrderItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public List<SupplierOrderItem> queryAllObjByExample(SupplierOrderItemExample example) {
        return this.supplierOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<SupplierOrderItem> queryObjByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.supplierOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Override
    public int insertHis(String hisId, String orderId, String cause) {
        // TODO Auto-generated method stub
        return this.supplierOrderItemMapper.insertHis(hisId, orderId, cause);
    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public PageView<SupplierOrderItem> querySupplierOrderItemByPage(SupplierOrderItemExample example) {
        PageView<SupplierOrderItem> pageView = example.getPageView();
        List<SupplierOrderItem> items = this.supplierOrderItemMapper.selectSupplierOrderItemByPage(example);
        pageView.setQueryResult(items);
        return pageView;
    }

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Override
    public void updateBySupplierOrder(SupplierOrderItem supplierOrderItem,
                                      SupplierOrderItemExample supplierOrderItemExample) {
        this.supplierOrderItemMapper.updateByExampleSelective(supplierOrderItem, supplierOrderItemExample);

    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public List<SupplierOrderItem> selectForExcel(SupplierOrderExample example) {
        return this.supplierOrderItemMapper.selectForExcel(example);
    }

    @Cacheable(value = "supplierOrderItem", keyGenerator = "redisKeyGenerator")
    @Override
    public List<SupplierOrderItem> selectForExcelFirst(SupplierOrderExample example) {
        return this.supplierOrderItemMapper.selectForExcelFirst(example);
    }


    @Override
    public List<SupplierOrderItem> selectForExcelByOutstandingOrder(SupplierOrderExample supplierOrderExample) {
        // TODO Auto-generated method stub
        return this.supplierOrderItemMapper.selectForExcelByOutstandingOrder(supplierOrderExample);
    }

    @Override
    public List<String> queryOrderIdByExample(SupplierOrderItemExample example) {
        return this.supplierOrderItemMapper.selectOrderIdByExample(example);
    }

    @Override
    public PageView<SupplierOrderReport> selectSupplierOrderReportByPage(SupplierOrderReportExample example) {
        PageView<SupplierOrderReport> pageView = example.getPageView();
        List<SupplierOrderReport> items = this.supplierOrderItemMapper.selectSupplierOrderReportByPage(example);
        pageView.setQueryResult(items);
        return pageView;
    }

    /**
     * 采购订单报表导出excel
     */
    @Override
    public List<SupplierOrderReport> selectSupplierOrderReportForExcel(SupplierOrderReportExample example) {

        return this.supplierOrderItemMapper.selectSupplierOrderReportForExcel(example);
    }

    /**
     * 订单行拒绝或者确认
     */
    @Transactional(rollbackFor = Exception.class)
    @CacheEvict(value = {"supplierOrder", "supplierOrderItem", "purchaseOrder", "purchaseOrderItem"}, allEntries = true)
    @Override
    public void supplierOrderItemRefuse(List<SupplierOrderItem> supplierOrderItems) {

        int refuseNum = 0;// 拒绝的订单行数量
        int batchNum = 0; // 分批的订单行数量
        int confirmNum = 0; //确认的数量
        int totalOrderItem = supplierOrderItems.size();


        // 修改销售订单行记录
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            supplierOrderItem.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
            supplierOrderItem.setUpdateTime(new Date());
            this.supplierOrderItemMapper.updateByPrimaryKey(supplierOrderItem);
        }
        String hisId = UUIDGenerator.generateUUID();

        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            //如果是确认，则插入历史记录
            String hisId2 = UUIDGenerator.generateUUID();
            this.supplierOrderItemMapper.insertHis(hisId2, supplierOrderItem.getId(), "订单行确认");
        }
        // 修改采购订单的状态
        sendToPurchase(supplierOrderItems);
    }

    @Override
    public int countByExample(SupplierOrderItemExample example) {
        return supplierOrderItemMapper.countByExample(example);
    }

    /**
     * 供应商拒绝或者确认订单后发送给采购方
     *
     * @param supplierOrderItems
     */
    public void sendToPurchase(List<SupplierOrderItem> supplierOrderItems) {
        PurchaseOrderItem record = new PurchaseOrderItem();
        for (SupplierOrderItem supplierOrderItem : supplierOrderItems) {
            record = this.purchaseOrderItemService.queryObjById(supplierOrderItem.getId());
            if (record != null) {
                record.setSupRemark(supplierOrderItem.getSupRemark());
                record.setOrderStatus(supplierOrderItem.getOrderStatus());
                record.setUpdateTime(new Date());
                record.setOrderStatus(PurchaseOrderStatusEnum.CONFIRM.getValue());
                PurchaseOrderItemExample exampleItem = new PurchaseOrderItemExample();
                List<Integer> isEnableValues = new ArrayList<Integer>();
                isEnableValues.add(1);
                isEnableValues.add(2);
                //this.purchaseOrderItemService.updateByPurcahseOrder(record, exampleItem);
                //
                this.purchaseOrderItemService.modifyObj(record);
            }
            Message<SupplierOrderItem> message = Message.init(supplierOrderItem)
                    .setCompanyCode(supplierOrderItem.getSapPurCompanyCode())
                    .setSenderId(supplierOrderItem.getUserId())
                    .addReceiverId(supplierOrderItem.getPurUserId())
                    .setMsgLevel(MessageLevelEnum.HIGH);

            message.setBusinessTypeCode(OrderBusinessTypeEnum.PO_CONFIRM.getCode());
            MessageSendUtils.sendMessage(message);
        }

    }

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void addAll(List<SupplierOrderItem> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (SupplierOrderItem record : arg0) {
			this.supplierOrderItemMapper.insertSelective(record);
		}
	}

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
	@Override
	public void deleteByExample(SupplierOrderItemExample arg0) {
		Assert.isNotEmpty(arg0.getOredCriteria(), "删除的条件不能为空");
		this.supplierOrderItemMapper.deleteByExample(arg0);
	}

    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void updateByExampleSelective(SupplierOrderItem supplierOrderItem,
			SupplierOrderItemExample supplierOrderItemExample) {
		this.supplierOrderItemMapper.updateByExampleSelective(supplierOrderItem, supplierOrderItemExample);
		
	}
    @CacheEvict(value = {"supplierOrderItem"}, allEntries = true)
    @Transactional
	@Override
	public void modifyByExample(SupplierOrderItem supplierOrderItem,
			SupplierOrderItemExample supplierOrderItemExamples) {
		this.supplierOrderItemMapper.updateByExampleSelective(supplierOrderItem, supplierOrderItemExamples);
		
	}
}
