package com.els.base.supperorder.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.service.CompanyService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.utils.PurchaseOrderInterTypeEnum;
import com.els.base.purchase.utils.PurchaseOrderSendStatusEnum;
import com.els.base.purchase.utils.PurchaseOrderStatusEnum;
import com.els.base.supperorder.entity.SupplierOrderItem;
import com.els.base.supperorder.entity.SupplierOrderItemExample;
import com.els.base.supperorder.entity.SupplierOrderReport;
import com.els.base.supperorder.entity.SupplierOrderReportExample;
import com.els.base.supperorder.service.SupplierOrderItemService;
import com.els.base.supperorder.service.SupplierOrderService;
import com.els.base.utils.excel.BigDecimalConverter;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import jxl.write.WritableWorkbook;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.servlet.ModelAndView;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import java.io.OutputStream;
import java.math.BigDecimal;
import java.net.URLEncoder;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

@Api(value = "销售订单行")
@Controller
@RequestMapping("supplierOrderItem")
public class SupplierOrderItemController {

    Logger logger = LoggerFactory.getLogger(SupplierOrderItemController.class);

    @Resource
    protected SupplierOrderItemService supplierOrderItemService;

    @Resource
    protected CompanyService companyService;

    @Resource
    protected SupplierOrderService supplierOrderService;

    @ApiOperation(httpMethod = "POST", value = "通过销售订单号查询销售订单行")
    @RequestMapping("service/findBySupplierOrder")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findBySupplierOrder(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("采购订单号") String orderId, @ApiParam("是否完成标识") String finishFlag) {
        if (StringUtils.isBlank(orderId)) {
            throw new CommonException("查询失败,采购订单号不存在", "do_not_exists", "采购订单号");
        }

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andOrderIdEqualTo(orderId);
       // criteria.andIsEnableNotEqualTo(0);
        if (StringUtils.isNotBlank(finishFlag)) {
            criteria.andFinishFlagEqualTo(finishFlag);
        }
        // example.setOrderByClause("MATERIAL_CODE asc");
        //example.setOrderByClause("HAVE_CHANGE DESC, MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "供应商送货，新建送货单列表")
    @RequestMapping("service/findSupplierOrderItemByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper queryParams) {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        //example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC,UPDATE_TIME DESC, ORDER_DATE DESC");
        example.setOrderByClause("SEND_TIME DESC,UPDATE_TIME DESC, ORDER_DATE DESC,MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.createCriteria()
                .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andDeliveryAmountGreaterThan(0l)
                .andInterTypeNotEqualTo(PurchaseOrderInterTypeEnum.FOR_HK.getValue())
                .andIsEnableNotEqualTo(0)
                .andBackGoodsItemNotEqualTo("X");
        example.or()
                .andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andDeliveryAmountGreaterThan(0l)
                .andInterTypeIsNull()
                .andIsEnableNotEqualTo(0)
                .andBackGoodsItemNotEqualTo("X");

        if (queryParams != null) {
            for (int i = 0; i < example.getOredCriteria().size(); i++) {
                CriteriaUtils.addCriterion(example.getOredCriteria().get(i), queryParams);
            }
        }

        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "新建预付款单查询界面")
    @RequestMapping("service/findAdvancedPayBillByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findAdvancedPayBillByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper queryParams) {

        SupplierOrderItemExample example = new SupplierOrderItemExample();

        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));

        //1.排序方式是以物料编码排序后按照订单号排序；
        //example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                .andProjectIdEqualTo(ProjectUtils.getProjectId())
                .andIsEnableEqualTo(Constant.YES_INT)

                //2.采购订单状态必须是供应商已经回签的单并且不是已完成的单；
                .andOrderStatusEqualTo(PurchaseOrderStatusEnum.CONFIRM.getValue())
                .andFinishFlagEqualTo(Constant.NO_STRING)

                //3.查询条件写死：可申请金额必须大于0；小于等于0的没意义；
                .andAvailableApplyMoneyGreaterThan(BigDecimal.ZERO);

        if (queryParams != null) {
            CriteriaUtils.addCriterion(criteria, queryParams);
        }

        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "分页查询采购订单行：采用原来旧的传值方式")
    @RequestMapping("service/findSupplierOrderItemByPageForInvoice")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemByPageForInvoice(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper queryParamWapper) throws ParseException {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        //example.setOrderByClause("SUP_MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.setOrderByClause("ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri =
                example.createCriteria().andCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                        .andProjectIdEqualTo(ProjectUtils.getProjectId()).andInterTypeEqualTo("3");

        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(cri, queryParamWapper);
        }

        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "分页查询采购订单行（采购方）：采用原来旧的传值方式")
    @RequestMapping("service/findSupplierOrderItemForPurchaseByPageForInvoice")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findSupplierOrderItemForPurchaseByPageForInvoice(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @RequestBody(required = false) QueryParamWapper queryParamWapper) throws ParseException {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        //example.setOrderByClause("MATERIAL_CODE ASC, ORDER_ITEM_NO ASC");
        example.setOrderByClause(" ORDER_ITEM_NO ASC");
        SupplierOrderItemExample.Criteria cri =
                example.createCriteria().andPurCompanyIdEqualTo(CompanyUtils.currentCompanyId())
                        .andProjectIdEqualTo(ProjectUtils.getProjectId()).andInterTypeEqualTo("3");

        if (queryParamWapper != null) {
            CriteriaUtils.addCriterion(cri, queryParamWapper);
        }

        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.querySupplierOrderItemByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "分页查询销售订单行")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        //排除退货单
        criteria.andBackGoodsItemNotEqualTo("X");
        // 过滤首批订单.andFirstFlagEqualTo(Constant.NO_INT)
        SupplierOrderItemExample.Criteria orCriteria = example.or();
        //排除首批订单.andFirstFlagIsNull()
        orCriteria.andBackGoodsItemNotEqualTo("X");

        if (wapper != null) {
            CriteriaUtils.addCriterion(orCriteria, wapper);
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        //example.setOrderByClause("ORDER_ITEM_NO ASC,HAVE_CHANGE DESC, MATERIAL_CODE ASC ");
        example.setOrderByClause("ORDER_ITEM_NO ASC,HAVE_CHANGE DESC");
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "分页查询销售订单行")
    @RequestMapping("service/findByPageNoConFirm")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findByPageNoConFirm(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        //排除退货单.andFirstFlagEqualTo(Constant.NO_INT)
        criteria.andBackGoodsItemNotEqualTo("X");
        //只显示为确认的行
        criteria.andOrderStatusEqualTo(PurchaseOrderStatusEnum.UNCONFIRM.getValue());
        // 过滤首批订单
        SupplierOrderItemExample.Criteria orCriteria = example.or();
        //排除首批订单.andFirstFlagIsNull()
        orCriteria.andBackGoodsItemNotEqualTo("X").andOrderStatusEqualTo(PurchaseOrderStatusEnum.UNCONFIRM.getValue());

        if (wapper != null) {
            CriteriaUtils.addCriterion(orCriteria, wapper);
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        //example.setOrderByClause("ORDER_ITEM_NO ASC,HAVE_CHANGE DESC, MATERIAL_CODE ASC ");
        example.setOrderByClause("ORDER_ITEM_NO ASC,HAVE_CHANGE DESC");
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }


    @ApiOperation(httpMethod = "POST", value = "分页查询销售订单行(退货)")
    @RequestMapping("service/findReturnPOByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderItem>> findReturnPOByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = true) QueryParamWapper wapper) {

        SupplierOrderItemExample example = new SupplierOrderItemExample();
        example.setPageView(new PageView<SupplierOrderItem>(pageNo, pageSize));
        SupplierOrderItemExample.Criteria criteria = example.createCriteria();
        //
        criteria.andBackGoodsItemEqualTo("X");
        //
        criteria.andAttribute1EqualTo(String.valueOf(PurchaseOrderSendStatusEnum.SENDED.getValue()));
        //
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }

        example.setOrderByClause("ORDER_ITEM_NO ASC,HAVE_CHANGE DESC");
        PageView<SupplierOrderItem> pageData = this.supplierOrderItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(httpMethod = "POST", value = "销售方拒绝或者确认订单行：入参（所选订单行）")
    @RequestMapping("service/supplierReturnOrderItemRefuse")
    @ResponseBody
    public ResponseResult<String> supplierReturnOrderItemRefuse(@RequestBody List<SupplierOrderItem> SupplierOrderItems) {
        if (SupplierOrderItems == null) {
            throw new CommonException("数据不能为空", "base_canot_be_null", "数据");
        }
        if (CollectionUtils.isEmpty(SupplierOrderItems)) {
            throw new CommonException("行数据不存在", "do_not_exists", "行数据");
        }
        this.supplierOrderItemService.supplierOrderItemRefuse(SupplierOrderItems);
        return ResponseResult.success();
    }



    @ApiOperation(httpMethod = "POST", value = "分页查询采购订单报表(供应商)")
    @RequestMapping("service/findReportByPage")
    @ResponseBody
    public ResponseResult<PageView<SupplierOrderReport>> findReportByPage(
            @ApiParam(value = "所在页", defaultValue = "0") @RequestParam(defaultValue = "0") int pageNo,
            @ApiParam(value = "每页数量", defaultValue = "10") @RequestParam(defaultValue = "10") int pageSize,
            @ApiParam("通用查询条件") @RequestBody(required = false) QueryParamWapper wapper) {

        SupplierOrderReportExample example = new SupplierOrderReportExample();
        example.setPageView(new PageView<SupplierOrderReport>(pageNo, pageSize));
        SupplierOrderReportExample.Criteria criteria = example.createCriteria();
        criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        if (wapper != null) {
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
        PageView<SupplierOrderReport> pageData = this.supplierOrderItemService.selectSupplierOrderReportByPage(example);
        return ResponseResult.success(pageData);
    }

    @ApiOperation(value = "订单报表导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcel")
    @ResponseBody
    public ModelAndView downloadReportExcel(String queryParams, HttpServletResponse response) {
        try {

            logger.info("订单报表导出Excel 供应商代码:{},供应商名称:{},开始时间",CompanyUtils.currentCompany().getCompanySapCode(),CompanyUtils.currentCompany().getCompanyName());
            logger.info("订单报表导出Excel 参数{}" , queryParams);

            SupplierOrderReportExample example = new SupplierOrderReportExample();
            SupplierOrderReportExample.Criteria criteria = example.createCriteria();
            example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotEmpty(queryParams)) {
                QueryParamWapper queryParamWapper = JsonUtil.convertValue(queryParams, QueryParamWapper.class);
                CriteriaUtils.addCriterion(criteria, queryParamWapper);
            }
            List<SupplierOrderReport> supplierOrderReportList = this.supplierOrderItemService.selectSupplierOrderReportForExcel(example);

            logger.info("订单报表导出Excel 数据条数{}" ,supplierOrderReportList.size());

            response.reset();

            String filename = "采购订单报表" + System.currentTimeMillis() + ".xls";
            logger.info("订单报表导出Excel 文件名称{}" ,filename);

            StringBuffer header = new StringBuffer("attachment;");
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            //获取表头
            List<TitleAndModelKey> titleAndModelKeys = getTitleAndModelKeys();

            logger.info("订单报表导出Excel 开始导出文件");

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, supplierOrderReportList, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();

            logger.info("订单报表导出Excel 文件导出成功");

        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    @ApiOperation(value = "订单报表导出Excel", httpMethod = "GET")
    @RequestMapping(value = "service/downloadReportExcelBySelect")
    @ResponseBody
    public ModelAndView downloadReportExcelBySelect(
            @ApiParam(value = "采购订单行id", defaultValue = "") @RequestParam(defaultValue = "") String orderItemIdList,
            HttpServletResponse response) {
        try {
            logger.info("订单报表导出Excel 参数：{}" , orderItemIdList);

            SupplierOrderReportExample example = new SupplierOrderReportExample();
            SupplierOrderReportExample.Criteria criteria = example.createCriteria();
            criteria.andCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotBlank(orderItemIdList)) {
                criteria.andIdIn(Arrays.asList(orderItemIdList.split(",")));
            }
            String companyName = CompanyUtils.currentCompany().getCompanyName();
            example.setOrderByClause("CREATE_TIME DESC, ORDER_NO ASC, ORDER_ITEM_NO ASC");
            List<SupplierOrderReport> supplierOrderReports = this.supplierOrderItemService.selectSupplierOrderReportForExcel(example);

            logger.info("订单报表导出Excel 数据条数" + supplierOrderReports.size());
            String filename = companyName + "采购订单报表" + System.currentTimeMillis() + ".xls";
            logger.info("订单报表导出Excel 文件名称:{}" ,filename);

            response.reset();
            StringBuffer header = new StringBuffer("attachment;");
            //header.append("filename=\"" + URLEncoder.encode("采购订单报表.xls", "UTF-8") + "\";");
            header.append("filename=\"" + URLEncoder.encode(filename, "UTF-8") + "\";");
            response.setHeader("Content-Disposition", header.toString());
            response.setCharacterEncoding("UTF-8");
            response.setContentType("application/vnd.ms-excel");
            OutputStream outputStream = response.getOutputStream();

            //获取表头
            List<TitleAndModelKey> titleAndModelKeys = this.getTitleAndModelKeys();

            logger.info("订单报表导出Excel 开始导出文件");

            WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel(outputStream, titleAndModelKeys, supplierOrderReports, "采购订单报表", null, 0);
            writableWorkbook.write();
            outputStream.flush();
            writableWorkbook.close();
            outputStream.close();

            logger.info("订单报表导出Excel 文件导出成功");

        } catch (Exception e) {
            e.printStackTrace();
            response.setStatus(HttpServletResponse.SC_EXPECTATION_FAILED);
        }
        return null;
    }

    private List<TitleAndModelKey> getTitleAndModelKeys() {
        List<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();

        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单类型描述", "orderTypeDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购订单号", "orderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("行项目号", "orderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("确认状态", "orderStatus"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("备注", "remark"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("删除标识", "isEnable"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("退货项目", "backGoodsItem"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目类别描述", "itemDescription"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("工厂", "factory"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料编码", "materialCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("物料描述", "materialName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("规格", "specification"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("图号", "mapNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单数量", "quantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("订单单位", "orderUnit"));

        TitleAndModelKey titleAndModelKey = ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate");
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey.setToObjConverter(dateConverter);
        titleAndModelKey.setToStrConverter(dateConverter);
        titleAndModelKeys.add(titleAndModelKey);

        TitleAndModelKey titleReceivedQuantity = ExcelUtils.createTitleAndModelKey("已收货数量", "receivedQuantity");
        BigDecimalConverter receivedQuantityConverter=new BigDecimalConverter();
        titleReceivedQuantity.setToObjConverter(receivedQuantityConverter);
        titleReceivedQuantity.setToStrConverter(receivedQuantityConverter);
        titleAndModelKeys.add(titleReceivedQuantity);

        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("已收货数量", "receivedQuantity"));


        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待收货数量", "waitReceiveQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货已完成", "finishFlag"));
        // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("凭证日期", "orderDate"));

        // titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("交货日期", "deliveredDate"));
        TitleAndModelKey titleAndModelKey2 = ExcelUtils.createTitleAndModelKey("订单日期", "mOrderDate");
        DateConverter dateConverter2 = new DateConverter().setDateFormat("yyyy-MM-dd");
        titleAndModelKey2.setToObjConverter(dateConverter2);
        titleAndModelKey2.setToStrConverter(dateConverter2);
        titleAndModelKeys.add(titleAndModelKey2);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购员名称", "buyerName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求跟踪号", "needFollowNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("净价", "noTaxPrice"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价格单位", "priceUnit"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("金额", "orderValue"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("价税合计", "priceTaxTotal"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("币别", "currency"));
        //titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目号", "wbsNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("项目描述", "projectDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("WBS项目描述", "wbsNoDesc"));
            /*titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("理论交货日", "theoryDeliverDate"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("是否紧急", "isUrgency"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购周期", "purchasePeriod"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("库存地点", "storageSite"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购信息记录", "purchaseInfoRecord"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议号", "purchaseProtocalNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购协议项目", "purchaseProtocalItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请号", "purReqNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请行号", "purchaseApplyItemNo"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("采购申请创建人", "purApplyCreator"));
            titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("需求者", "needer"));*/
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("可发货数量", "deliveryAmount"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("在途数量", "onwayQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("预制发票数量", "preInvoiceQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("发票已过账数量", "postAccountQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("待开发票数量", "waitInvoiceQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商编码", "supCompanyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey("供应商名称", "supCompanyName"));
        return titleAndModelKeys;
    }
}