package com.els.base.voucher.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.voucher.dao.VoucherDeliveryMapper;
import com.els.base.voucher.entity.VoucherDelivery;
import com.els.base.voucher.entity.VoucherDeliveryExample;
import com.els.base.voucher.service.VoucherDeliveryService;

@Service("voucherDeliveryService")
public class VoucherDeliveryServiceImpl implements VoucherDeliveryService {
    @Resource
    protected VoucherDeliveryMapper voucherDeliveryMapper;

    @CacheEvict(value={"voucherDelivery"}, allEntries=true)
    @Override
    public void addObj(VoucherDelivery t) {
        this.voucherDeliveryMapper.insertSelective(t);
    }

    @CacheEvict(value={"voucherDelivery"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.voucherDeliveryMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"voucherDelivery"}, allEntries=true)
    @Override
    public void modifyObj(VoucherDelivery t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.voucherDeliveryMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="voucherDelivery", keyGenerator="redisKeyGenerator")
    @Override
    public VoucherDelivery queryObjById(String id) {
        return this.voucherDeliveryMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="voucherDelivery", keyGenerator="redisKeyGenerator")
    @Override
    public List<VoucherDelivery> queryAllObjByExample(VoucherDeliveryExample example) {
        return this.voucherDeliveryMapper.selectByExample(example);
    }

    @Cacheable(value="voucherDelivery", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<VoucherDelivery> queryObjByPage(VoucherDeliveryExample example) {
        PageView<VoucherDelivery> pageView = example.getPageView();
        pageView.setQueryResult(this.voucherDeliveryMapper.selectByExampleByPage(example));
        return pageView;
    }
    @CacheEvict(value={"voucherDelivery"}, allEntries=true)

	@Override
	public void batchAddObj(List<VoucherDelivery> list) {
    	for (VoucherDelivery voucherDelivery : list) {
    		voucherDelivery.setId(null);
    		this.voucherDeliveryMapper.insert(voucherDelivery);
		}
	}
    @CacheEvict(value={"voucherDelivery"}, allEntries=true)

	@Override
	public void deleteByExample(VoucherDeliveryExample voucherDeliveryExample) {
		this.voucherDeliveryMapper.deleteByExample(voucherDeliveryExample);
		
	}

	@Override
	public boolean exist(String deliveryOrderNo, String deliveryOrderItemNo) {
		VoucherDeliveryExample example = new VoucherDeliveryExample();
		example.createCriteria()
		    .andDeliveryOrderNoEqualTo(deliveryOrderNo)
		    .andDeliveryOrderItemNoEqualTo(deliveryOrderItemNo); 
		
		return this.voucherDeliveryMapper.countByExample(example) > 0;
	}


    @CacheEvict(value={"voucherDelivery"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<VoucherDelivery> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (VoucherDelivery record : arg0) {
			this.voucherDeliveryMapper.insertSelective(record);
		}
	}
}