package com.els.base.voucher.service.impl;

import java.util.List;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import com.els.base.core.entity.PageView;
import com.els.base.voucher.dao.VoucherItemMapper;
import com.els.base.voucher.entity.VoucherItem;
import com.els.base.voucher.entity.VoucherItemExample;
import com.els.base.voucher.service.VoucherItemService;

@Service("voucherItemService")
public class VoucherItemServiceImpl implements VoucherItemService {
    @Resource
    protected VoucherItemMapper voucherItemMapper;

    @CacheEvict(value={"voucherItem"}, allEntries=true)
    @Override
    public void addObj(VoucherItem t) {
        this.voucherItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"voucherItem"}, allEntries=true)
    @Override
    public void deleteObjById(String id) {
        this.voucherItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"voucherItem"}, allEntries=true)
    @Override
    public void modifyObj(VoucherItem t) {
        if (StringUtils.isBlank(t.getId())) {
            throw new NullPointerException("id 为空，无法更新");
        }
        this.voucherItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value="voucherItem", keyGenerator="redisKeyGenerator")
    @Override
    public VoucherItem queryObjById(String id) {
        return this.voucherItemMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value="voucherItem", keyGenerator="redisKeyGenerator")
    @Override
    public List<VoucherItem> queryAllObjByExample(VoucherItemExample example) {
        return this.voucherItemMapper.selectByExample(example);
    }

    @Cacheable(value="voucherItem", keyGenerator="redisKeyGenerator")
    @Override
    public PageView<VoucherItem> queryObjByPage(VoucherItemExample example) {
        PageView<VoucherItem> pageView = example.getPageView();
        pageView.setQueryResult(this.voucherItemMapper.selectByExampleByPage(example));
        return pageView;
    }
    @CacheEvict(value={"voucherItem"}, allEntries=true)

	@Override
	public void batchAddObj(List<VoucherItem> list) {
    	for (VoucherItem voucherItem : list) {
    		voucherItem.setId(null);
    		this.voucherItemMapper.insert(voucherItem);
		}
		
	}
    @CacheEvict(value={"voucherItem"}, allEntries=true)

	@Override
	public void deleteByExample(VoucherItemExample voucherItemExample) {
		this.voucherItemMapper.deleteByExample(voucherItemExample);
		
	}

	@Override
	public boolean exist(String voucherNo, String voucherItemNo) {
		VoucherItemExample example = new VoucherItemExample();
		example.createCriteria().andVoucherNoEqualTo(voucherNo).andVoucherItemNoEqualTo(voucherItemNo);
		return this.voucherItemMapper.countByExample(example) > 0;
	}

    @CacheEvict(value={"voucherItem"}, allEntries=true)
    @Transactional
	@Override
	public void addAll(List<VoucherItem> arg0) {
		if (CollectionUtils.isEmpty(arg0)) {
			return;
		}
		for (VoucherItem record : arg0) {
			this.voucherItemMapper.insertSelective(record);
		}
	}
}