package com.els.base.voucher.web.controller;

import javax.annotation.Resource;

import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.voucher.entity.VoucherDelivery;
import com.els.base.voucher.entity.VoucherDeliveryExample;
import com.els.base.voucher.service.VoucherDeliveryService;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="凭证行和送货行关联表")
@Controller
@RequestMapping("voucherDelivery")
public class VoucherDeliveryController {
    @Resource
    protected VoucherDeliveryService voucherDeliveryService;

    @ApiOperation(httpMethod="POST", value="创建凭证行和送货行关联表")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody VoucherDelivery voucherDelivery) {
        this.voucherDeliveryService.addObj(voucherDelivery);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑凭证行和送货行关联表")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody VoucherDelivery voucherDelivery) {
        if (StringUtils.isBlank(voucherDelivery.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.voucherDeliveryService.modifyObj(voucherDelivery);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除凭证行和送货行关联表")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.voucherDeliveryService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询凭证行和送货行关联表")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<VoucherDelivery>> findByPage(@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="查询条件,属性名请参考 VoucherDelivery") @RequestBody(required=false) QueryParamWapper wapper) {
        VoucherDeliveryExample example = new VoucherDeliveryExample();
        example.setPageView(new PageView<VoucherDelivery>(pageNo, pageSize));
        
        if (wapper != null) {
            VoucherDeliveryExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<VoucherDelivery> pageData = this.voucherDeliveryService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
}