package com.els.base.voucher.web.controller;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

import javax.annotation.Resource;

import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.PurchaseOrderItemExample;
import com.els.base.voucher.entity.VoucherItem;
import com.els.base.voucher.entity.VoucherItemExample;
import com.els.base.purchase.service.PurchaseOrderItemService;
import com.els.base.voucher.service.VoucherItemService;
import com.els.base.voucher.service.VoucherService;
import com.els.base.voucher.service.impl.VoucherServiceImpl2;

import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;

@Api(value="凭证行")
@Controller
@RequestMapping("voucherItem")
public class VoucherItemController {
    @Resource
    protected VoucherItemService voucherItemService;
    
    @Resource(name="voucherService2")
    protected VoucherService voucherService;
    
    @Resource
    protected PurchaseOrderItemService purchaseOrderItemService;

    @ApiOperation(httpMethod="POST", value="创建凭证行")
    @RequestMapping("service/create")
    @ResponseBody
    public ResponseResult<String> create(@RequestBody VoucherItem voucherItem) {
        this.voucherItemService.addObj(voucherItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="编辑凭证行")
    @RequestMapping("service/edit")
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody VoucherItem voucherItem) {
        if (StringUtils.isBlank(voucherItem.getId())) {
            throw new CommonException("id 为空，保存失败");
        }
        this.voucherItemService.modifyObj(voucherItem);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="删除凭证行")
    @RequestMapping("service/deleteById")
    @ResponseBody
    public ResponseResult<String> deleteById(@RequestParam(required=true) String id) {
        if (StringUtils.isBlank(id)) {
            throw new CommonException("删除失败,id不能为空");
        }
        this.voucherItemService.deleteObjById(id);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="查询凭证行")
    @RequestMapping("service/findByPage")
    @ResponseBody
    public ResponseResult<PageView<VoucherItem>> findByPage(@ApiParam(value="所在页",defaultValue="0") @RequestParam(defaultValue="0") int pageNo, @ApiParam(value="每页数量",defaultValue="10") @RequestParam(defaultValue="10") int pageSize, @ApiParam(value="查询条件,属性名请参考 VoucherItem") @RequestBody(required=false) QueryParamWapper wapper) {
        VoucherItemExample example = new VoucherItemExample();
        example.setPageView(new PageView<VoucherItem>(pageNo, pageSize));
        
        if (wapper != null) {
            VoucherItemExample.Criteria criteria = example.createCriteria();
            CriteriaUtils.addCriterion(criteria, wapper);
        }
        
        PageView<VoucherItem> pageData = this.voucherItemService.queryObjByPage(example);
        return ResponseResult.success(pageData);
    }
    
    @ApiOperation(httpMethod="POST", value="处理没有处理的物料凭证行")
    @RequestMapping("service/importUnHandleVoucherItem")
    @ResponseBody
    public ResponseResult<String> importUnHandleVoucherItem(){
    	List<Integer> mobileTypes = new ArrayList<>();
    	mobileTypes.add(122);
    	mobileTypes.add(161);
    	
    	VoucherItemExample example = new VoucherItemExample();
    	example.createCriteria().andMobileTypeIn(mobileTypes);
    	example.setOrderByClause("PUR_ORDER_NO ASC");
    	
    	List<VoucherItem> voucherItems = this.voucherItemService.queryAllObjByExample(example);
    	VoucherServiceImpl2 voucherServiceImpl2 = (VoucherServiceImpl2) this.voucherService;
    	if (CollectionUtils.isEmpty(voucherItems)) {
			return ResponseResult.success();
		}
    	
    	Map<String, List<VoucherItem>> itemMap = new HashMap<>();
    	for(VoucherItem item : voucherItems){
    		List<VoucherItem> list = itemMap.get(item.getPurOrderNo());
    		if (list == null) {
				list = new ArrayList<VoucherItem>();
				itemMap.put(item.getPurOrderNo(), list);
			}
    		
    		PurchaseOrderItemExample purchaseOrderItemExample = new PurchaseOrderItemExample();
    		purchaseOrderItemExample.createCriteria()
    		    .andOrderNoEqualTo(item.getPurOrderNo())
    		    .andOrderItemNoEqualTo(item.getPurOrderItemNo());
    		
    		List<PurchaseOrderItem> purOrderitemList = this.purchaseOrderItemService.queryAllObjByExample(purchaseOrderItemExample);
    		if (CollectionUtils.isNotEmpty(purOrderitemList)) {
				item.setPurchaseOrderItem(purOrderitemList.get(0));
			}
    		list.add(item);
    	}
    	
    	Iterator<String> iterator = itemMap.keySet().iterator();
    	while (iterator.hasNext()) {
			String purOrderNo = iterator.next();
			voucherServiceImpl2.handleForVoucherItem(purOrderNo, itemMap.get(purOrderNo));
		}
    	
    	return ResponseResult.success();
    }
}