/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ICommandInvoker;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.utils.DeliveryOrderItemIsEnableConverter;
import com.els.base.delivery.utils.DeliveryStatusConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import java.util.ArrayList;
import java.util.List;

public class DownloadExcelCommand
extends AbstractCommand<List<TitleAndModelKey>> {
    private static final long serialVersionUID = 1L;
    private List<DeliveryOrderItem> orderItems;

    public DownloadExcelCommand(List<DeliveryOrderItem> orderItems) {
        this.orderItems = orderItems;
    }

    @Override
    public List<TitleAndModelKey> execute(ICommandInvoker context) {
        List<TitleAndModelKey> titleAndModelKeys = this.createExcelHeaderColumnDown(this.orderItems.get(0));
        return titleAndModelKeys;
    }

    private List<TitleAndModelKey> createExcelHeaderColumnDown(DeliveryOrderItem deliveryOrderItem) {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u5355\u53f7", (String)"deliveryOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u7f16\u7801", (String)"companyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4f9b\u5e94\u5546\u540d\u79f0", (String)"companyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u521b\u5efa\u65e5\u671f", (String)"createTime"));
        TitleAndModelKey deliveryStatus = ExcelUtils.createTitleAndModelKey((String)"\u53d1\u8d27\u72b6\u6001", (String)"deliveryStatus");
        DeliveryStatusConverter converter = new DeliveryStatusConverter();
        deliveryStatus.setToObjConverter((StrToObjConverter)converter);
        deliveryStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(deliveryStatus);
        TitleAndModelKey isEnable = ExcelUtils.createTitleAndModelKey((String)"\u5355\u636e\u72b6\u6001", (String)"isEnable");
        DeliveryOrderItemIsEnableConverter isEnableConverter = new DeliveryOrderItemIsEnableConverter();
        isEnable.setToObjConverter((StrToObjConverter)isEnableConverter);
        isEnable.setToStrConverter((ObjToStrConverter)isEnableConverter);
        titleAndModelKeys.add(isEnable);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u65b9\u8d1f\u8d23\u4eba", (String)"purUserName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355\u53f7", (String)"purOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u7f16\u7801", (String)"purCompanyCode"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u540d\u79f0", (String)"purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u91c7\u8d2d\u8ba2\u5355", (String)"purOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879", (String)"purOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u63cf\u8ff0", (String)"materialDesc"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u6570\u91cf", (String)"deliveryQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u6536\u8d27\u6570\u91cf", (String)"receivedQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5e01\u522b", (String)"currency"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u6536\u8d27\u5730\u70b9", (String)"deliveryLocation"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u89c4\u683c", (String)"departmentName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u4ef6\u6570", (String)"packQuantity"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"remark"));
        return titleAndModelKeys;
    }
}

