/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.utils;

import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrderPrint;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.utils.pdf.HtmlToPdfParam;
import com.els.base.utils.pdf.HtmlToPdfUtils;
import com.els.base.utils.template.BeetlTemplateUtils;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.EncodeHintType;
import com.google.zxing.MultiFormatWriter;
import com.google.zxing.WriterException;
import com.google.zxing.client.j2se.MatrixToImageWriter;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.qrcode.decoder.ErrorCorrectionLevel;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.util.Date;
import java.util.HashMap;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.springframework.util.Base64Utils;

public abstract class DeliveryOrderPrintUtils {
    private static int WIDTH = 150;
    private static int HEIGHT = 64;

    public static FileData generateDeliveryOrderPdf(DeliveryOrderPrint deliveryOrderPrint, String printType) throws Exception {
        Assert.isNotBlank((String)deliveryOrderPrint.getFontPath(), (String)"\u5b57\u4f53\u4e0d\u80fd\u4e3a\u7a7a");
        if (!("A5".equals(printType) || "A4".equals(printType) || "Letter".equals(printType) || "LetterA5".equals(printType))) {
            throw new CommonException("\u4e0d\u652f\u6301\u5f53\u524d\u6253\u5370\u7c7b\u578b[" + deliveryOrderPrint.getPrintSizeType() + "]");
        }
        String barcodeBase64 = DeliveryOrderPrintUtils.getBase64QRCode(deliveryOrderPrint.getDeliveryOrderNo());
        deliveryOrderPrint.setScanPicPath(barcodeBase64);
        HashMap<String, DeliveryOrderPrint> params = new HashMap<String, DeliveryOrderPrint>();
        params.put("deliveryOrder", deliveryOrderPrint);
        String headerPath = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderHeader.html", params);
        String footerPath = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderFooter.html", params);
        String html = BeetlTemplateUtils.renderFromFile((String)"deliveryOrderContent.html", params);
        String filename = String.format("\u9001\u8d27\u5355_%s_%s", printType, DateFormatUtils.format((Date)new Date(), (String)"yyyy-MM-dd-HH-mm"));
        FileData pdfFile = DeliveryOrderPrintUtils.createEmptyPDF(deliveryOrderPrint.getProjectId(), deliveryOrderPrint.getPurCompanyId(), filename);
        HtmlToPdfParam param = new HtmlToPdfParam();
        param.setHeaderHtml(headerPath);
        param.setHeaderSpacing("3");
        param.setFooterHtml(footerPath);
        param.setMarginTop("50mm");
        param.setMarginBottom("20mm");
        param.setTitle(filename);
        param.setPageSize(deliveryOrderPrint.getPrintSizeType());
        HtmlToPdfUtils.generatePdf((String)html, (File)pdfFile.toFile(), (HtmlToPdfParam)param);
        return pdfFile;
    }

    public static FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename + ".pdf");
        pdfFile.setFileSuffix("pdf");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    public static String generateBarcodeBase64(String deliveryOrderNo) throws WriterException, IOException {
        BitMatrix bitMatrix = new MultiFormatWriter().encode(deliveryOrderNo, BarcodeFormat.CODE_128, WIDTH, HEIGHT, null);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        outputStream.toByteArray();
        byte[] base64Encode = Base64Utils.encode((byte[])outputStream.toByteArray());
        return new String(base64Encode);
    }

    public static String getBase64QRCode(String content) throws Exception {
        MultiFormatWriter multiFormatWriter = new MultiFormatWriter();
        HashMap<EncodeHintType, Object> hints = new HashMap<EncodeHintType, Object>();
        hints.put(EncodeHintType.MARGIN, 1);
        hints.put(EncodeHintType.ERROR_CORRECTION, ErrorCorrectionLevel.L);
        hints.put(EncodeHintType.CHARACTER_SET, "GBK");
        BitMatrix bitMatrix = multiFormatWriter.encode(content, BarcodeFormat.QR_CODE, 400, 400, hints);
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream();
        MatrixToImageWriter.writeToStream((BitMatrix)bitMatrix, (String)"png", (OutputStream)outputStream);
        outputStream.flush();
        outputStream.close();
        outputStream.toByteArray();
        byte[] base64Encode = Base64Utils.encode((byte[])outputStream.toByteArray());
        return new String(base64Encode);
    }
}

