/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.impl.PurchaseProductServiceImpl;
import com.els.base.utils.SpringContextHolder;
import com.els.base.workflow.common.entity.ProcessStartVO;
import com.els.base.workflow.common.service.WorkFlowService;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.activiti.engine.runtime.ProcessInstance;
import org.apache.commons.collections.CollectionUtils;

public class ProductApproveCmd
extends BaseCommand<String> {
    private List<PurchaseProduct> purchaseProducts;

    public List<PurchaseProduct> getPurchaseProducts() {
        return this.purchaseProducts;
    }

    public void setPurchaseProducts(List<PurchaseProduct> purchaseProducts) {
        this.purchaseProducts = purchaseProducts;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.purchaseProducts);
        this.fill(this.purchaseProducts);
        this.process(this.purchaseProducts);
        return null;
    }

    private void process(List<PurchaseProduct> purchaseProducts) {
        List ids = purchaseProducts.stream().map(PurchaseProduct::getId).collect(Collectors.toList());
        Assert.isNotEmpty(ids, (String)"ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u4e0d\u80fd\u63d0\u4ea4\u5ba1\u6838\uff01");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andIdIn(ids);
        PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
        List list = purchaseProductService.queryAllObjByExample((IExample)example);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return;
        }
        WorkFlowService workFlowService = (WorkFlowService)SpringContextHolder.getOneBean(WorkFlowService.class);
        for (PurchaseProduct purchaseProduct : list) {
            String materialApplyStr = "purchase_product";
            ProcessStartVO vo = null;
            vo = ProcessStartVO.newInstance((String)materialApplyStr, (String)purchaseProduct.getProductCode(), (String)purchaseProduct.getId(), (String)("/product/purProduct?id=" + purchaseProduct.getId()));
            purchaseProduct.setApproveCode(materialApplyStr);
            vo.setListenerClass(PurchaseProductServiceImpl.class);
            ProcessInstance startProcess = workFlowService.startProcess(vo);
            if (startProcess == null) continue;
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPLYING.getValue());
            purchaseProductService.modifyObj(purchaseProduct);
        }
    }

    private void fill(List<PurchaseProduct> materialApplies) {
    }

    private void check(List<PurchaseProduct> purchaseProducts) {
        Assert.isNotEmpty(purchaseProducts, (String)"\u8bf7\u9009\u62e9\u9700\u8981\u5ba1\u6279\u7684\u6570\u636e\uff01");
        PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
        List collect = purchaseProducts.stream().map(PurchaseProduct::getId).collect(Collectors.toList());
        PurchaseProductExample example = new PurchaseProductExample();
        PurchaseProductExample.Criteria criteria1 = example.createCriteria().andIdIn(collect).andApproveStatusEqualTo(ApproveStatusEnum.APPLYING.getValue());
        PurchaseProductExample.Criteria criteria2 = example.createCriteria().andIdIn(collect).andApproveStatusEqualTo(ApproveStatusEnum.APPROVE_PASS.getValue());
        example.or(criteria2);
        int i = purchaseProductService.countByExample(example);
        if (i > 0) {
            throw new CommonException("\u63d0\u4ea4\u7684\u5355\u636e\u53ef\u80fd\u5305\u542b\u4e86\u5ba1\u6279\u4e2d\u6216\u8005\u5ba1\u6279\u901a\u8fc7\u7684\u6570\u636e\uff0c\u8bf7\u68c0\u67e5\uff01");
        }
    }
}

