/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;

public class BatchModifyPlanIsCanDeliveryCmd
extends AbstractCommand<Void> {
    private static final long serialVersionUID = 1L;
    private List<String> planItemIdList;

    public BatchModifyPlanIsCanDeliveryCmd(List<String> planItemIdList) {
        this.planItemIdList = planItemIdList;
    }

    @Override
    public Void execute(ICommandInvoker context) {
        Assert.isNotEmpty(this.planItemIdList, (String)"\u8ba1\u5212\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<SupDeliveryPlanItem> planItemList = this.getPlanItemList(this.planItemIdList);
        Assert.isNotEmpty(planItemList, (String)"\u8ba1\u5212\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        List<SupDeliveryPlanItem> noneJitPlanItemList = planItemList.stream().filter(plan -> !Constant.YES_INT.equals(plan.getIsJit())).collect(Collectors.toList());
        this.updateNoneJitPlan(noneJitPlanItemList);
        return null;
    }

    private List<SupDeliveryPlanItem> getPlanItemList(List<String> planItemIdList) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andIdIn((List)planItemIdList);
        return ContextUtils.getSupDeliveryPlanItemService().queryAllObjByExample((IExample)example);
    }

    private void updateNoneJitPlan(List<SupDeliveryPlanItem> noneJitPlanItemList) {
        if (CollectionUtils.isEmpty(noneJitPlanItemList)) {
            return;
        }
        this.updatePlanItemList(noneJitPlanItemList);
        List orderItemIdList = noneJitPlanItemList.stream().map(SupDeliveryPlanItem::getPurOrderItemId).distinct().collect(Collectors.toList());
        if (CollectionUtils.isEmpty(orderItemIdList)) {
            return;
        }
        for (String orderItemId : orderItemIdList) {
            SupplierOrderItem orderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(orderItemId);
            if (!Constant.NO_INT.equals(orderItem.getIsCanDelivery())) continue;
            this.updatePlanItemNoCanDelivery(orderItemId);
        }
    }

    private void updatePlanItemNoCanDelivery(String orderItemId) {
        SupDeliveryPlanItemExample supPlanExample = new SupDeliveryPlanItemExample();
        supPlanExample.createCriteria().andPurOrderItemIdEqualTo(orderItemId).andIsJitEqualTo(Constant.NO_INT);
        SupDeliveryPlanItem tempSupPlanItem = new SupDeliveryPlanItem();
        tempSupPlanItem.setIsCanDelivery(Constant.NO_INT);
        ContextUtils.getSupDeliveryPlanItemService().modifyByExample(tempSupPlanItem, supPlanExample);
        PurDeliveryPlanItemExample purPlanExample = new PurDeliveryPlanItemExample();
        purPlanExample.createCriteria().andPurOrderItemIdEqualTo(orderItemId).andIsJitEqualTo(Constant.NO_INT);
        PurDeliveryPlanItem tempPurPlanItem = new PurDeliveryPlanItem();
        tempPurPlanItem.setIsCanDelivery(Constant.NO_INT);
        ContextUtils.getPurDeliveryPlanItemService().modifyByExample(tempPurPlanItem, purPlanExample);
    }

    private void updatePlanItemList(List<SupDeliveryPlanItem> jitPlanItemList) {
        if (CollectionUtils.isEmpty(jitPlanItemList)) {
            return;
        }
        for (SupDeliveryPlanItem supDeliveryPlanItem : jitPlanItemList) {
            this.updatePlanStatus(supDeliveryPlanItem);
        }
    }

    private void updatePlanStatus(SupDeliveryPlanItem supPlanItem) {
        BigDecimal supCanDeliveryQuantity = ContextUtils.getSupDeliveryPlanItemService().calculateCanDeliveryQuantity(supPlanItem.getId());
        Integer isCanDelivery = this.getIsCanDelivery(supPlanItem, supCanDeliveryQuantity);
        this.logger.info(String.format("EVENT=\u53d8\u66f4\u9001\u8d27\u901a\u77e5\u5355\u53ef\u53d1\u8d27\u6807\u8bb0|ID=%s|orderNo=%s|orderItemNo=%s|\u662f\u5426\u53ef\u53d1\u8d27=%d", supPlanItem.getId(), supPlanItem.getPurOrderNo(), supPlanItem.getPurOrderItemNo(), isCanDelivery));
        String usedStatus = this.getUsedStatus(supPlanItem, supCanDeliveryQuantity);
        this.logger.info(String.format("EVENT=\u53d8\u66f4\u9001\u8d27\u901a\u77e5\u5355\u662f\u5426\u53d1\u8d27\u6807\u8bb0|ID=%s|orderNo=%s|orderItemNo=%s|\u662f\u5426\u5df2\u53d1\u8d27\u72b6\u6001=%s", supPlanItem.getId(), supPlanItem.getPurOrderNo(), supPlanItem.getPurOrderItemNo(), usedStatus));
        if (isCanDelivery == null && usedStatus == null) {
            return;
        }
        PurDeliveryPlanItem tempPurPlanItem = new PurDeliveryPlanItem();
        tempPurPlanItem.setId(supPlanItem.getId());
        tempPurPlanItem.setIsCanDelivery(isCanDelivery);
        tempPurPlanItem.setUsedStatus(usedStatus);
        ContextUtils.getPurDeliveryPlanItemService().modifyObj(tempPurPlanItem);
        SupDeliveryPlanItem tempSupPlanItem = new SupDeliveryPlanItem();
        tempSupPlanItem.setId(supPlanItem.getId());
        tempSupPlanItem.setIsCanDelivery(isCanDelivery);
        tempSupPlanItem.setUsedStatus(usedStatus);
        ContextUtils.getSupDeliveryPlanItemService().modifyObj(tempSupPlanItem);
    }

    private String getUsedStatus(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        String usedStatus = null;
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) == 0 && !DeliveryPlanUesdStatusEnum.UN_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.UN_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0 && !DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.ALL_USED.getValue();
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) < 0 && supCanDeliveryQuantity.compareTo(supPlanItem.getDeliveryQuantity()) < 0 && !DeliveryPlanUesdStatusEnum.PART_USED.getValue().equals(supPlanItem.getUsedStatus())) {
            usedStatus = DeliveryPlanUesdStatusEnum.PART_USED.getValue();
        }
        return usedStatus;
    }

    private Integer getIsCanDelivery(SupDeliveryPlanItem supPlanItem, BigDecimal supCanDeliveryQuantity) {
        if (supPlanItem.getIsJit().equals(Constant.YES_INT) && DeliveryPlanUesdStatusEnum.COLSE_SUCCESS.getValue().equals(supPlanItem.getUsedStatus())) {
            return null;
        }
        if (BigDecimal.ZERO.compareTo(supCanDeliveryQuantity) >= 0) {
            return Constant.NO_INT;
        }
        return Constant.YES_INT;
    }
}

