/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.common.OrderCommandInvoker;
import com.els.base.company.entity.Company;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.project.ProjectUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.file.entity.FileData;
import com.els.base.file.service.FileManagerFactory;
import com.els.base.msg.Message;
import com.els.base.msg.MessageLevelEnum;
import com.els.base.msg.MessageSendUtils;
import com.els.base.plan.command.nonejit.sup.ImportSupDonePlanItemCmd;
import com.els.base.plan.command.nonejit.sup.ImportSupToDoPlanItemCmd;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSendToPurCmd;
import com.els.base.plan.command.nonejit.sup.NoneJitPlanSupConfirmCmd;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.service.PurDeliveryPlanItemService;
import com.els.base.plan.service.SupDeliveryPlanItemService;
import com.els.base.plan.utils.ChangeReasonConverter;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.plan.utils.PlanDataSourceEnum;
import com.els.base.plan.utils.PlanMsgBusinessTypeEnum;
import com.els.base.purchase.utils.ConfirmStatusConverter;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import com.els.base.utils.excel.DateConverter;
import com.els.base.utils.excel.ExcelUtils;
import com.els.base.utils.excel.ObjToStrConverter;
import com.els.base.utils.excel.StrToObjConverter;
import com.els.base.utils.excel.TitleAndModelKey;
import com.qqt.message.client.JsonUtil;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import javax.servlet.http.HttpServletResponse;
import jxl.write.WritableWorkbook;
import jxl.write.WriteException;
import jxl.write.biff.RowsExceededException;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.lang.time.DateFormatUtils;
import org.apache.commons.lang.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Api(tags={"\u9001\u8d27\u8ba1\u5212\u884c"})
@Controller
@RequestMapping(value={"supDeliveryPlanItem"})
public class SupDeliveryPlanItemController {
    private static final Logger logger = LoggerFactory.getLogger(SupDeliveryPlanItemController.class);
    @Resource
    protected SupDeliveryPlanItemService supDeliveryPlanItemService;
    @Resource
    protected PurDeliveryPlanItemService purDeliveryPlanItemService;
    @Resource
    protected DeliveryOrderItemService deliveryOrderItemService;
    @Resource
    protected OrderCommandInvoker orderCommandInvoker;

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5df2\u786e\u8ba4\u7684\u975eJIT\u9001\u8d27\u5355\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupDeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findDoneNoneJitPlan"})
    @ResponseBody
    public ResponseResult<PageView<SupDeliveryPlanItem>> findDoneNoneJitPlan(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setPageView((PageView<SupDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
        criteria.andIsJitEqualTo(Constant.NO_INT);
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        criteria.andUsedStatusEqualTo(DeliveryPlanUesdStatusEnum.UN_USED.getValue());
        criteria.andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supDeliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5f85\u56de\u7b7e\u7684\u975eJIT\u9001\u8d27\u8ba1\u5212\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 SupDeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findToDoNonePlan"})
    @ResponseBody
    public ResponseResult<PageView<SupDeliveryPlanItem>> findToDoNonePlan(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setPageView((PageView<SupDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsJitEqualTo(Constant.NO_INT).andUsedStatusEqualTo(DeliveryPlanUesdStatusEnum.UN_USED.getValue()).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        example.or().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsJitEqualTo(Constant.NO_INT).andUsedStatusEqualTo(DeliveryPlanUesdStatusEnum.UN_USED.getValue()).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supDeliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u53d1\u9001\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/sendToPur"})
    @ResponseBody
    public ResponseResult<String> sendToPur(@RequestBody List<SupDeliveryPlanItem> planList) {
        Assert.isNotEmpty(planList, (String)"\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        NoneJitPlanSendToPurCmd command = new NoneJitPlanSendToPurCmd(planList, PlanDataSourceEnum.UI);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderCommandInvoker.invoke(command);
        this.sendMsgForPlan(planList);
        return ResponseResult.success();
    }

    private void sendMsgForPlan(List<SupDeliveryPlanItem> planList) {
        Map<String, List<SupDeliveryPlanItem>> planerGroup = planList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurPlanerId));
        planerGroup.forEach((planerId, planItemList) -> {
            if (CollectionUtils.isEmpty((Collection)planItemList)) {
                return;
            }
            Map<Integer, List<SupDeliveryPlanItem>> confirmStatusGroup = planItemList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getSupConfirmStatus));
            List<SupDeliveryPlanItem> confirmPlanList = confirmStatusGroup.get(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            List<SupDeliveryPlanItem> refusePlanList = confirmStatusGroup.get(PurchaseOrderConfirmStatusEnum.ALL_REFUSE.getValue());
            if (CollectionUtils.isNotEmpty(confirmPlanList)) {
                this.sendForConfirmOrRefusePlan((String)planerId, confirmPlanList, PurchaseOrderConfirmStatusEnum.CONFIRM);
            }
            if (CollectionUtils.isNotEmpty(refusePlanList)) {
                this.sendForConfirmOrRefusePlan((String)planerId, refusePlanList, PurchaseOrderConfirmStatusEnum.ALL_REFUSE);
            }
        });
    }

    private void sendForConfirmOrRefusePlan(String planerId, List<SupDeliveryPlanItem> confirmPlanList, PurchaseOrderConfirmStatusEnum confirm) {
        String senderId = SpringSecurityUtils.getLoginUserId();
        try {
            Message<Map<String, Object>> message = this.generateMsg(confirmPlanList, confirm);
            if (message == null) {
                return;
            }
            message.addReceiverId(planerId).setSenderId(senderId).setCompanyCode(CompanyUtils.currentCompany().getCompanyCode()).setMsgLevel(MessageLevelEnum.HIGH).setBusinessTypeCode(PlanMsgBusinessTypeEnum.DELIVERY_PLAN_SUP_MSG.getCode());
            MessageSendUtils.sendMessage(message);
        }
        catch (Exception e) {
            logger.error("\u53d1\u9001\u6d88\u606f\u5931\u8d25", (Throwable)e);
        }
    }

    private Message<Map<String, Object>> generateMsg(List<SupDeliveryPlanItem> confirmPlanList, PurchaseOrderConfirmStatusEnum confirm) {
        if (CollectionUtils.isEmpty(confirmPlanList)) {
            return null;
        }
        Map<String, List<SupDeliveryPlanItem>> orderNoGroup = confirmPlanList.stream().collect(Collectors.groupingBy(SupDeliveryPlanItem::getPurOrderNo));
        ArrayList orderList = new ArrayList();
        orderNoGroup.forEach((orderNo, planList) -> {
            String orderItemList = planList.stream().map(SupDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.joining(","));
            orderList.add(String.format("[%s:%s]", orderNo, orderItemList));
        });
        String msg = null;
        String type = null;
        String orderListStr = StringUtils.join(orderList, (String)",");
        String supCompanyName = CompanyUtils.currentCompany().getCompanyName();
        switch (confirm) {
            case CONFIRM: {
                type = String.format("\u4f9b\u5e94\u5546[%s]\u786e\u8ba4\u9001\u8d27\u901a\u77e5\u5355", supCompanyName);
                msg = String.format("%s,\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6:%s", type, orderListStr);
                break;
            }
            case ALL_REFUSE: {
                type = String.format("\u4f9b\u5e94\u5546[%s]\u53d8\u66f4\u9001\u8d27\u901a\u77e5\u5355", supCompanyName);
                msg = String.format("%s,\u8bf7\u8fdb\u884c\u786e\u8ba4\u6216\u62d2\u7edd,\u91c7\u8d2d\u8ba2\u5355\u660e\u7ec6:%s", type, orderListStr);
                break;
            }
            default: {
                return null;
            }
        }
        HashMap<String, Object> data = new HashMap<String, Object>();
        data.put("orderNo", StringUtils.join(orderNoGroup.keySet(), (String)","));
        data.put("priceTaxTotal", "--");
        data.put("orderDate", new Date());
        data.put("remark", msg);
        data.put("orderList", orderList);
        data.put("supCompanyName", supCompanyName);
        data.put("type", type);
        return Message.init(data);
    }

    @ApiOperation(httpMethod="POST", value="\u786e\u8ba4\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/confirm"})
    @ResponseBody
    public ResponseResult<String> confirm(@RequestBody List<SupDeliveryPlanItem> planList) {
        NoneJitPlanSupConfirmCmd command = new NoneJitPlanSupConfirmCmd(planList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderCommandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u62d2\u7edd\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/refuse"})
    @ResponseBody
    public ResponseResult<String> refuse(@RequestBody List<SupDeliveryPlanItem> planList) {
        NoneJitPlanSupConfirmCmd command = new NoneJitPlanSupConfirmCmd(planList);
        command.setSupCompany(CompanyUtils.currentCompany());
        command.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderCommandInvoker.invoke(command);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2[Jit]\u9001\u8d27\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findJitPlanItemByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupDeliveryPlanItem>> findJitPlanItemByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        Company currentCompany = CompanyUtils.currentCompany();
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setPageView((PageView<SupDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_DATE ASC, PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
        criteria.andIsJitEqualTo(Constant.YES_INT);
        criteria.andIsEnableEqualTo(Constant.YES_INT);
        criteria.andIsCanDeliveryEqualTo(Constant.YES_INT);
        criteria.andPlanSendStatusEqualTo("Y");
        criteria.andSupCompanyIdEqualTo(currentCompany.getId());
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supDeliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u5206\u9875\u67e5\u8be2[\u975eJit]\u9001\u8d27\u884c")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryPlanItem", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findNotJitPlanItemByPage"})
    @ResponseBody
    public ResponseResult<PageView<SupDeliveryPlanItem>> findNotJitPlanItemByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestParam(required=false) String deliveryOrderId, @RequestBody(required=false) QueryParamWapper wapper) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.setPageView((PageView<SupDeliveryPlanItem>)new PageView(pageNo, pageSize));
        example.setOrderByClause("DELIVERY_DATE ASC, PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
        example.createCriteria().andIsJitEqualTo(Constant.NO_INT).andIsEnableEqualTo(Constant.YES_INT).andSupCompanyIdEqualTo(CompanyUtils.currentCompany().getId()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andIsCanDeliveryEqualTo(Constant.YES_INT).andUsedStatusNotEqualTo(DeliveryPlanUesdStatusEnum.ALL_USED.getValue());
        if (StringUtils.isNotBlank((String)deliveryOrderId)) {
            DeliveryOrderItemExample deliveryOrderItemExample = new DeliveryOrderItemExample();
            deliveryOrderItemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrderId);
            List itemList = this.deliveryOrderItemService.queryAllObjByExample((IExample)deliveryOrderItemExample);
            List planItemIdList = itemList.stream().map(DeliveryOrderItem::getDeliveryPlanItemId).collect(Collectors.toList());
            example.or().andIdIn(planItemIdList);
        }
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.supDeliveryPlanItemService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7dexcel\uff0c\u5bfc\u51fa\u5df2\u786e\u8ba4\u7684\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/downloadDoneNoneJitPlan"})
    @ResponseBody
    public ResponseResult<FileData> downloadDoneNoneJitPlan(@RequestBody(required=false) List<SupDeliveryPlanItem> noneJitPlanList, String queryParams, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        if (CollectionUtils.isEmpty(noneJitPlanList)) {
            SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andIsJitEqualTo(Constant.NO_INT);
            criteria.andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            criteria.andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            criteria.andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            noneJitPlanList = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List planItems = new ArrayList();
        if (CollectionUtils.isNotEmpty(noneJitPlanList)) {
            List orderNoList = noneJitPlanList.stream().map(SupDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
            List orderItemNoList = noneJitPlanList.stream().map(SupDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
            example.clear();
            example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
            SupDeliveryPlanItemExample.Criteria criteria = example.createCriteria();
            criteria.andPurOrderNoIn(orderNoList);
            criteria.andPurOrderItemNoIn(orderItemNoList);
            criteria.andIsJitEqualTo(Constant.NO_INT);
            criteria.andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId());
            planItems = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createHeader();
        String fileName = String.format("\u9001\u8d27\u901a\u77e5\u5355\u53d8\u66f4%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream os = new FileOutputStream(file);
        WritableWorkbook writableWorkbook = ExcelUtils.exportDataToExcel((OutputStream)os, titleAndModelKeys, planItems, (String)"\u9001\u8d27\u901a\u77e5\u5355", null, (int)0);
        try {
            writableWorkbook.write();
            os.flush();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            writableWorkbook.close();
            os.close();
        }
        return ResponseResult.success((Object)fileData);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @ApiOperation(httpMethod="POST", value="\u4e0b\u8f7dexcel\uff0c\u5bfc\u51fa\u56de\u7b7e\u7684\u4ea4\u8d27\u8ba1\u5212")
    @RequestMapping(value={"service/downloadToDoNonePlan"})
    @ResponseBody
    public ResponseResult<FileData> downloadToDoNonePlan(@RequestBody(required=false) List<SupDeliveryPlanItem> noneJitPlanList, String queryParams, HttpServletResponse response) throws RowsExceededException, WriteException, IOException, ParseException {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        if (CollectionUtils.isEmpty(noneJitPlanList)) {
            example.createCriteria().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsJitEqualTo(Constant.NO_INT).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            example.or().andSupCompanyIdEqualTo(CompanyUtils.currentCompanyId()).andIsJitEqualTo(Constant.NO_INT).andPurOrderStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue()).andSupConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue()).andPurConfirmStatusEqualTo(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            if (StringUtils.isNotEmpty((String)queryParams)) {
                QueryParamWapper queryParamWapper = (QueryParamWapper)JsonUtil.convertValue((String)queryParams, QueryParamWapper.class);
                CriteriaUtils.addExample((IExample)example, (QueryParamWapper)queryParamWapper);
            }
            noneJitPlanList = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List planItems = new ArrayList();
        if (CollectionUtils.isNotEmpty(noneJitPlanList)) {
            List orderNoList = noneJitPlanList.stream().map(SupDeliveryPlanItem::getPurOrderNo).distinct().collect(Collectors.toList());
            List orderItemNoList = noneJitPlanList.stream().map(SupDeliveryPlanItem::getPurOrderItemNo).distinct().collect(Collectors.toList());
            example.clear();
            example.setOrderByClause("PUR_ORDER_NO DESC, PUR_ORDER_ITEM_NO ASC");
            example.createCriteria().andPurOrderNoIn(orderNoList).andPurOrderItemNoIn(orderItemNoList);
            planItems = this.supDeliveryPlanItemService.queryAllObjByExample((IExample)example);
        }
        List<TitleAndModelKey> titleAndModelKeys = this.createHeader();
        String fileName = String.format("\u9001\u8d27\u901a\u77e5\u5355\u56de\u7b7e%s.xls", DateFormatUtils.format((Date)new Date(), (String)"yyyyMMdd"));
        FileData fileData = this.createEmptyPDF(ProjectUtils.getProjectId(), CompanyUtils.currentCompanyId(), fileName);
        File file = fileData.toFile();
        FileOutputStream fos = new FileOutputStream(file);
        WritableWorkbook workbook = ExcelUtils.exportDataToExcel((OutputStream)fos, titleAndModelKeys, planItems, (String)"\u9001\u8d27\u901a\u77e5\u5355", null, (int)0);
        try {
            workbook.write();
            fos.flush();
        }
        catch (Exception e) {
            logger.error("\u5bfc\u51fa\u6587\u4ef6\u5931\u8d25", (Throwable)e);
        }
        finally {
            workbook.close();
            fos.close();
        }
        return ResponseResult.success((Object)fileData);
    }

    private FileData createEmptyPDF(String projectId, String companyId, String filename) throws UnsupportedEncodingException, IOException {
        FileData pdfFile = new FileData();
        pdfFile.setProjectId(projectId);
        pdfFile.setCompanyId(companyId);
        pdfFile.setFileName(filename);
        pdfFile.setFileSuffix("xls");
        pdfFile.setIsEncrypt(String.valueOf(Constant.NO_INT));
        pdfFile.setExpiryDay(DateUtils.addMinutes((Date)new Date(), (int)30));
        FileManagerFactory.getFileManager().createEmptyFile(pdfFile);
        return pdfFile;
    }

    private List<TitleAndModelKey> createHeader() {
        ArrayList<TitleAndModelKey> titleAndModelKeys = new ArrayList<TitleAndModelKey>();
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5ba2\u6237\u540d\u79f0", (String)"purCompanyName"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u53f7", (String)"purOrderNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u9879\u76ee\u53f7", (String)"purOrderItemNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u7f16\u7801", (String)"materialNo"));
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u7269\u6599\u540d\u79f0", (String)"materialDesc"));
        DateConverter dateConverter = new DateConverter().setDateFormat("yyyyMMdd");
        TitleAndModelKey orderDeliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u4ea4\u8d27\u65e5\u671f", (String)"orderDeliveryDate");
        orderDeliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        orderDeliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(orderDeliveryDate);
        TitleAndModelKey deliveryDate = ExcelUtils.createTitleAndModelKey((String)"\u5b9e\u9645\u4ea4\u8d27\u65e5\u671f", (String)"deliveryDate");
        deliveryDate.setToObjConverter((StrToObjConverter)dateConverter);
        deliveryDate.setToStrConverter((ObjToStrConverter)dateConverter);
        titleAndModelKeys.add(deliveryDate);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u9001\u8d27\u6570\u91cf", (String)"deliveryQuantity"));
        ConfirmStatusConverter converter = new ConfirmStatusConverter();
        TitleAndModelKey purPlanStatus = ExcelUtils.createTitleAndModelKey((String)"\u8ba1\u5212\u72b6\u6001", (String)"supConfirmStatus");
        purPlanStatus.setToObjConverter((StrToObjConverter)converter);
        purPlanStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(purPlanStatus);
        TitleAndModelKey purOrderStatus = ExcelUtils.createTitleAndModelKey((String)"\u8ba2\u5355\u72b6\u6001", (String)"purOrderStatus");
        purOrderStatus.setToObjConverter((StrToObjConverter)converter);
        purOrderStatus.setToStrConverter((ObjToStrConverter)converter);
        titleAndModelKeys.add(purOrderStatus);
        TitleAndModelKey changeReason = ExcelUtils.createTitleAndModelKey((String)"\u8d23\u4efb\u65b9", (String)"changeReason");
        changeReason.setDefaultValue("\u4f9b\u5e94\u5546\u539f\u56e0");
        ChangeReasonConverter changeReasonConverter = new ChangeReasonConverter();
        changeReason.setToObjConverter((StrToObjConverter)changeReasonConverter);
        changeReason.setToStrConverter((ObjToStrConverter)changeReasonConverter);
        titleAndModelKeys.add(changeReason);
        titleAndModelKeys.add(ExcelUtils.createTitleAndModelKey((String)"\u5907\u6ce8", (String)"supRemark"));
        return titleAndModelKeys;
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20excel\uff0c\u5bfc\u5165\u56de\u7b7e\u975eJit\u8ba1\u5212\u6570\u636e")
    @RequestMapping(value={"service/uploadDoneNoneJitPlan"})
    @ResponseBody
    public ResponseResult<String> uploadDoneNoneJitPlan(MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        MultipartFile file = (MultipartFile)fileMap.entrySet().iterator().next().getValue();
        List planItems = null;
        try {
            planItems = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, this.createHeader(), SupDeliveryPlanItem.class);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        ImportSupDonePlanItemCmd cmd = new ImportSupDonePlanItemCmd(planItems);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderCommandInvoker.invoke(cmd);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u4e0a\u4f20excel\uff0c\u5bfc\u5165\u56de\u7b7e\u975eJit\u8ba1\u5212\u6570\u636e")
    @RequestMapping(value={"service/uploadToDoNonePlan"})
    @ResponseBody
    public ResponseResult<String> uploadToDoNonePlan(String orderNo, MultipartHttpServletRequest request) throws Exception {
        Map fileMap = request.getFileMap();
        if (MapUtils.isEmpty((Map)fileMap)) {
            throw new CommonException("\u4e0a\u4f20\u6587\u4ef6\u4e3a\u7a7a", "file_isNull");
        }
        if (fileMap.size() > 1) {
            throw new CommonException("\u53ea\u63a5\u53d7\u5355\u4e2a\u6587\u4ef6\u5bfc\u5165");
        }
        MultipartFile file = (MultipartFile)fileMap.entrySet().iterator().next().getValue();
        List planItems = null;
        try {
            planItems = ExcelUtils.importExcelDataToMap((InputStream)file.getInputStream(), (int)0, (int)1, (int)0, this.createHeader(), SupDeliveryPlanItem.class);
        }
        catch (Exception e) {
            throw new CommonException(e.getMessage());
        }
        if (StringUtils.isNotBlank((String)orderNo)) {
            planItems.stream().filter(supPlanItem -> !orderNo.equals(supPlanItem.getPurOrderNo())).findAny().ifPresent(supPlanItem -> {
                String msg = String.format("\u5bfc\u5165\u6570\u636e[%s][%s]\u4e0d\u662f\u5f53\u524d\u8ba2\u5355\u7684", supPlanItem.getPurOrderNo(), supPlanItem.getPurOrderItemNo());
                throw new CommonException(msg);
            });
        }
        ImportSupToDoPlanItemCmd cmd = new ImportSupToDoPlanItemCmd(planItems);
        cmd.setSupCompany(CompanyUtils.currentCompany());
        cmd.setSupUser(SpringSecurityUtils.getLoginUser());
        this.orderCommandInvoker.invoke(cmd);
        return ResponseResult.success();
    }
}

