/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.entity.PurchaseUserOrder;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.product.service.PurchaseUserOrderService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;

public class PurchaseUserOrderAddCmd
extends BaseCommand<String> {
    private PurchaseUserOrder purchaseUserOrder;
    private PurchaseUserOrderService purchaseUserOrderService = (PurchaseUserOrderService)SpringContextHolder.getOneBean(PurchaseUserOrderService.class);
    private PurchaseUserOrderItemService purchaseUserOrderItemService = (PurchaseUserOrderItemService)SpringContextHolder.getOneBean(PurchaseUserOrderItemService.class);
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private PurchaseUserCartService purchaseUserCartService = (PurchaseUserCartService)SpringContextHolder.getOneBean(PurchaseUserCartService.class);

    public PurchaseUserOrderAddCmd(PurchaseUserOrder purchaseUserOrder) {
        this.purchaseUserOrder = purchaseUserOrder;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.purchaseUserOrder);
        this.fill(this.purchaseUserOrder);
        this.process(this.purchaseUserOrder);
        return this.purchaseUserOrder.getId();
    }

    private void process(PurchaseUserOrder purchaseUserOrder) {
        purchaseUserOrder.setId(UUIDGenerator.generateUUID());
        String nextCode = this.generateCodeService.getNextCode("PURCHASE_USER_ORDER");
        purchaseUserOrder.setOrderNo(nextCode);
        this.purchaseUserOrderService.addObj(purchaseUserOrder);
        List<PurchaseUserOrderItem> purchaseUserOrderItemList = purchaseUserOrder.getPurchaseUserOrderItemList();
        for (PurchaseUserOrderItem purchaseUserOrderItem : purchaseUserOrderItemList) {
            purchaseUserOrderItem.setStatus("0");
            purchaseUserOrderItem.setOrderId(purchaseUserOrder.getId());
            purchaseUserOrderItem.setOrderNo(nextCode);
            PurchaseUserCart userCart = new PurchaseUserCart();
            userCart.setId(purchaseUserOrderItem.getId());
            userCart.setIsEnable("0");
            this.purchaseUserCartService.modifyObj(userCart);
            purchaseUserOrderItem.setId(UUIDGenerator.generateUUID());
        }
        this.purchaseUserOrderItemService.addAll(purchaseUserOrderItemList);
    }

    private void fill(PurchaseUserOrder purchaseUserOrder) {
    }

    private void check(PurchaseUserOrder purchaseUserOrder) {
        Assert.isNotNull((Object)purchaseUserOrder, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotEmpty(purchaseUserOrder.getPurchaseUserOrderItemList(), (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
    }
}

