/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.purchase.command.order.pur;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.purchase.entity.PurchaseOrder;
import com.els.base.purchase.entity.PurchaseOrderChange;
import com.els.base.purchase.entity.PurchaseOrderItem;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

public class ViewPurOrderDetailCommand
extends AbstractCommand<PurchaseOrder> {
    private static final long serialVersionUID = 1L;
    private String purOrderId;

    public ViewPurOrderDetailCommand(String purOrderId) {
        this.purOrderId = purOrderId;
    }

    @Override
    public PurchaseOrder execute(ICommandInvoker context) {
        PurchaseOrder purchaseOrder = (PurchaseOrder)ContextUtils.getPurchaseOrderService().queryObjById(this.purOrderId);
        Assert.isNotNull((Object)purchaseOrder, (String)"\u8ba2\u5355\u6570\u636e\u4e0d\u5b58\u5728");
        List<PurchaseOrderItem> itemList = ContextUtils.getPurchaseOrderItemService().queryByOrderIdList(Arrays.asList(this.purOrderId));
        purchaseOrder.setItems(itemList);
        List<PurchaseOrderChange> changeList = ContextUtils.getPurchaseOrderChangeService().queryByOrderId(this.purOrderId);
        purchaseOrder.setChangeList(changeList);
        List<PurDeliveryPlanItem> planItemList = ContextUtils.getPurDeliveryPlanItemService().queryByOrderId(this.purOrderId);
        planItemList = planItemList.stream().filter(plan -> Constant.NO_INT.equals(plan.getIsJit())).collect(Collectors.toList());
        purchaseOrder.setPlanItemList(planItemList);
        return purchaseOrder;
    }
}

