/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.web.controller;

import com.els.base.auth.utils.SpringSecurityUtils;
import com.els.base.company.entity.Department;
import com.els.base.company.service.DepartmentService;
import com.els.base.company.utils.CompanyUtils;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.entity.user.User;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.delivery.entity.DeliveryOrderAddress;
import com.els.base.delivery.entity.DeliveryOrderAddressExample;
import com.els.base.delivery.service.DeliveryOrderAddressService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u91c7\u8d2d\u8ba2\u5355-\u6536\u8d27\u5730\u5740")
@Controller
@RequestMapping(value={"deliveryOrderAddress"})
public class DeliveryOrderAddressController {
    @Resource
    protected DeliveryOrderAddressService deliveryOrderAddressService;
    @Resource
    protected DepartmentService departmentService;

    @ApiOperation(httpMethod="POST", value="\u521b\u5efa\u91c7\u8d2d\u8ba2\u5355-\u6536\u8d27\u5730\u5740")
    @RequestMapping(value={"service/create"})
    @ResponseBody
    public ResponseResult<String> create(@RequestBody DeliveryOrderAddress deliveryOrderAddress) {
        Assert.isNotNull((Object)deliveryOrderAddress, (String)"\u6570\u636e\u4e3a\u7a7a\uff0c\u521b\u5efa\u5931\u8d25");
        this.deliveryOrderAddressService.insertObj(deliveryOrderAddress, SpringSecurityUtils.getLoginUser(), CompanyUtils.currentCompany());
        return ResponseResult.success((Object)deliveryOrderAddress.getId());
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u91c7\u8d2d\u8ba2\u5355-\u6536\u8d27\u5730\u5740")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody DeliveryOrderAddress deliveryOrderAddress) {
        Assert.isNotBlank((String)deliveryOrderAddress.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        this.deliveryOrderAddressService.modifyAddress(deliveryOrderAddress, SpringSecurityUtils.getLoginUser());
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u91c7\u8d2d\u8ba2\u5355-\u6536\u8d27\u5730\u5740")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderAddressExample example = new DeliveryOrderAddressExample();
        example.createCriteria().andIdIn((List)ids);
        this.deliveryOrderAddressService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u91c7\u8d2d\u8ba2\u5355-\u6536\u8d27\u5730\u5740")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 DeliveryOrderAddress", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<DeliveryOrderAddress>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        DeliveryOrderAddressExample example = new DeliveryOrderAddressExample();
        example.setOrderByClause("CREATE_TIME DESC");
        example.setPageView((PageView<DeliveryOrderAddress>)new PageView(pageNo, pageSize));
        DeliveryOrderAddressExample.Criteria criteria = example.createCriteria();
        User loginUser = SpringSecurityUtils.getLoginUser();
        List departList = this.departmentService.queryDepartmentsOfUser(loginUser.getId());
        if (CollectionUtils.isNotEmpty((Collection)departList)) {
            List ids = departList.stream().map(Department::getId).distinct().collect(Collectors.toList());
            criteria.andDepartIdIn(ids);
        }
        criteria.andIsEnbleEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.deliveryOrderAddressService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u90e8\u95e8ID\u67e5\u8be2\u6536\u8d27\u5730\u5740")
    @RequestMapping(value={"service/findByDepartId"})
    @ResponseBody
    public ResponseResult<List<DeliveryOrderAddress>> findByDepartId(@RequestBody(required=false) QueryParamWapper wapper, @RequestParam String departId) {
        Assert.isNotBlank((String)departId, (String)"\u67e5\u8be2\u5931\u8d25\uff0c\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        DeliveryOrderAddressExample example = new DeliveryOrderAddressExample();
        example.createCriteria().andInstitutionsIdEqualTo(departId).andIsEnbleEqualTo(Constant.YES_INT);
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        List addressList = this.deliveryOrderAddressService.queryAllObjByExample((IExample)example);
        return ResponseResult.success((Object)addressList);
    }
}

