/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.entity.PurchaseUserOrder;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.product.service.PurchaseUserOrderService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.List;

public class PurchaseUserOrderAddCmd
extends BaseCommand<String> {
    private PurchaseUserOrder purchaseUserOrder;
    private PurchaseUserOrderService purchaseUserOrderService = (PurchaseUserOrderService)SpringContextHolder.getOneBean(PurchaseUserOrderService.class);
    private PurchaseUserOrderItemService purchaseUserOrderItemService = (PurchaseUserOrderItemService)SpringContextHolder.getOneBean(PurchaseUserOrderItemService.class);
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private PurchaseUserCartService purchaseUserCartService = (PurchaseUserCartService)SpringContextHolder.getOneBean(PurchaseUserCartService.class);
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private PurchaseProductCatalogService purchaseProductCatalogService = (PurchaseProductCatalogService)SpringContextHolder.getOneBean(PurchaseProductCatalogService.class);

    public PurchaseUserOrderAddCmd(PurchaseUserOrder purchaseUserOrder) {
        this.purchaseUserOrder = purchaseUserOrder;
    }

    public String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.purchaseUserOrder);
        this.fill(this.purchaseUserOrder);
        this.process(this.purchaseUserOrder);
        return this.purchaseUserOrder.getId();
    }

    private void process(PurchaseUserOrder purchaseUserOrder) {
        purchaseUserOrder.setId(UUIDGenerator.generateUUID());
        String nextCode = this.generateCodeService.getNextCode("PURCHASE_USER_ORDER");
        purchaseUserOrder.setOrderNo(nextCode);
        this.purchaseUserOrderService.addObj(purchaseUserOrder);
        List<PurchaseUserOrderItem> purchaseUserOrderItemList = purchaseUserOrder.getPurchaseUserOrderItemList();
        for (PurchaseUserOrderItem purchaseUserOrderItem : purchaseUserOrderItemList) {
            purchaseUserOrderItem.setStatus("0");
            purchaseUserOrderItem.setOrderId(purchaseUserOrder.getId());
            purchaseUserOrderItem.setOrderNo(nextCode);
            BigDecimal total = purchaseUserOrderItem.getProductPrice().multiply(purchaseUserOrderItem.getProductCount()).setScale(3, 4);
            purchaseUserOrderItem.setTotalAmount(total);
            Company company = (Company)this.companyService.queryObjById((Object)purchaseUserOrderItem.getSupCompanyId());
            if (company != null) {
                purchaseUserOrderItem.setSupCompanyCode(company.getCompanyCode());
            }
            PurchaseProductCatalogExample catalogExample = new PurchaseProductCatalogExample();
            catalogExample.createCriteria().andProductIdEqualTo(purchaseUserOrderItem.getProductId());
            List productCatalogList = this.purchaseProductCatalogService.queryAllObjByExample((IExample)catalogExample);
            Assert.isNotEmpty((Collection)productCatalogList, (String)("\u8ba2\u5355\u53f7\uff1a" + purchaseUserOrderItem.getOrderNo() + "\u6ca1\u6709\u7ef4\u62a4\u91c7\u8d2d\u76ee\u5f55\u5173\u7cfb"));
            purchaseUserOrderItem.setPurchaseCatalogId(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogId());
            purchaseUserOrderItem.setPurchaseCatalogCode(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogCode());
            purchaseUserOrderItem.setPurchaseCatalogName(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogName());
            purchaseUserOrderItem.setPurchaseCatalogType(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogType());
            purchaseUserOrderItem.setReceivingAddress(purchaseUserOrder.getReceivingAddress());
            purchaseUserOrderItem.setInitiatorId(purchaseUserOrder.getInitiatorId());
            purchaseUserOrderItem.setInitiatorName(purchaseUserOrder.getInitiatorName());
            purchaseUserOrderItem.setInitiatorEmpId(purchaseUserOrder.getInitiatorEmpId());
            purchaseUserOrderItem.setInitiatorBusinessBook(purchaseUserOrder.getInitiatorBusinessBook());
            purchaseUserOrderItem.setInitiatorAccountSetId(purchaseUserOrder.getInitiatorAccountSetId());
            purchaseUserOrderItem.setInitiatorAccountSetName(purchaseUserOrder.getInitiatorAccountSetName());
            purchaseUserOrderItem.setInitiatorCompanyCode(purchaseUserOrder.getInitiatorCompanyCode());
            purchaseUserOrderItem.setInitiatorCompanyName(purchaseUserOrder.getInitiatorCompanyName());
            purchaseUserOrderItem.setInitiatorOrganizationId(purchaseUserOrder.getInitiatorOrganizationId());
            purchaseUserOrderItem.setInitiatorOrganizationName(purchaseUserOrder.getInitiatorOrganizationName());
            purchaseUserOrderItem.setInitiatorDeptCode(purchaseUserOrder.getInitiatorDeptCode());
            purchaseUserOrderItem.setInitiatorDeptName(purchaseUserOrder.getInitiatorDeptName());
            PurchaseUserCart userCart = new PurchaseUserCart();
            userCart.setId(purchaseUserOrderItem.getId());
            userCart.setIsEnable("0");
            this.purchaseUserCartService.modifyObj(userCart);
            purchaseUserOrderItem.setId(UUIDGenerator.generateUUID());
        }
        this.purchaseUserOrderItemService.addAll(purchaseUserOrderItemList);
    }

    private void fill(PurchaseUserOrder purchaseUserOrder) {
    }

    private void check(PurchaseUserOrder purchaseUserOrder) {
        Assert.isNotNull((Object)purchaseUserOrder, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorDeptCode(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorDeptName(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorCompanyCode(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorCompanyName(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorAccountSetId(), (String)"\u53d1\u8d77\u4eba\u8d26\u5957id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorAccountSetName(), (String)"\u53d1\u8d77\u4eba\u8d26\u5957\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorOrganizationId(), (String)"\u53d1\u8d77\u4eba\u4e2d\u652f\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorOrganizationName(), (String)"\u53d1\u8d77\u4eba\u4e2d\u652f\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getReceivingAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotEmpty(purchaseUserOrder.getPurchaseUserOrderItemList(), (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        purchaseUserOrder.getPurchaseUserOrderItemList().stream().forEach(purchaseUserOrderItem -> {
            String supCompanyId = purchaseUserOrder.getPurchaseUserOrderItemList().get(0).getSupCompanyId();
            if (!supCompanyId.equals(purchaseUserOrderItem.getSupCompanyId())) {
                throw new CommonException("\u540c\u4e00\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u7ed3\u7b97");
            }
        });
    }
}

