/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseUserCartMapper;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.entity.PurchaseUserCartExample;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseUserCartService")
public class PurchaseUserCartServiceImpl
implements PurchaseUserCartService {
    @Resource
    protected PurchaseUserCartMapper purchaseUserCartMapper;

    @Override
    @Cacheable(value={"purchaseUserCart"}, keyGenerator="redisKeyGenerator")
    public int countByExample(PurchaseUserCartExample example) {
        return this.purchaseUserCartMapper.countByExample(example);
    }

    @CacheEvict(value={"purchaseUserCart"}, allEntries=true)
    public void addObj(PurchaseUserCart t) {
        this.purchaseUserCartMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseUserCart"}, allEntries=true)
    public void addAll(List<PurchaseUserCart> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseUserCartMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseUserCart"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseUserCartMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseUserCart"}, allEntries=true)
    public void deleteByExample(PurchaseUserCartExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseUserCartMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseUserCart"}, allEntries=true)
    public void modifyObj(PurchaseUserCart t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseUserCartMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseUserCart"}, keyGenerator="redisKeyGenerator")
    public PurchaseUserCart queryObjById(String id) {
        return this.purchaseUserCartMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseUserCart"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseUserCart> queryAllObjByExample(PurchaseUserCartExample example) {
        return this.purchaseUserCartMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseUserCart"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseUserCart> queryObjByPage(PurchaseUserCartExample example) {
        PageView<PurchaseUserCart> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseUserCartMapper.selectByExampleByPage(example));
        return pageView;
    }
}

