/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.catalogue.entity.PurchaseCatalogueHead;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.vo.CatalogProductVO;
import com.els.base.product.vo.ProductCatalogVO;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(tags={"\u4ea7\u54c1-\u91c7\u8d2d\u76ee\u5f55\u5173\u7cfb"})
@Controller
@RequestMapping(value={"purchaseProductCatalog"})
public class PurchaseProductCatalogController {
    @Resource
    protected PurchaseProductCatalogService purchaseProductCatalogService;
    @Resource
    protected PurchaseProductService purchaseProductService;

    @ApiOperation(httpMethod="POST", value="\u7ed9\u91c7\u8d2d\u76ee\u5f55\u6307\u5b9a\u4ea7\u54c1")
    @RequestMapping(value={"service/assign/catalog"})
    @ResponseBody
    public ResponseResult<String> assignCatalog(@RequestBody CatalogProductVO catalogProductVO) {
        Assert.isNotNull((Object)catalogProductVO, (String)"\u6307\u5b9a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!");
        PurchaseCatalogueHead purchaseCatalogueHead = catalogProductVO.getPurchaseCatalogueHead();
        Assert.isNotNull((Object)purchaseCatalogueHead, (String)"\u8bf7\u9009\u62e9\u91c7\u8d2d\u76ee\u5f55\uff01");
        Assert.isNotBlank((String)purchaseCatalogueHead.getId(), (String)"\u91c7\u8d2d\u76ee\u5f55ID\u4e0d\u80fd\u4e3a\u7a7a");
        List<PurchaseProduct> purchaseProducts = catalogProductVO.getPurchaseProducts();
        Assert.isNotEmpty(purchaseProducts, (String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u4ea7\u54c1\uff01");
        ArrayList<PurchaseProductCatalog> list = new ArrayList<PurchaseProductCatalog>();
        for (PurchaseProduct purchaseProduct : purchaseProducts) {
            PurchaseProductCatalog purchaseProductCatalog = new PurchaseProductCatalog();
            purchaseProductCatalog.setPurchaseCatalogId(purchaseCatalogueHead.getId());
            purchaseProductCatalog.setPurchaseCatalogCode(purchaseCatalogueHead.getPurchaseCatalogCode());
            purchaseProductCatalog.setPurchaseCatalogName(purchaseCatalogueHead.getPurchaseCatalogName());
            purchaseProductCatalog.setPurchaseCatalogType(purchaseCatalogueHead.getPurchaseCatalogType());
            purchaseProductCatalog.setProductId(purchaseProduct.getId());
            purchaseProductCatalog.setProductCode(purchaseProduct.getProductCode());
            purchaseProductCatalog.setProductName(purchaseProduct.getProductName());
            list.add(purchaseProductCatalog);
        }
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andPurchaseCatalogIdEqualTo(purchaseCatalogueHead.getId());
        this.purchaseProductCatalogService.deleteByExample((IExample)example);
        this.purchaseProductCatalogService.addAll(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7ed9\u4ea7\u54c1\u6307\u5b9a\u91c7\u8d2d\u76ee\u5f55")
    @RequestMapping(value={"service/assign/product"})
    @ResponseBody
    public ResponseResult<String> assignProduct(@RequestBody ProductCatalogVO productCatalogVO) {
        Assert.isNotNull((Object)productCatalogVO, (String)"\u6307\u5b9a\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5!");
        PurchaseProduct purchaseProduct = productCatalogVO.getPurchaseProduct();
        Assert.isNotNull((Object)purchaseProduct, (String)"\u8bf7\u9009\u62e9\u4ea7\u54c1\uff01");
        Assert.isNotBlank((String)purchaseProduct.getId(), (String)"\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        List<PurchaseCatalogueHead> purchaseCatalogueHeads = productCatalogVO.getPurchaseCatalogueHeads();
        Assert.isNotEmpty(purchaseCatalogueHeads, (String)"\u8bf7\u9009\u62e9\u81f3\u5c11\u4e00\u6761\u91c7\u8d2d\u76ee\u5f55\uff01");
        ArrayList<PurchaseProductCatalog> list = new ArrayList<PurchaseProductCatalog>();
        for (PurchaseCatalogueHead purchaseCatalogueHead : purchaseCatalogueHeads) {
            PurchaseProductCatalog purchaseProductCatalog = new PurchaseProductCatalog();
            purchaseProductCatalog.setProductId(purchaseProduct.getId());
            purchaseProductCatalog.setProductName(purchaseProduct.getProductName());
            purchaseProductCatalog.setProductCode(purchaseProduct.getProductCode());
            purchaseProductCatalog.setPurchaseCatalogType(purchaseCatalogueHead.getPurchaseCatalogType());
            purchaseProductCatalog.setPurchaseCatalogId(purchaseCatalogueHead.getId());
            purchaseProductCatalog.setPurchaseCatalogCode(purchaseCatalogueHead.getPurchaseCatalogCode());
            purchaseProductCatalog.setPurchaseCatalogName(purchaseCatalogueHead.getPurchaseCatalogName());
            list.add(purchaseProductCatalog);
        }
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andProductIdEqualTo(purchaseProduct.getId());
        this.purchaseProductCatalogService.deleteByExample((IExample)example);
        this.purchaseProductCatalogService.addAll(list);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u5220\u9664\u4ea7\u54c1-\u91c7\u8d2d\u76ee\u5f55\u5173\u7cfb")
    @RequestMapping(value={"service/deleteByIds"})
    @ResponseBody
    public ResponseResult<String> deleteByIds(@RequestBody(required=true) List<String> ids) {
        Assert.isNotEmpty(ids, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andIdIn((List)ids);
        this.purchaseProductCatalogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u91c7\u8d2d\u76ee\u5f55id\u5220\u9664\u5173\u7cfb")
    @RequestMapping(value={"service/deleteByCatalogIds"})
    @ResponseBody
    public ResponseResult<String> deleteByCatalogIds(@RequestBody(required=true) List<String> catalogIds) {
        Assert.isNotEmpty(catalogIds, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andPurchaseCatalogIdIn((List)catalogIds);
        this.purchaseProductCatalogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u6839\u636e\u4ea7\u54c1ID\u5220\u9664\u5173\u7cfb")
    @RequestMapping(value={"service/deleteByProductIds"})
    @ResponseBody
    public ResponseResult<String> deleteByProductIds(@RequestBody(required=true) List<String> productIds) {
        Assert.isNotEmpty(productIds, (String)"\u5220\u9664\u5931\u8d25,id\u4e0d\u80fd\u4e3a\u7a7a");
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andProductIdIn((List)productIds);
        this.purchaseProductCatalogService.deleteByExample((IExample)example);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u4ea7\u54c1-\u91c7\u8d2d\u76ee\u5f55\u5173\u7cfb")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProductCatalog", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProductCatalog>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PageView pageData;
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.setPageView((PageView<PurchaseProductCatalog>)new PageView(pageNo, pageSize));
        PurchaseProductCatalogExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        if (CollectionUtils.isNotEmpty((Collection)(pageData = this.purchaseProductCatalogService.queryObjByPage((IExample)example)).getQueryResult())) {
            pageData.getQueryResult().stream().forEach(purchaseProductCatalog -> {
                if (StringUtils.isBlank((String)purchaseProductCatalog.getProductId())) {
                    return;
                }
                PurchaseProduct purchaseProduct = (PurchaseProduct)this.purchaseProductService.queryObjById(purchaseProductCatalog.getProductId());
                purchaseProductCatalog.setProductCode(purchaseProduct.getProductCode());
                purchaseProductCatalog.setProductName(purchaseProduct.getProductName());
                purchaseProductCatalog.setProductImage(purchaseProduct.getProductImage());
                purchaseProductCatalog.setProductDesc(purchaseProduct.getProductDesc());
                purchaseProductCatalog.setProductSummary(purchaseProduct.getProductSummary());
            });
        }
        return ResponseResult.success((Object)pageData);
    }
}

