/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.command;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryPackage;
import com.els.base.delivery.utils.DeliveryOperateEnum;
import com.els.base.delivery.utils.DeliveryOrderItemComparator;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.delivery.utils.DeliveryTypeEnum;
import com.els.base.plan.command.BatchModifyPlanIsCanDeliveryCmd;
import com.els.base.plan.command.ModifyPlanOnWayQuantityCmd;
import com.els.base.purchase.command.order.ModifyOrderItemOnWayQuantityCmd;
import com.els.base.purchase.entity.SupplierOrderItem;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;

public class CreateCommand
extends AbstractCommand<String> {
    private static final long serialVersionUID = 1L;
    private DeliveryOrder deliveryOrder;

    public CreateCommand(DeliveryOrder deliveryOrder) {
        this.deliveryOrder = deliveryOrder;
    }

    @Override
    public String execute(ICommandInvoker context) {
        this.valid(this.deliveryOrder);
        this.init(this.deliveryOrder);
        for (DeliveryOrderItem deliveryOrderItem : this.deliveryOrder.getItems()) {
            context.invoke(new ModifyPlanOnWayQuantityCmd(deliveryOrderItem.getDeliveryPlanItemId(), DeliveryOperateEnum.DELIVERY_ORDER_ADD, deliveryOrderItem.getDeliveryQuantity()));
            context.invoke(new ModifyOrderItemOnWayQuantityCmd(deliveryOrderItem.getPurOrderItemId(), DeliveryOperateEnum.DELIVERY_ORDER_ADD, deliveryOrderItem.getDeliveryQuantity()));
        }
        List<String> planItemIdList = this.deliveryOrder.getItems().stream().map(DeliveryOrderItem::getDeliveryPlanItemId).filter(StringUtils::isNotBlank).distinct().collect(Collectors.toList());
        context.invoke(new BatchModifyPlanIsCanDeliveryCmd(planItemIdList));
        ContextUtils.getDeliveryOrderService().addObj(this.deliveryOrder);
        for (DeliveryOrderItem deliveryOrderItem : this.deliveryOrder.getItems()) {
            deliveryOrderItem.setDeliveryOrderId(this.deliveryOrder.getId());
            deliveryOrderItem.setReceivedQuantity(BigDecimal.ZERO);
            ContextUtils.getDeliveryOrderItemService().addObj(deliveryOrderItem);
        }
        List<DeliveryPackage> list = this.deliveryOrder.getDeliveryPackageLists();
        if (CollectionUtils.isNotEmpty(list)) {
            for (DeliveryPackage packageObj : list) {
                packageObj.setDeliveryOrderId(this.deliveryOrder.getId());
            }
            ContextUtils.getDeliveryPackageService().save(list);
        }
        return this.deliveryOrder.getId();
    }

    private void init(DeliveryOrder deliveryOrder) {
        this.initDeliveryOrder(deliveryOrder);
        this.initPackageList(deliveryOrder);
        Collections.sort(deliveryOrder.getItems(), new DeliveryOrderItemComparator());
        int deliveryOrderItemNo = 1;
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            deliveryOrderItem.setDeliveryOrderItemNo(String.valueOf(deliveryOrderItemNo++));
            this.initDeliveryOrderItem(deliveryOrder, deliveryOrderItem);
        }
    }

    private void initPackageList(DeliveryOrder deliveryOrder) {
        if (CollectionUtils.isEmpty(deliveryOrder.getDeliveryPackageLists())) {
            return;
        }
        List<DeliveryPackage> packageList = deliveryOrder.getDeliveryPackageLists();
        if (CollectionUtils.isNotEmpty(packageList)) {
            packageList = this.initPackageList(deliveryOrder, packageList);
        }
        deliveryOrder.setDeliveryPackageLists(packageList);
    }

    private void initDeliveryOrderItem(DeliveryOrder deliveryOrder, DeliveryOrderItem deliveryOrderItem) {
        deliveryOrderItem.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
        deliveryOrderItem.setType(deliveryOrder.getType());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        deliveryOrderItem.setDeliveryOrderId(deliveryOrder.getId());
        deliveryOrderItem.setCompanyId(deliveryOrder.getCompanyId());
        deliveryOrderItem.setUserId(deliveryOrder.getUserId());
        deliveryOrderItem.setUserName(deliveryOrder.getUserName());
        deliveryOrderItem.setPurUserId(deliveryOrder.getPurUserId());
        deliveryOrderItem.setPurUserName(deliveryOrder.getPurUserName());
        deliveryOrderItem.setReceiptQuantity("0");
        deliveryOrderItem.setCreateTime(new Date());
    }

    private List<DeliveryPackage> initPackageList(DeliveryOrder deliveryOrder, List<DeliveryPackage> deliveryPackageList) {
        if (CollectionUtils.isEmpty(deliveryPackageList)) {
            return null;
        }
        deliveryPackageList = deliveryPackageList.stream().filter(deliveryPackage -> deliveryPackage.getPackageQuantity() != null && deliveryPackage.getPackageQuantity() > 0 && deliveryPackage.getTotalQuantity() != null && deliveryPackage.getTotalQuantity() > 0).collect(Collectors.toList());
        deliveryPackageList.stream().forEach(deliveryPackage -> {
            deliveryPackage.setUserId(deliveryOrder.getUserId());
            deliveryPackage.setUserName(deliveryOrder.getUserName());
            deliveryPackage.setCompanyId(deliveryOrder.getCompanyId());
            deliveryPackage.setCompanyCode(deliveryOrder.getCompanyCode());
            deliveryPackage.setCompanyName(deliveryOrder.getCompanyName());
            deliveryPackage.setDeliveryOrderId(deliveryOrder.getId());
            deliveryPackage.setDeliveryOrderNo(deliveryOrder.getDeliveryOrderNo());
        });
        deliveryPackageList.stream().filter(deliveryPackage -> Constant.YES_INT.equals(deliveryPackage.getIsMerger())).forEach(deliveryPackage -> {
            deliveryPackage.setGrossWeight(BigDecimal.ZERO);
            deliveryPackage.setHeight(BigDecimal.ZERO);
            deliveryPackage.setWidth(BigDecimal.ZERO);
            deliveryPackage.setLength(BigDecimal.ZERO);
            deliveryPackage.setVolume("0");
        });
        BigDecimal totalGrossWeight = deliveryPackageList.stream().filter(deliveryPackage -> deliveryPackage.getGrossWeight() != null && deliveryPackage.getGrossWeight().compareTo(BigDecimal.ZERO) > 0).map(deliveryPackage -> {
            BigDecimal packageQuantity = new BigDecimal(deliveryPackage.getPackageQuantity());
            BigDecimal pgGrossWeight = deliveryPackage.getGrossWeight();
            return packageQuantity.multiply(pgGrossWeight);
        }).reduce(BigDecimal::add).orElseGet(() -> null);
        return deliveryPackageList;
    }

    private void initDeliveryOrder(DeliveryOrder deliveryOrder) {
        String purOrderNoStr;
        deliveryOrder.setIsEnable(Constant.YES_INT);
        deliveryOrder.setLastUpdateTime(new Date());
        if (deliveryOrder.getCreateTime() != null) {
            deliveryOrder.setCreateTime(new Date());
        }
        if (deliveryOrder.getDeliveryStatus() == null) {
            deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.UN_SENT.getValue());
        }
        if (StringUtils.isBlank((String)deliveryOrder.getType())) {
            deliveryOrder.setType(DeliveryTypeEnum.DELIVERY.getValue());
        }
        if (this.getSupCompany() != null) {
            if (deliveryOrder.getCompanyId() == null) {
                deliveryOrder.setCompanyId(this.getSupCompany().getId());
            }
            if (deliveryOrder.getCompanyName() == null) {
                deliveryOrder.setCompanyName(this.getSupCompany().getCompanyFullName());
            }
        }
        if (this.getPurCompany() != null) {
            if (deliveryOrder.getPurCompanyId() == null) {
                deliveryOrder.setPurCompanyId(this.getPurCompany().getId());
            }
            if (deliveryOrder.getPurCompanyName() == null) {
                deliveryOrder.setPurCompanyName(this.getPurCompany().getCompanyFullName());
            }
            if (deliveryOrder.getPurCompanyCode() == null) {
                deliveryOrder.setPurCompanyCode(this.getPurCompany().getCompanyCode());
            }
        }
        if (this.getSupUser() != null) {
            if (deliveryOrder.getUserId() == null) {
                deliveryOrder.setUserId(this.getSupUser().getId());
            }
            if (deliveryOrder.getUserName() == null) {
                deliveryOrder.setUserName(this.getSupUser().getLoginName());
            }
            deliveryOrder.setLastUpdateUser(this.getSupUser().getId());
        }
        if (this.getPurUser() != null) {
            if (deliveryOrder.getPurUserId() == null) {
                deliveryOrder.setPurUserId(this.getPurUser().getId());
            }
            if (deliveryOrder.getPurUserName() == null) {
                deliveryOrder.setPurUserName(this.getPurUser().getNickName());
            }
            deliveryOrder.setLastUpdateUser(this.getSupUser().getId());
        }
        if (StringUtils.isNotBlank((String)(purOrderNoStr = deliveryOrder.getItems().stream().map(DeliveryOrderItem::getPurOrderNo).distinct().collect(Collectors.joining(",")))) && purOrderNoStr.getBytes().length > 1000) {
            throw new CommonException("\u9001\u8d27\u5355\u66f4\u65b0\u5931\u8d25\uff0c\u8be5\u5355\u5173\u8054\u8fc7\u591a\u7684\u91c7\u8d2d\u8ba2\u5355\u53f7\uff0c\u6700\u591a100\u4e2a\u4e0d\u540c\u7684\u7684\u91c7\u8d2d\u8ba2\u5355");
        }
        deliveryOrder.setPurchaseOrderNo(purOrderNoStr);
    }

    private void valid(DeliveryOrder deliveryOrder) {
        Assert.isNotNull((Object)deliveryOrder, (String)"\u53d1\u8d27\u5355\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(deliveryOrder.getItems(), (String)"\u884c\u6570\u636e\u4e0d\u5b58\u5728");
        Assert.isNotBlank((String)deliveryOrder.getCompanyCode(), (String)"\u9001\u8d27\u5355\u4e2d\u7684\u4f9b\u5e94\u5546\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
        if (deliveryOrder.getInvoiceNo() != null && deliveryOrder.getInvoiceNo().length() > 255 || deliveryOrder.getDriverName() != null && deliveryOrder.getDriverName().length() > 255 || deliveryOrder.getIdCard() != null && deliveryOrder.getIdCard().length() > 255 || deliveryOrder.getCar() != null && deliveryOrder.getCar().length() > 255) {
            throw new CommonException("\u9001\u8d27\u5355\u5934\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
        }
        DeliveryOrderExample example = new DeliveryOrderExample();
        example.createCriteria().andDeliveryOrderNoEqualTo(deliveryOrder.getDeliveryOrderNo());
        List deliveryOrders = ContextUtils.getDeliveryOrderService().queryAllObjByExample((IExample)example);
        if (CollectionUtils.isNotEmpty((Collection)deliveryOrders)) {
            throw new CommonException(String.format("\u7cfb\u7edf\u5df2\u751f\u6210\u9001\u8d27\u5355[%s]\uff0c\u8bf7\u53d6\u6d88\u91cd\u65b0\u5efa\u5355", deliveryOrder.getDeliveryOrderNo()));
        }
        for (DeliveryOrderItem deliveryOrderItem : deliveryOrder.getItems()) {
            Assert.isNotBlank((String)deliveryOrderItem.getPurOrderItemId(), (String)"\u53c2\u6570\u5f02\u5e38\uff0c\u9001\u8d27\u5355\u884c\u4e2d\uff0c\u7f3a\u5c11\u91c7\u8d2d\u8ba2\u5355\u884cid");
            if (deliveryOrderItem.getDeliveryQuantity() == null || deliveryOrderItem.getDeliveryQuantity().compareTo(BigDecimal.ZERO) <= 0) {
                throw new CommonException("\u9001\u8d27\u6570\u91cf\u4e0d\u80fd\u4e3a\u7a7a");
            }
            if (deliveryOrderItem.getChineseName() != null && deliveryOrderItem.getChineseName().length() > 255 || deliveryOrderItem.getRemark() != null && deliveryOrderItem.getRemark().length() > 255 || deliveryOrderItem.getBrand() != null && deliveryOrderItem.getBrand().length() > 255 || deliveryOrderItem.getSourceArea() != null && deliveryOrderItem.getSourceArea().length() > 255 || deliveryOrderItem.getModel() != null && deliveryOrderItem.getModel().length() > 255 || deliveryOrderItem.getCaseNo() != null && deliveryOrderItem.getCaseNo().length() > 30) {
                throw new CommonException("\u9001\u8d27\u5355\u884c\u53c2\u6570\u957f\u5ea6\u8d85\u6807", "database_length_error");
            }
            if (deliveryOrderItem.getDeliveryQuantity().compareTo(deliveryOrderItem.getCanDeliveryQuantity()) <= 0) continue;
            String errMsg = String.format("\u53d1\u8d27\u6570\u91cf\u8d85\u53d1\u4e86\uff0c\u8bf7\u4fee\u6539\u53d1\u8d27\u6570\u91cf\u3002\u7269\u6599[%s],\u53d1\u8d27\u6570\u91cf[%s],\u6700\u5927\u53ef\u53d1\u6570\u91cf[%s]", deliveryOrderItem.getMaterialNo(), deliveryOrderItem.getDeliveryQuantity().toString(), deliveryOrderItem.getCanDeliveryQuantity().toString());
            throw new CommonException(errMsg);
        }
        Map<String, List<DeliveryOrderItem>> orderItemIdMap = deliveryOrder.getItems().stream().collect(Collectors.groupingBy(DeliveryOrderItem::getPurOrderItemId));
        orderItemIdMap.forEach((orderItemId, deliveryOrderItemList) -> {
            SupplierOrderItem orderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(orderItemId);
            Assert.isNotNull((Object)orderItem, (String)"\u5173\u8054\u7684\u8ba2\u5355\u884c\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u5220\u9664\u53d1\u8d27\u5355\u91cd\u65b0\u5efa\u5355");
            BigDecimal orderItemCanDeliveryQuantity = orderItem.getCanDeliveryQuantity();
            BigDecimal sumDeliveryQuantity = deliveryOrderItemList.stream().map(DeliveryOrderItem::getDeliveryQuantity).reduce(BigDecimal::add).orElse(BigDecimal.ZERO);
            if (sumDeliveryQuantity.compareTo(orderItemCanDeliveryQuantity) > 0) {
                String errMsg = String.format("\u53d1\u8d27\u603b\u6570\u91cf\u8d85\u8ba2\u5355\u6570\u91cf\uff0c\u8bf7\u4fee\u6539\u53d1\u8d27\u6570\u91cf\u3002\u7269\u6599[%s],\u53d1\u8d27\u6570\u91cf[%s],\u6700\u5927\u53ef\u53d1\u6570\u91cf[%s]", orderItem.getMaterialCode(), sumDeliveryQuantity.toString(), orderItemCanDeliveryQuantity.toString());
                throw new CommonException(errMsg);
            }
        });
    }
}

