/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.common.ContextUtils;
import com.els.base.company.entity.Company;
import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.DeliveryOrderItemMapper;
import com.els.base.delivery.entity.DeliveryOrder;
import com.els.base.delivery.entity.DeliveryOrderExample;
import com.els.base.delivery.entity.DeliveryOrderItem;
import com.els.base.delivery.entity.DeliveryOrderItemExample;
import com.els.base.delivery.service.DeliveryOrderItemService;
import com.els.base.delivery.service.DeliveryOrderService;
import com.els.base.delivery.utils.DeliveryStatusEnum;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.materialstore.entity.MaterialStore;
import com.els.base.materialstore.enums.MaterialStoreBusinessTypeEnum;
import com.els.base.materialstore.service.MaterialStoreService;
import com.els.base.materialstoresetting.entity.MaterialStoreSetting;
import com.els.base.materialstoresetting.service.MaterialStoreSettingService;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.utils.DeliveryPlanUesdStatusEnum;
import com.els.base.purchase.entity.PurchaseOrderItem;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.jd.service.JdApiService;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="deliveryOrderItemService")
public class DeliveryOrderItemServiceImpl
implements DeliveryOrderItemService {
    @Resource
    protected DeliveryOrderItemMapper deliveryOrderItemMapper;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected MaterialStoreService materialStoreService;
    @Resource
    protected MaterialStoreSettingService materialStoreSettingService;
    @Resource
    protected JdApiService jdApiService;
    @Resource
    protected DeliveryOrderService deliveryOrderService;

    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void addObj(DeliveryOrderItem t) {
        this.deliveryOrderItemMapper.insertSelective(t);
    }

    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void deleteObjById(String id) {
        this.deliveryOrderItemMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void modifyObj(DeliveryOrderItem t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e0d\u80fd\u4e3a\u7a7a", (String)"id_is_blank");
        this.deliveryOrderItemMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public DeliveryOrderItem queryObjById(String id) {
        return this.deliveryOrderItemMapper.selectByPrimaryKey(id);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderItem> queryByDeliveryOrderId(String deliveryOrderId) {
        DeliveryOrderItemExample itemExample = new DeliveryOrderItemExample();
        itemExample.createCriteria().andDeliveryOrderIdEqualTo(deliveryOrderId);
        itemExample.setOrderByClause("DELIVERY_ORDER_ITEM_NO ASC,MATERIAL_NO ASC ,DELIVERY_DATE DESC");
        return this.deliveryOrderItemMapper.selectByExample(itemExample);
    }

    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public List<DeliveryOrderItem> queryAllObjByExample(DeliveryOrderItemExample example) {
        return this.deliveryOrderItemMapper.selectByExample(example);
    }

    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderItem> queryObjByPage(DeliveryOrderItemExample example) {
        PageView<DeliveryOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderItemMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public PageView<DeliveryOrderItem> queryHisObjByPage(DeliveryOrderItemExample example) {
        PageView<DeliveryOrderItem> pageView = example.getPageView();
        pageView.setQueryResult(this.deliveryOrderItemMapper.selectHisByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void updateDeliveryOrderItem(DeliveryOrderItem record, DeliveryOrderItemExample example) {
        this.deliveryOrderItemMapper.updateByExampleSelective(record, example);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void deleteByExample(DeliveryOrderItemExample example) {
        if (example == null || CollectionUtils.isEmpty(example.getOredCriteria())) {
            return;
        }
        this.deliveryOrderItemMapper.deleteByExample(example);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void insertHis(String hisItemId, String id, String cause, Date operateTime) {
        this.deliveryOrderItemMapper.insertHis(hisItemId, id, cause, operateTime);
    }

    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    public void addAll(List<DeliveryOrderItem> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.forEach(record -> record.setId(UUIDGenerator.generateUUID()));
        this.deliveryOrderItemMapper.insertBatch(list);
    }

    @Override
    @CacheEvict(value={"deliveryOrderItem"}, allEntries=true)
    @Transactional
    public void receiving(DeliveryOrderItem item, Company purCompany, User loginUser) {
        if (!DeliveryStatusEnum.ONWAY.getValue().equals(item.getDeliveryStatus())) {
            throw new CommonException("\u53ea\u6709\u5728\u9014\u72b6\u6001\u624d\u80fd\u8fdb\u884c\u6536\u8d27\u64cd\u4f5c\uff01");
        }
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) < 0) {
            throw new CommonException("\u6536\u8d27\u6570\u91cf\u4e0d\u80fd\u5927\u4e8e\u9001\u8d27\u6570\u91cf");
        }
        DeliveryOrderExample orderExample = new DeliveryOrderExample();
        orderExample.createCriteria().andDeliveryOrderNoEqualTo(item.getDeliveryOrderNo());
        List deliveryOrders = this.deliveryOrderService.queryAllObjByExample((IExample)orderExample);
        if ("2".equals(((DeliveryOrder)deliveryOrders.get(0)).getDataSource())) {
            Assert.isNotBlank((String)((DeliveryOrder)deliveryOrders.get(0)).getShopOrderNo(), (String)"\u4eac\u4e1c\u8ba2\u5355\u53f7\u4e0d\u80fd\u4e3a\u7a7a");
            this.jdApiService.jdConfirmReceived(((DeliveryOrder)deliveryOrders.get(0)).getShopOrderNo());
        }
        this.modifyDeliveryOrderItem(item, purCompany, loginUser);
        this.modifyPlanItem(item, purCompany, loginUser);
        this.modifyPurOrderExt(item, purCompany, loginUser);
        this.writeInStock(item, purCompany, loginUser);
    }

    private void writeInStock(DeliveryOrderItem item, Company purCompany, User loginUser) {
        Material material = this.materialService.queryObjByCode(item.getMaterialNo());
        Assert.isNotNull((Object)material, (String)"\u5199\u5165\u5e93\u5b58\u65f6\uff0c\u6839\u636e\u7269\u6599\u7f16\u7801\u67e5\u8be2\u7269\u6599\u4fe1\u606f\u4e3a\u7a7a");
        if (Constant.YES_INT.equals(material.getInventoryFlag())) {
            MaterialStoreSetting materialStoreSetting = (MaterialStoreSetting)this.materialStoreSettingService.queryObjById((Object)item.getWarehouseCode());
            Assert.isNotNull((Object)materialStoreSetting, (String)"\u4ed3\u5e93\u5730\u70b9\u4e0d\u5b58\u5728");
            MaterialStore materialStore = new MaterialStore();
            materialStore.setMaterialCode(item.getMaterialNo());
            materialStore.setStoreId(item.getWarehouseCode());
            materialStore.setStoreNumber(Integer.valueOf(item.getReceivedQuantity().intValue()));
            materialStore.setCompanyId(purCompany.getId());
            materialStore.setCompanyName(purCompany.getCompanyFullName());
            materialStore.setDescription(item.getMaterialDesc());
            materialStore.setCurrency(item.getCurrency());
            materialStore.setPrice(item.getTaxPrice());
            materialStore.setCreateTime(new Date());
            materialStore.setCreateUserId(loginUser.getId());
            materialStore.setCreateUserName(loginUser.getNickName());
            materialStore.setPriceUnit(item.getPriceUnit());
            materialStore.setBrandName(item.getBrand());
            materialStore.setStoreName(item.getWarehouseName());
            materialStore.setDepartmentId(materialStoreSetting.getDepartmentId());
            materialStore.setDepartmentName(materialStoreSetting.getDepartmentName());
            this.materialStoreService.callInStore(materialStore, MaterialStoreBusinessTypeEnum.DELIVERY.getValue(), item.getId());
        }
    }

    private void modifyPurOrderExt(DeliveryOrderItem item, Company purCompany, User loginUser) {
        Assert.isNotBlank((String)item.getPurOrderItemId(), (String)"\u5173\u8054\u7684\u91c7\u8d2d\u8ba2\u5355\u884cID\u4e3a\u7a7a");
        ContextUtils.getPurOrderItemExtService().addReceivedQuantity(item.getPurOrderItemId(), item.getReceivedQuantity());
        ContextUtils.getPurOrderItemExtService().addOnwayQuantity(item.getPurOrderItemId(), item.getDeliveryQuantity().multiply(new BigDecimal(-1)));
        BigDecimal subtract = item.getDeliveryQuantity().subtract(item.getReceivedQuantity());
        ContextUtils.getPurOrderItemExtService().addDeliveredQuantity(item.getPurOrderItemId(), subtract.multiply(new BigDecimal(-1)));
        PurchaseOrderItem purchaseOrderItem = (PurchaseOrderItem)ContextUtils.getPurchaseOrderItemService().queryObjById(item.getPurOrderItemId());
        SupplierOrderItem supplierOrderItem = (SupplierOrderItem)ContextUtils.getSupplierOrderItemService().queryObjById(item.getPurOrderItemId());
        PurchaseOrderItem purOrderItem = new PurchaseOrderItem();
        SupplierOrderItem supOrderItem = new SupplierOrderItem();
        purOrderItem.setId(purchaseOrderItem.getId());
        supOrderItem.setId(supplierOrderItem.getId());
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) > 0 && !Constant.YES_INT.equals(purchaseOrderItem.getIsCanDelivery())) {
            purOrderItem.setIsCanDelivery(Constant.YES_INT);
            supOrderItem.setIsCanDelivery(Constant.YES_INT);
        }
        ContextUtils.getPurchaseOrderItemService().modifyObj(purOrderItem);
        ContextUtils.getSupplierOrderItemService().modifyObj(supOrderItem);
    }

    private void modifyDeliveryOrderItem(DeliveryOrderItem item, Company purCompany, User loginUser) {
        DeliveryOrderItem deliveryOrderItem = new DeliveryOrderItem();
        deliveryOrderItem.setId(item.getId());
        deliveryOrderItem.setReceivedQuantity(item.getReceivedQuantity());
        deliveryOrderItem.setReceivedDate(item.getReceivedDate());
        deliveryOrderItem.setReceivedRemark(item.getReceivedRemark());
        deliveryOrderItem.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        this.deliveryOrderItemMapper.updateByPrimaryKeySelective(deliveryOrderItem);
        DeliveryOrderItemExample example = new DeliveryOrderItemExample();
        example.createCriteria().andDeliveryOrderIdEqualTo(item.getDeliveryOrderId()).andDeliveryStatusEqualTo(DeliveryStatusEnum.ONWAY.getValue()).andIsEnableEqualTo(Constant.YES_INT);
        int count = this.deliveryOrderItemMapper.countByExample(example);
        DeliveryOrder deliveryOrder = new DeliveryOrder();
        deliveryOrder.setId(item.getDeliveryOrderId());
        deliveryOrder.setLastUpdateTime(new Date());
        deliveryOrder.setLastUpdateUser(loginUser.getNickName());
        if (count > 0) {
            deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.PART_RECEIVED.getValue());
        } else {
            deliveryOrder.setDeliveryStatus(DeliveryStatusEnum.ALL_RECEIVED.getValue());
        }
        ContextUtils.getDeliveryOrderService().modifyObj(deliveryOrder);
    }

    private void modifyPlanItem(DeliveryOrderItem item, Company purCompany, User loginUser) {
        Assert.isNotBlank((String)item.getDeliveryPlanItemId(), (String)"\u5173\u8054\u7684\u8ba1\u5212\u884cID\u4e3a\u7a7a");
        SupDeliveryPlanItem supDeliveryPlanItem = (SupDeliveryPlanItem)ContextUtils.getSupDeliveryPlanItemService().queryObjById(item.getDeliveryPlanItemId());
        SupDeliveryPlanItem supPlanItem = new SupDeliveryPlanItem();
        supPlanItem.setId(item.getDeliveryPlanItemId());
        supPlanItem.setOnwayQuantity(supDeliveryPlanItem.getOnwayQuantity().subtract(item.getDeliveryQuantity()));
        BigDecimal receivedQuantity = supDeliveryPlanItem.getReceivedQuantity();
        if (receivedQuantity == null) {
            receivedQuantity = BigDecimal.ZERO;
        }
        supPlanItem.setReceivedQuantity(receivedQuantity.add(item.getReceivedQuantity()));
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) > 0 && !Constant.YES_INT.equals(supDeliveryPlanItem.getIsCanDelivery())) {
            supPlanItem.setIsCanDelivery(Constant.YES_INT);
        }
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) > 0 && DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(supDeliveryPlanItem.getUsedStatus())) {
            supPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.PART_USED.getValue());
        }
        ContextUtils.getSupDeliveryPlanItemService().modifyObj(supPlanItem);
        PurDeliveryPlanItem purDeliveryPlanItem = (PurDeliveryPlanItem)ContextUtils.getPurDeliveryPlanItemService().queryObjById(item.getDeliveryPlanItemId());
        PurDeliveryPlanItem purPlanItem = new PurDeliveryPlanItem();
        purPlanItem.setId(item.getDeliveryPlanItemId());
        purPlanItem.setOnwayQuantity(purDeliveryPlanItem.getOnwayQuantity().subtract(item.getDeliveryQuantity()));
        BigDecimal purReceivedQuantity = purDeliveryPlanItem.getReceivedQuantity();
        if (purReceivedQuantity == null) {
            purReceivedQuantity = BigDecimal.ZERO;
        }
        purPlanItem.setReceivedQuantity(purReceivedQuantity);
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) > 0 && !Constant.YES_INT.equals(purDeliveryPlanItem.getIsCanDelivery())) {
            purPlanItem.setIsCanDelivery(Constant.YES_INT);
        }
        if (item.getDeliveryQuantity().compareTo(item.getReceivedQuantity()) > 0 && DeliveryPlanUesdStatusEnum.ALL_USED.getValue().equals(purDeliveryPlanItem.getUsedStatus())) {
            purPlanItem.setUsedStatus(DeliveryPlanUesdStatusEnum.PART_USED.getValue());
        }
        ContextUtils.getPurDeliveryPlanItemService().modifyObj(purPlanItem);
    }

    @Override
    @Cacheable(value={"deliveryOrderItem"}, keyGenerator="redisKeyGenerator")
    public int countByExample(DeliveryOrderItemExample example) {
        Assert.isNotNull((Object)example, (String)"\u67e5\u8be2\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        return this.deliveryOrderItemMapper.countByExample(example);
    }
}

