/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.delivery.service.impl;

import com.els.base.company.entity.Company;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.delivery.dao.TicketCollectorMapper;
import com.els.base.delivery.entity.TicketCollector;
import com.els.base.delivery.entity.TicketCollectorExample;
import com.els.base.delivery.service.TicketCollectorService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultTicketCollectorService")
public class TicketCollectorServiceImpl
implements TicketCollectorService {
    @Resource
    protected TicketCollectorMapper ticketCollectorMapper;

    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void addObj(TicketCollector t) {
        this.ticketCollectorMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void addAll(List<TicketCollector> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.ticketCollectorMapper.insertBatch(list);
    }

    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void deleteObjById(String id) {
        this.ticketCollectorMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void deleteByExample(TicketCollectorExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.ticketCollectorMapper.deleteByExample(example);
    }

    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void modifyObj(TicketCollector t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.ticketCollectorMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"ticketCollector"}, keyGenerator="redisKeyGenerator")
    public TicketCollector queryObjById(String id) {
        return this.ticketCollectorMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"ticketCollector"}, keyGenerator="redisKeyGenerator")
    public List<TicketCollector> queryAllObjByExample(TicketCollectorExample example) {
        return this.ticketCollectorMapper.selectByExample(example);
    }

    @Cacheable(value={"ticketCollector"}, keyGenerator="redisKeyGenerator")
    public PageView<TicketCollector> queryObjByPage(TicketCollectorExample example) {
        PageView<TicketCollector> pageView = example.getPageView();
        pageView.setQueryResult(this.ticketCollectorMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void insertObj(TicketCollector ticketCollector, Company purCompany, User loginUser) {
        this.checkData(ticketCollector);
        TicketCollectorExample example = new TicketCollectorExample();
        example.createCriteria().andAddressTypeEqualTo(ticketCollector.getAddressType()).andInstitutionsIdEqualTo(ticketCollector.getInstitutionsId());
        if (this.ticketCollectorMapper.countByExample(example) > 0) {
            throw new CommonException("\u540c\u4e00\u6536\u7968\u7c7b\u578b\u3001\u540c\u4e00\u673a\u6784\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4");
        }
        ticketCollector.setPurCompanyCode(purCompany.getCompanyCode());
        ticketCollector.setPurCompanyName(purCompany.getCompanyFullName());
        ticketCollector.setCreater(loginUser.getNickName());
        ticketCollector.setCreaterId(loginUser.getId());
        ticketCollector.setCreateTime(new Date());
        ticketCollector.setIsEnble(Constant.YES_INT);
        this.ticketCollectorMapper.insertSelective(ticketCollector);
    }

    private void checkData(TicketCollector ticketCollector) {
        Assert.isNotBlank((String)ticketCollector.getAddressType(), (String)"\u6536\u7968\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getDepartId(), (String)"\u90e8\u95e8ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getInstitutionsId(), (String)"\u673a\u6784ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getAccountSetId(), (String)"\u8d26\u5957ID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getConsignee(), (String)"\u53d1\u7968\u6536\u53d6\u4eba\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getConsigneeId(), (String)"\u53d1\u7968\u6536\u53d6\u4ebaID\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getPurchasePhone(), (String)"\u8054\u7cfb\u7535\u8bdd\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)ticketCollector.getAddress(), (String)"\u6536\u7968\u4eba\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a");
    }

    @Override
    @CacheEvict(value={"ticketCollector"}, allEntries=true)
    public void updateObj(TicketCollector ticketCollector, User loginUser) {
        this.checkData(ticketCollector);
        TicketCollector oldData = this.ticketCollectorMapper.selectByPrimaryKey(ticketCollector.getId());
        if (!oldData.getInstitutionsId().equals(ticketCollector.getInstitutionsId())) {
            TicketCollectorExample example = new TicketCollectorExample();
            example.createCriteria().andAddressTypeEqualTo(ticketCollector.getAddressType()).andInstitutionsIdEqualTo(ticketCollector.getInstitutionsId());
            if (this.ticketCollectorMapper.countByExample(example) > 0) {
                throw new CommonException("\u540c\u4e00\u6536\u7968\u7c7b\u578b\u3001\u540c\u4e00\u673a\u6784\u4e0d\u80fd\u91cd\u590d\u7ef4\u62a4");
            }
        }
        ticketCollector.setUpdataUser(loginUser.getNickName());
        ticketCollector.setUpdateTime(new Date());
        this.ticketCollectorMapper.updateByPrimaryKeySelective(ticketCollector);
    }
}

