/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.plan.command.nonejit.sup;

import com.els.base.common.AbstractCommand;
import com.els.base.common.ContextUtils;
import com.els.base.common.ICommandInvoker;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.plan.entity.PurDeliveryPlanItem;
import com.els.base.plan.entity.PurDeliveryPlanItemExample;
import com.els.base.plan.entity.SupDeliveryPlanItem;
import com.els.base.plan.entity.SupDeliveryPlanItemExample;
import com.els.base.plan.utils.DeliveryPlanUtils;
import com.els.base.plan.utils.OperateTypeEnum;
import com.els.base.plan.utils.PlanChangeStatusEnum;
import com.els.base.purchase.entity.SupplierOrderItem;
import com.els.base.purchase.utils.PurchaseOrderConfirmStatusEnum;
import java.math.BigDecimal;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;

public class NoneJitPlanSupRefuseCmd
extends AbstractCommand<List<SupDeliveryPlanItem>> {
    private static final long serialVersionUID = 1L;
    private OperateTypeEnum operateType;
    private List<SupDeliveryPlanItem> supPlanList;
    private SupplierOrderItem supplierOrderItem;

    public NoneJitPlanSupRefuseCmd(List<SupDeliveryPlanItem> supPlanList) {
        this.supPlanList = supPlanList;
        this.operateType = OperateTypeEnum.OPERATE_FROM_PLAN_LIST;
    }

    @Override
    public List<SupDeliveryPlanItem> execute(ICommandInvoker context) {
        switch (this.operateType) {
            case OPERATE_FROM_ORDER: {
                return this.refuseFromOrder(this.supplierOrderItem, this.supPlanList);
            }
            case OPERATE_FROM_PLAN_LIST: {
                return this.refuseFromPlanList(this.supPlanList);
            }
        }
        return null;
    }

    private List<SupDeliveryPlanItem> refuseFromPlanList(List<SupDeliveryPlanItem> supPlanList) {
        Assert.isNotEmpty(supPlanList, (String)"\u62d2\u7edd\u7684\u4f9b\u5e94\u5546\u8ba1\u5212\u884c\u4e0d\u80fd\u4e3a\u7a7a");
        for (SupDeliveryPlanItem planItem : supPlanList) {
            planItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            planItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            planItem.setConfirmTime(null);
        }
        return supPlanList;
    }

    private List<SupDeliveryPlanItem> refuseFromOrder(SupplierOrderItem supplierOrderItem, List<SupDeliveryPlanItem> supPlanList) {
        this.valid(supplierOrderItem, supPlanList);
        BigDecimal sumQuantity = supPlanList.stream().map(SupDeliveryPlanItem::getDeliveryQuantity).reduce(BigDecimal.ZERO, BigDecimal::add);
        if (supplierOrderItem.getCanDeliveryQuantity().compareTo(sumQuantity) > 0) {
            BigDecimal q = supplierOrderItem.getCanDeliveryQuantity().subtract(sumQuantity);
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf\u5f02\u5e38\uff0c\u5c11\u4e8e\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u76f8\u5dee[%s]", supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo(), q.toString()));
        }
        if (supplierOrderItem.getCanDeliveryQuantity().compareTo(sumQuantity) < 0) {
            BigDecimal q = sumQuantity.subtract(supplierOrderItem.getCanDeliveryQuantity());
            throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \u7684\u53d1\u8d27\u6570\u91cf\u5f02\u5e38\uff0c\u5927\u4e8e\u8ba2\u5355\u7684\u53ef\u53d1\u8d27\u6570\u91cf,\u76f8\u5dee[%s]", supplierOrderItem.getOrderNo(), supplierOrderItem.getOrderItemNo(), q.toString()));
        }
        List<PurDeliveryPlanItem> purPlanList = ContextUtils.getPurDeliveryPlanItemService().queryByOrderItemId(supplierOrderItem.getId());
        if (DeliveryPlanUtils.isEqualBewteenPurAndSup(purPlanList, supPlanList)) {
            throw new CommonException(String.format("\u5982\u679c\u62d2\u7edd\u4e86\u8ba2\u5355\u884c[%s]\u7684\u4ea4\u671f\uff0c\u8bf7\u63d0\u4ea4\u65b0\u7684\u4ea4\u671f\u5b89\u6392", supplierOrderItem.getOrderItemNo()));
        }
        List planItemIdList = supPlanList.stream().map(SupDeliveryPlanItem::getId).filter(xva$0 -> StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{xva$0})).collect(Collectors.toList());
        SupDeliveryPlanItemExample supPlanItemExample = new SupDeliveryPlanItemExample();
        supPlanItemExample.createCriteria().andIdIn(planItemIdList);
        ContextUtils.getSupDeliveryPlanItemService().deleteByExample(supPlanItemExample);
        supPlanList.stream().filter(planItem -> PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus())).forEach(planItem -> {
            planItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            planItem.setPurConfirmStatus(PurchaseOrderConfirmStatusEnum.UNCONFIRM.getValue());
            planItem.setPurPlanerId(supplierOrderItem.getPurPlanerId());
            planItem.setSupUserId(this.getSupUser().getId());
            planItem.setSupUserName(this.getSupUser().getNickName());
            planItem.setId(null);
            planItem.setConfirmTime(null);
        });
        supPlanList.stream().filter(planItem -> PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(planItem.getChangeStatus())).forEach(planItem -> {
            planItem.setSupConfirmStatus(PurchaseOrderConfirmStatusEnum.CONFIRM.getValue());
            planItem.setPurPlanerId(supplierOrderItem.getPurPlanerId());
            planItem.setSupUserId(this.getSupUser().getId());
            planItem.setSupUserName(this.getSupUser().getNickName());
            planItem.setConfirmTime(new Date());
        });
        ContextUtils.getSupDeliveryPlanItemService().addAll(supPlanList);
        this.sendPlanToPur(supplierOrderItem.getId());
        return supPlanList;
    }

    private void sendPlanToPur(String orderItemId) {
        PurDeliveryPlanItemExample purPlanItemExample = new PurDeliveryPlanItemExample();
        purPlanItemExample.createCriteria().andPurOrderItemIdEqualTo(orderItemId);
        ContextUtils.getPurDeliveryPlanItemService().deleteByExample(purPlanItemExample);
        ContextUtils.getPurDeliveryPlanItemService().addBySupDeliveryPlanItem(orderItemId);
    }

    private void valid(SupplierOrderItem supplierOrderItem, List<SupDeliveryPlanItem> supPlanList) {
        Assert.isNotNull((Object)supplierOrderItem, (String)"\u91c7\u8d2d\u8ba2\u5355\u884c\u7684\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotBlank((String)supplierOrderItem.getId(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotNull((Object)supplierOrderItem.getQuantity(), (String)"\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(supPlanList, (String)"\u62d2\u7edd\u7684\u9001\u8d27\u901a\u77e5\u5355\uff0c\u6570\u636e\u4e0d\u80fd\u4e3a\u7a7a");
        supPlanList.forEach(planItem -> {
            Assert.isNotBlank((String)planItem.getPurOrderId(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u8ba2\u5355Id\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)planItem.getPurOrderItemId(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u91c7\u8d2d\u8ba2\u5355\u884cId\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)planItem.getMaterialNo(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u7684\u7269\u6599\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotBlank((String)planItem.getFactoryCode(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u5de5\u5382\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryDate(), (String)"\u4ea4\u8d27\u65e5\u671f\u4e0d\u80fd\u4e3a\u7a7a");
            Assert.isNotNull((Object)planItem.getDeliveryQuantity(), (String)"\u9001\u8d27\u901a\u77e5\u5355\u9001\u8d27\u6570\u91cf");
            if (!PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus()) && !PlanChangeStatusEnum.SUP_CONFIRM.getValue().equals(planItem.getChangeStatus())) {
                throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] [%s]\u53d8\u66f4\u7684\u64cd\u4f5c\u7c7b\u578b\u5f02\u5e38", planItem.getPurOrderNo(), planItem.getPurOrderItemNo(), planItem.getChangeStatus()));
            }
            if (PlanChangeStatusEnum.SUP_CHANGE.getValue().equals(planItem.getChangeStatus()) && StringUtils.isBlank((CharSequence)planItem.getChangeReason())) {
                throw new CommonException(String.format("\u9001\u8d27\u901a\u77e5\u5355 [%s][%s] \uff0c\u8d23\u4efb\u65b9\u4e0d\u80fd\u4e3a\u7a7a", planItem.getPurOrderNo(), planItem.getPurOrderItemNo(), planItem.getChangeStatus()));
            }
        });
    }

    public List<SupDeliveryPlanItem> findHisPlanList(String orderItemId) {
        SupDeliveryPlanItemExample example = new SupDeliveryPlanItemExample();
        example.createCriteria().andDeliveryOrderItemIdEqualTo(orderItemId);
        example.setOrderByClause("HIS_TIME DESC");
        List<SupDeliveryPlanItem> planList = ContextUtils.getSupDeliveryPlanItemService().queryAllHisOrderItemByExample(example);
        if (CollectionUtils.isEmpty(planList)) {
            return null;
        }
        return null;
    }

    public void setSupPlanList(List<SupDeliveryPlanItem> supPlanList) {
        this.supPlanList = supPlanList;
    }
}

