/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.common.ContextUtils;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.user.User;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.entity.PurchaseProductImage;
import com.els.base.product.vo.ProductOriginEnum;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.jd.entity.JingdongGoodsBookInfo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.transaction.annotation.Transactional;

public class JingDongGoodsBookToProductCmd
extends BaseCommand<String> {
    private static final long serialVersionUID = 1L;
    private List<JingdongGoodsBookInfo> jingdongGoodsBookInfos;
    private User loginUser;

    public JingDongGoodsBookToProductCmd(List<JingdongGoodsBookInfo> jingdongGoodsBookInfos) {
        this.jingdongGoodsBookInfos = jingdongGoodsBookInfos;
    }

    public JingDongGoodsBookToProductCmd(List<JingdongGoodsBookInfo> jingdongGoodsBookInfos, User loginUser) {
        this.jingdongGoodsBookInfos = jingdongGoodsBookInfos;
        this.loginUser = loginUser;
    }

    public List<JingdongGoodsBookInfo> getJingdongGoodsBookInfos() {
        return this.jingdongGoodsBookInfos;
    }

    public void setJingdongGoodsBookInfos(List<JingdongGoodsBookInfo> jingdongGoodsBookInfos) {
        this.jingdongGoodsBookInfos = jingdongGoodsBookInfos;
    }

    public User getLoginUser() {
        return this.loginUser;
    }

    public void setLoginUser(User loginUser) {
        this.loginUser = loginUser;
    }

    @Transactional
    public String execute(ICommandInvoker context) {
        this.checkData(this.jingdongGoodsBookInfos);
        this.toProduct(this.jingdongGoodsBookInfos);
        return null;
    }

    private void toProduct(List<JingdongGoodsBookInfo> jingdongGoodsBookInfoList) {
        ArrayList<PurchaseProduct> purchaseProducts = new ArrayList<PurchaseProduct>();
        List nextCodes = ContextUtils.getGenerateCodeService().getNextCodes("PURCHASE_PRODUCT", jingdongGoodsBookInfoList.size());
        Assert.isNotEmpty((Collection)nextCodes, (String)"\u6d41\u6c34\u53f7\u751f\u6210\u5931\u8d25\uff0c\u8bf7\u68c0\u67e5");
        for (int i = 0; i < jingdongGoodsBookInfoList.size(); ++i) {
            JingdongGoodsBookInfo goodsBookInfo = jingdongGoodsBookInfoList.get(i);
            PurchaseProduct purchaseProduct = new PurchaseProduct();
            purchaseProduct.setId(UUIDGenerator.generateUUID());
            purchaseProduct.setProductName(goodsBookInfo.getName());
            purchaseProduct.setProductCode((String)nextCodes.get(i));
            purchaseProduct.setProductCodeWx(goodsBookInfo.getSku());
            purchaseProduct.setProductSummary(goodsBookInfo.getName());
            purchaseProduct.setProductDesc(goodsBookInfo.getName());
            purchaseProduct.setProductImage(goodsBookInfo.getImagePath());
            purchaseProduct.setProductOrder(i + 1);
            purchaseProduct.setBasicUnit(goodsBookInfo.getSaleUnit());
            purchaseProduct.setBrandName(goodsBookInfo.getBrand());
            purchaseProduct.setProductOrigin(ProductOriginEnum.JD.getValue());
            purchaseProduct.setSupCompanyId("20200114102528-bad83762b9744a5ba");
            purchaseProduct.setSupCompanyName("\u5317\u4eac\u4eac\u4e1c\u4e16\u7eaa\u8d38\u6613\u6709\u9650\u516c\u53f8");
            purchaseProduct.setSupCompanyCode("20200114102528702672");
            User loginUser = this.getLoginUser();
            purchaseProduct.setCreateUserId(loginUser.getId());
            purchaseProduct.setCreateUserName(loginUser.getNickName());
            purchaseProduct.setCreateTime(new Date());
            purchaseProduct.setUpdateUserId(loginUser.getId());
            purchaseProduct.setUpdateUserName(loginUser.getNickName());
            purchaseProduct.setUpdateTime(new Date());
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
            purchaseProduct.setPublicStatus(Constant.YES_INT);
            purchaseProduct.setPutwayStatus(Constant.NO_INT);
            purchaseProduct.setPutwayTime(new Date());
            purchaseProduct.setPublicTime(new Date());
            ArrayList<PurchaseProductImage> productImageList = new ArrayList<PurchaseProductImage>();
            String otherImage = goodsBookInfo.getImage();
            if (!StringUtils.isEmpty((CharSequence)otherImage)) {
                if (otherImage.contains(",")) {
                    Object[] split = StringUtils.split((String)otherImage, (String)",");
                    if (!ArrayUtils.isEmpty((Object[])split)) {
                        for (int j = 0; j < split.length; ++j) {
                            Object s = split[j];
                            PurchaseProductImage productImage = new PurchaseProductImage();
                            productImage.setId(UUIDGenerator.generateUUID());
                            productImage.setProductId(purchaseProduct.getId());
                            productImage.setImageSrc((String)s);
                            productImage.setOrderNumber(j + 1);
                            productImage.setCreateTime(new Date());
                            productImage.setImageName(purchaseProduct.getProductName());
                            productImageList.add(productImage);
                        }
                    }
                } else {
                    PurchaseProductImage purchaseProductImage = new PurchaseProductImage();
                    purchaseProductImage.setId(UUIDGenerator.generateUUID());
                    purchaseProductImage.setProductId(purchaseProduct.getId());
                    purchaseProductImage.setImageSrc(otherImage);
                    purchaseProductImage.setOrderNumber(1);
                    purchaseProductImage.setCreateTime(new Date());
                    purchaseProductImage.setImageName(purchaseProduct.getProductName());
                    productImageList.add(purchaseProductImage);
                }
            }
            purchaseProduct.setProductImageList(productImageList);
            ContextUtils.getPurchaseProductImageService().addAll(productImageList);
            purchaseProducts.add(purchaseProduct);
        }
        ContextUtils.getPurchaseProductService().addAll(purchaseProducts);
    }

    private void checkData(List<JingdongGoodsBookInfo> jingdongGoodsBookInfoList) {
        Assert.isNotEmpty(jingdongGoodsBookInfoList, (String)"\u6700\u5c11\u9009\u62e9\u4e00\u4e2a\u5546\u54c1\u6765\u8f6c\u6362");
        for (JingdongGoodsBookInfo info : jingdongGoodsBookInfoList) {
            PurchaseProductExample example = new PurchaseProductExample();
            example.createCriteria().andProductCodeWxEqualTo(info.getSku());
            if (ContextUtils.getPurchaseProductService().countByExample(example) <= 0) continue;
            throw new CommonException(info.getSku() + "\u7684\u5546\u54c1\u5df2\u521b\u5efa");
        }
    }
}

