/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.command;

import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.company.entity.Company;
import com.els.base.company.service.CompanyService;
import com.els.base.core.command.BaseCommand;
import com.els.base.core.command.ICommandInvoker;
import com.els.base.core.entity.IExample;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.material.entity.Material;
import com.els.base.material.service.MaterialService;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseUserCart;
import com.els.base.product.entity.PurchaseUserOrder;
import com.els.base.product.entity.PurchaseUserOrderItem;
import com.els.base.product.entity.PurchaseUserOrderItemExt;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.service.PurchaseUserCartService;
import com.els.base.product.service.PurchaseUserOrderItemExtService;
import com.els.base.product.service.PurchaseUserOrderItemService;
import com.els.base.product.service.PurchaseUserOrderService;
import com.els.base.utils.SpringContextHolder;
import com.els.base.utils.uuid.UUIDGenerator;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

public class PurchaseUserOrderAddCmd
extends BaseCommand<String> {
    private PurchaseUserOrder purchaseUserOrder;
    private PurchaseUserOrderService purchaseUserOrderService = (PurchaseUserOrderService)SpringContextHolder.getOneBean(PurchaseUserOrderService.class);
    private PurchaseUserOrderItemService purchaseUserOrderItemService = (PurchaseUserOrderItemService)SpringContextHolder.getOneBean(PurchaseUserOrderItemService.class);
    private GenerateCodeService generateCodeService = (GenerateCodeService)SpringContextHolder.getOneBean(GenerateCodeService.class);
    private PurchaseUserCartService purchaseUserCartService = (PurchaseUserCartService)SpringContextHolder.getOneBean(PurchaseUserCartService.class);
    private CompanyService companyService = (CompanyService)SpringContextHolder.getOneBean(CompanyService.class);
    private PurchaseProductCatalogService purchaseProductCatalogService = (PurchaseProductCatalogService)SpringContextHolder.getOneBean(PurchaseProductCatalogService.class);
    private PurchaseProductService purchaseProductService = (PurchaseProductService)SpringContextHolder.getOneBean(PurchaseProductService.class);
    private PurchaseUserOrderItemExtService purchaseUserOrderItemExtService = (PurchaseUserOrderItemExtService)SpringContextHolder.getOneBean(PurchaseUserOrderItemExtService.class);
    private PurchaseProductInventoryService purchaseProductInventoryService = (PurchaseProductInventoryService)SpringContextHolder.getOneBean(PurchaseProductInventoryService.class);
    private MaterialService materialService = (MaterialService)SpringContextHolder.getOneBean(MaterialService.class);

    public PurchaseUserOrderAddCmd(PurchaseUserOrder purchaseUserOrder) {
        this.purchaseUserOrder = purchaseUserOrder;
    }

    @Transactional
    public synchronized String execute(ICommandInvoker iCommandInvoker) {
        this.check(this.purchaseUserOrder);
        this.fill(this.purchaseUserOrder);
        this.process(this.purchaseUserOrder);
        return this.purchaseUserOrder.getId();
    }

    private void process(PurchaseUserOrder purchaseUserOrder) {
        Company userOrderCompany = purchaseUserOrder.getCompany();
        purchaseUserOrder.setId(UUIDGenerator.generateUUID());
        String nextCode = this.generateCodeService.getNextCode("PURCHASE_USER_ORDER");
        purchaseUserOrder.setOrderNo(nextCode);
        this.purchaseUserOrderService.addObj(purchaseUserOrder);
        PurchaseUserOrderItemExt purchaseUserOrderItemExt = purchaseUserOrder.getPurchaseUserOrderItemExt();
        if (purchaseUserOrderItemExt != null) {
            purchaseUserOrderItemExt.setOrderNo(nextCode);
            purchaseUserOrderItemExt.setCreateTime(new Date());
            purchaseUserOrderItemExt.setInvoiceTitle(userOrderCompany.getCompanyFullName());
            purchaseUserOrderItemExt.setInvoiceContent("01");
            purchaseUserOrderItemExt.setCreatorCompany(userOrderCompany.getCompanyFullName());
            purchaseUserOrderItemExt.setCreatorName(purchaseUserOrder.getCreateUserNickname());
            purchaseUserOrderItemExt.setCreatorPhone(purchaseUserOrder.getInitiatorPhone());
            this.purchaseUserOrderItemExtService.addObj(purchaseUserOrderItemExt);
        }
        List<PurchaseUserOrderItem> purchaseUserOrderItemList = purchaseUserOrder.getPurchaseUserOrderItemList();
        for (PurchaseUserOrderItem purchaseUserOrderItem : purchaseUserOrderItemList) {
            Material material;
            purchaseUserOrderItem.setStatus("0");
            purchaseUserOrderItem.setOrderId(purchaseUserOrder.getId());
            purchaseUserOrderItem.setOrderNo(nextCode);
            BigDecimal total = purchaseUserOrderItem.getProductPrice().multiply(purchaseUserOrderItem.getProductCount()).setScale(3, 4);
            purchaseUserOrderItem.setTotalAmount(total);
            PurchaseProduct product = (PurchaseProduct)this.purchaseProductService.queryObjById(purchaseUserOrderItem.getProductId());
            purchaseUserOrderItem.setSupCompanyCode(product.getSupCompanyCode());
            purchaseUserOrderItem.setSupCompanyId(product.getSupCompanyId());
            purchaseUserOrderItem.setSupCompanyName(product.getSupCompanyName());
            String productInventoryId = purchaseUserOrderItem.getProductInventoryId();
            PurchaseProductInventory purchaseProductInventory = (PurchaseProductInventory)this.purchaseProductInventoryService.queryObjById(productInventoryId);
            String productCodeWx = purchaseProductInventory.getProductCodeWx();
            if (StringUtils.isEmpty((Object)productCodeWx)) {
                purchaseUserOrderItem.setProductCodeWx(product.getProductCodeWx());
            } else {
                purchaseUserOrderItem.setProductCodeWx(productCodeWx);
            }
            BigDecimal productPrice = purchaseProductInventory.getProductPrice();
            purchaseUserOrderItem.setProductPrice(productPrice);
            purchaseUserOrderItem.setMaterialSpecification(purchaseProductInventory.getSpecValues());
            BigDecimal productCount = purchaseUserOrderItem.getProductCount();
            purchaseUserOrderItem.setProductCount(purchaseUserOrderItem.getProductCount());
            BigDecimal multiply = productPrice.multiply(productCount);
            purchaseUserOrderItem.setTotalAmount(multiply);
            PurchaseProductCatalogExample catalogExample = new PurchaseProductCatalogExample();
            catalogExample.createCriteria().andProductIdEqualTo(purchaseUserOrderItem.getProductId());
            List productCatalogList = this.purchaseProductCatalogService.queryAllObjByExample((IExample)catalogExample);
            Assert.isNotEmpty((Collection)productCatalogList, (String)("\u8ba2\u5355\u53f7\uff1a" + purchaseUserOrderItem.getOrderNo() + "\u6ca1\u6709\u7ef4\u62a4\u91c7\u8d2d\u76ee\u5f55\u5173\u7cfb"));
            purchaseUserOrderItem.setPurchaseCatalogId(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogId());
            purchaseUserOrderItem.setPurchaseCatalogCode(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogCode());
            purchaseUserOrderItem.setPurchaseCatalogName(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogName());
            purchaseUserOrderItem.setPurchaseCatalogType(((PurchaseProductCatalog)productCatalogList.get(0)).getPurchaseCatalogType());
            purchaseUserOrderItem.setReceivingAddress(purchaseUserOrder.getReceivingAddress());
            purchaseUserOrderItem.setAttribute1(purchaseUserOrder.getAttribute1());
            purchaseUserOrderItem.setAttribute2(purchaseUserOrder.getAttribute2());
            purchaseUserOrderItem.setAttribute3(purchaseUserOrder.getAttribute3());
            purchaseUserOrderItem.setAttribute4(purchaseProductInventory.getProductMaterialCode());
            if (!StringUtils.isEmpty((Object)purchaseProductInventory.getProductMaterialCode()) && null != (material = this.materialService.queryObjByCode(purchaseProductInventory.getProductMaterialCode()))) {
                purchaseUserOrderItem.setAttribute5(material.getCategory());
            }
            purchaseUserOrderItem.setInitiatorId(purchaseUserOrder.getInitiatorId());
            purchaseUserOrderItem.setInitiatorName(purchaseUserOrder.getInitiatorName());
            purchaseUserOrderItem.setInitiatorEmpId(purchaseUserOrder.getInitiatorEmpId());
            purchaseUserOrderItem.setInitiatorBusinessBook(purchaseUserOrder.getInitiatorBusinessBook());
            purchaseUserOrderItem.setInitiatorAccountSetId(purchaseUserOrder.getInitiatorAccountSetId());
            purchaseUserOrderItem.setInitiatorAccountSetName(purchaseUserOrder.getInitiatorAccountSetName());
            purchaseUserOrderItem.setInitiatorCompanyCode(purchaseUserOrder.getInitiatorCompanyCode());
            purchaseUserOrderItem.setInitiatorCompanyName(purchaseUserOrder.getInitiatorCompanyName());
            purchaseUserOrderItem.setInitiatorOrganizationId(purchaseUserOrder.getInitiatorOrganizationId());
            purchaseUserOrderItem.setInitiatorOrganizationName(purchaseUserOrder.getInitiatorOrganizationName());
            purchaseUserOrderItem.setInitiatorDeptCode(purchaseUserOrder.getInitiatorDeptCode());
            purchaseUserOrderItem.setInitiatorDeptName(purchaseUserOrder.getInitiatorDeptName());
            purchaseUserOrderItem.setInitiatorPhone(purchaseUserOrder.getInitiatorPhone());
            purchaseUserOrderItem.setCreateUserNickname(purchaseUserOrder.getCreateUserNickname());
            purchaseUserOrderItem.setInstitutionsId(purchaseUserOrder.getInstitutionsId());
            purchaseUserOrderItem.setInstitutionsName(purchaseUserOrder.getInstitutionsName());
            PurchaseUserCart userCart = new PurchaseUserCart();
            userCart.setId(purchaseUserOrderItem.getId());
            userCart.setIsEnable("0");
            this.purchaseUserCartService.modifyObj(userCart);
            purchaseUserOrderItem.setId(UUIDGenerator.generateUUID());
        }
        this.purchaseUserOrderItemService.addAll(purchaseUserOrderItemList);
    }

    private void fill(PurchaseUserOrder purchaseUserOrder) {
    }

    private void check(PurchaseUserOrder purchaseUserOrder) {
        Assert.isNotNull((Object)purchaseUserOrder, (String)"\u8ba2\u5355\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorDeptCode(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorDeptName(), (String)"\u53d1\u8d77\u4eba\u90e8\u95e8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorCompanyCode(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u7f16\u7801\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorCompanyName(), (String)"\u53d1\u8d77\u4eba\u516c\u53f8\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorAccountSetId(), (String)"\u53d1\u8d77\u4eba\u8d26\u5957id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorAccountSetName(), (String)"\u53d1\u8d77\u4eba\u8d26\u5957\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorOrganizationId(), (String)"\u53d1\u8d77\u4eba\u4e2d\u652f\u673a\u6784id\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getInitiatorOrganizationName(), (String)"\u53d1\u8d77\u4eba\u4e2d\u652f\u673a\u6784\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotBlank((String)purchaseUserOrder.getReceivingAddress(), (String)"\u6536\u8d27\u5730\u5740\u4e0d\u80fd\u4e3a\u7a7a!");
        Assert.isNotEmpty(purchaseUserOrder.getPurchaseUserOrderItemList(), (String)"\u8ba2\u5355\u884c\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        purchaseUserOrder.getPurchaseUserOrderItemList().forEach(purchaseUserOrderItem -> {
            boolean b;
            String supCompanyId = purchaseUserOrder.getPurchaseUserOrderItemList().get(0).getSupCompanyId();
            if (!supCompanyId.equals(purchaseUserOrderItem.getSupCompanyId())) {
                throw new CommonException("\u540c\u4e00\u4f9b\u5e94\u5546\u624d\u53ef\u4ee5\u7ed3\u7b97");
            }
            String productId = purchaseUserOrderItem.getProductId();
            Assert.isNotBlank((String)productId, (String)"\u4ea7\u54c1ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            PurchaseProduct product = (PurchaseProduct)this.purchaseProductService.queryObjById(purchaseUserOrderItem.getProductId());
            Assert.isNotNull((Object)product, (String)"\u4e0d\u5b58\u5728\u5bf9\u5e94\u7684\u5546\u54c1\u6570\u636e");
            if (0 == product.getPutwayStatus()) {
                throw new CommonException("\u5546\u54c1\u5df2\u4e0b\u67b6");
            }
            String productInventoryId = purchaseUserOrderItem.getProductInventoryId();
            Assert.isNotBlank((String)productInventoryId, (String)"\u5e93\u5b58ID\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
            PurchaseProductInventory purchaseProductInventory = (PurchaseProductInventory)this.purchaseProductInventoryService.queryObjById(productInventoryId);
            BigDecimal productStock = purchaseProductInventory.getProductNumber();
            if (ObjectUtils.isEmpty((Object)productStock)) {
                throw new CommonException("\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a\uff01");
            }
            BigDecimal productCount = purchaseUserOrderItem.getProductCount();
            boolean bl = b = productCount.compareTo(productStock) > 0;
            if (b) {
                throw new CommonException("\u4e0b\u5355\u6570\u91cf\u8d85\u8fc7\u5e93\u5b58\uff0c\u8bf7\u68c0\u67e5\uff01");
            }
            BigDecimal minimumPurchase = product.getMinimumPurchase();
            if (!ObjectUtils.isEmpty((Object)minimumPurchase)) {
                boolean flag;
                boolean bl2 = flag = productCount.compareTo(minimumPurchase) >= 0;
                if (!flag) {
                    throw new CommonException(product.getProductName() + ",\u4e0b\u5355\u6570\u91cf\u5c0f\u4e8e\u6700\u5c0f\u6570\u91cf[" + minimumPurchase.toString() + "]\uff0c\u8bf7\u68c0\u67e5\uff01");
                }
            }
            if (ObjectUtils.isEmpty((Object)purchaseProductInventory.getProductNumber())) {
                throw new CommonException("\u8bf7\u7ef4\u62a4\u5e93\u5b58");
            }
            Boolean isBuy = purchaseProductInventory.getProductNumber().compareTo(BigDecimal.ZERO) == 0;
            if (isBuy.booleanValue()) {
                throw new CommonException("\u5e93\u5b58\u6570\u91cf\u4e3a0\uff0c\u8bf7\u589e\u52a0\u5e93\u5b58\uff01");
            }
            BigDecimal subtract = purchaseProductInventory.getProductNumber().subtract(productCount);
            purchaseProductInventory.setProductNumber(subtract);
            this.purchaseProductInventoryService.modifyObj(purchaseProductInventory);
        });
    }
}

