/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseProductAttributeMapper;
import com.els.base.product.entity.PurchaseProductAttribute;
import com.els.base.product.entity.PurchaseProductAttributeExample;
import com.els.base.product.service.PurchaseProductAttributeService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductAttributeService")
public class PurchaseProductAttributeServiceImpl
implements PurchaseProductAttributeService {
    @Resource
    protected PurchaseProductAttributeMapper purchaseProductAttributeMapper;

    @Override
    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public int updateByExampleSelective(PurchaseProductAttribute record, PurchaseProductAttributeExample example) {
        return this.purchaseProductAttributeMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public void addObj(PurchaseProductAttribute t) {
        this.purchaseProductAttributeMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public void addAll(List<PurchaseProductAttribute> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductAttributeMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductAttributeMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public void deleteByExample(PurchaseProductAttributeExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductAttributeMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProductAttribute"}, allEntries=true)
    public void modifyObj(PurchaseProductAttribute t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductAttributeMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProductAttribute"}, keyGenerator="redisKeyGenerator")
    public PurchaseProductAttribute queryObjById(String id) {
        return this.purchaseProductAttributeMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProductAttribute"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProductAttribute> queryAllObjByExample(PurchaseProductAttributeExample example) {
        return this.purchaseProductAttributeMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProductAttribute"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProductAttribute> queryObjByPage(PurchaseProductAttributeExample example) {
        PageView<PurchaseProductAttribute> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductAttributeMapper.selectByExampleByPage(example));
        return pageView;
    }
}

