/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.els.base.core.entity.PageView;
import com.els.base.core.utils.Assert;
import com.els.base.product.dao.PurchaseProductCatalogMapper;
import com.els.base.product.entity.PurchaseProductCatalog;
import com.els.base.product.entity.PurchaseProductCatalogExample;
import com.els.base.product.service.PurchaseProductCatalogService;
import com.els.base.utils.uuid.UUIDGenerator;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service(value="defaultPurchaseProductCatalogService")
public class PurchaseProductCatalogServiceImpl
implements PurchaseProductCatalogService {
    @Resource
    protected PurchaseProductCatalogMapper purchaseProductCatalogMapper;

    @Override
    @Cacheable(value={"purchaseProductCatalog"}, keyGenerator="redisKeyGenerator")
    public int countByExample(PurchaseProductCatalogExample example) {
        return this.purchaseProductCatalogMapper.countByExample(example);
    }

    @Override
    public PurchaseProductCatalog findByProductId(String productId) {
        PurchaseProductCatalogExample example = new PurchaseProductCatalogExample();
        example.createCriteria().andProductIdEqualTo(productId);
        List<PurchaseProductCatalog> productCatalogs = this.queryAllObjByExample(example);
        if (CollectionUtils.isNotEmpty(productCatalogs)) {
            return productCatalogs.get(0);
        }
        return null;
    }

    @CacheEvict(value={"purchaseProductCatalog"}, allEntries=true)
    public void addObj(PurchaseProductCatalog t) {
        this.purchaseProductCatalogMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProductCatalog"}, allEntries=true)
    public void addAll(List<PurchaseProductCatalog> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductCatalogMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProductCatalog"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductCatalogMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProductCatalog"}, allEntries=true)
    public void deleteByExample(PurchaseProductCatalogExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductCatalogMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProductCatalog"}, allEntries=true)
    public void modifyObj(PurchaseProductCatalog t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductCatalogMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProductCatalog"}, keyGenerator="redisKeyGenerator")
    public PurchaseProductCatalog queryObjById(String id) {
        return this.purchaseProductCatalogMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProductCatalog"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProductCatalog> queryAllObjByExample(PurchaseProductCatalogExample example) {
        return this.purchaseProductCatalogMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProductCatalog"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProductCatalog> queryObjByPage(PurchaseProductCatalogExample example) {
        PageView<PurchaseProductCatalog> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductCatalogMapper.selectByExampleByPage(example));
        return pageView;
    }
}

