/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.els.base.codegenerator.service.GenerateCodeService;
import com.els.base.core.entity.PageView;
import com.els.base.core.exception.CommonException;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.Constant;
import com.els.base.material.service.MaterialService;
import com.els.base.material.utils.ApproveStatusEnum;
import com.els.base.product.dao.PurchaseProductMapper;
import com.els.base.product.entity.PurchaseProduct;
import com.els.base.product.entity.PurchaseProductExample;
import com.els.base.product.service.PurchaseMaterialService;
import com.els.base.product.service.PurchaseProductService;
import com.els.base.product.vo.PutwayVO;
import com.els.base.utils.uuid.UUIDGenerator;
import com.els.base.workflow.common.event.TaskOperateEvent;
import com.els.base.workflow.common.service.ITaskListener;
import com.els.comix.entity.QixinBaseGoodsInfo;
import com.els.comix.service.QixinProductService;
import com.els.config.SpringApplicationEventPublisher;
import com.els.jd.util.HttpUtil;
import com.els.jd.util.JDApiQueryExtsUtils;
import com.els.jd.util.JdApiUtils;
import com.els.jd.util.JdTokenUtils;
import com.els.jd.vo.JdSellPriceResultVO;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Resource;
import net.sf.json.JSONArray;
import net.sf.json.JsonConfig;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.ObjectUtils;

@Service(value="defaultPurchaseProductService")
public class PurchaseProductServiceImpl
implements PurchaseProductService,
ITaskListener,
QixinProductService {
    @Resource
    protected PurchaseProductMapper purchaseProductMapper;
    @Resource
    protected MaterialService materialService;
    @Resource
    protected GenerateCodeService generateCodeService;
    @Resource
    private JdTokenUtils jdTokenUtils;
    @Resource
    private PurchaseMaterialService purchaseMaterialService;
    @Resource
    protected SpringApplicationEventPublisher applicationEventPublisher;
    private static final Logger logger = LoggerFactory.getLogger(PurchaseProductServiceImpl.class);

    @Override
    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProduct> selectByExampleWithBLOBs(PurchaseProductExample example) {
        return this.purchaseProductMapper.selectByExampleWithBLOBs(example);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public boolean isToProduct(QixinBaseGoodsInfo qixinBaseGoodsInfo) {
        Assert.isNotBlank((String)qixinBaseGoodsInfo.getProductNo(), (String)"\u5546\u54c1\u7f16\u53f7\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andProductNumberEqualTo(qixinBaseGoodsInfo.getProductNo());
        int i = this.purchaseProductMapper.countByExample(example);
        return i > 0;
    }

    @Override
    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public int countByExample(PurchaseProductExample example) {
        return this.purchaseProductMapper.countByExample(example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    @Transactional
    public void listen(TaskOperateEvent event) {
        String businessId = event.getBusinessId();
        if (StringUtils.isBlank((String)businessId)) {
            return;
        }
        PurchaseProduct purchaseProduct = this.purchaseProductMapper.selectByPrimaryKey(event.getBusinessId());
        if (ObjectUtils.isEmpty((Object)purchaseProduct)) {
            return;
        }
        if (event.isFinished() && event.isPass()) {
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_PASS.getValue());
            purchaseProduct.setPutwayStatus(Constant.YES_INT);
            purchaseProduct.setPutwayTime(new Date());
            this.purchaseProductMapper.updateByPrimaryKeySelective(purchaseProduct);
            ArrayList<String> ids = new ArrayList<String>();
            ids.add(businessId);
            PutwayVO putwayVO = new PutwayVO();
            putwayVO.setIds(ids);
            putwayVO.setPutwayStarus(Constant.YES_INT);
            this.purchaseMaterialService.createMaterialByProductIds(putwayVO);
        } else if (event.isFinished() && !event.isPass()) {
            purchaseProduct.setApproveStatus(ApproveStatusEnum.APPROVE_REFUSE.getValue());
            this.purchaseProductMapper.updateByPrimaryKeySelective(purchaseProduct);
        }
    }

    @Override
    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    @Transactional
    public int updateByExampleSelective(PurchaseProduct record, PurchaseProductExample example) {
        return this.purchaseProductMapper.updateByExampleSelective(record, example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void addObj(PurchaseProduct t) {
        this.purchaseProductMapper.insertSelective(t);
    }

    @Transactional
    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void addAll(List<PurchaseProduct> list) {
        if (CollectionUtils.isEmpty(list)) {
            return;
        }
        list.stream().forEach(item -> {
            if (StringUtils.isBlank((String)item.getId())) {
                item.setId(UUIDGenerator.generateUUID());
            }
        });
        this.purchaseProductMapper.insertBatch(list);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void deleteObjById(String id) {
        this.purchaseProductMapper.deleteByPrimaryKey(id);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void deleteByExample(PurchaseProductExample example) {
        Assert.isNotNull((Object)example, (String)"\u53c2\u6570\u4e0d\u80fd\u4e3a\u7a7a");
        Assert.isNotEmpty(example.getOredCriteria(), (String)"\u6279\u91cf\u5220\u9664\u4e0d\u80fd\u5168\u8868\u5220\u9664");
        this.purchaseProductMapper.deleteByExample(example);
    }

    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    public void modifyObj(PurchaseProduct t) {
        Assert.isNotBlank((String)t.getId(), (String)"id \u4e3a\u7a7a\uff0c\u65e0\u6cd5\u4fee\u6539");
        this.purchaseProductMapper.updateByPrimaryKeySelective(t);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public PurchaseProduct queryObjById(String id) {
        return this.purchaseProductMapper.selectByPrimaryKey(id);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public List<PurchaseProduct> queryAllObjByExample(PurchaseProductExample example) {
        return this.purchaseProductMapper.selectByExample(example);
    }

    @Cacheable(value={"purchaseProduct"}, keyGenerator="redisKeyGenerator")
    public PageView<PurchaseProduct> queryObjByPage(PurchaseProductExample example) {
        PageView<PurchaseProduct> pageView = example.getPageView();
        pageView.setQueryResult(this.purchaseProductMapper.selectByExampleByPage(example));
        return pageView;
    }

    @Override
    public List<PurchaseProduct> fandProductCode(PurchaseProduct purchaseProduct) {
        return this.purchaseProductMapper.fandProductCode(purchaseProduct);
    }

    @Override
    @CacheEvict(value={"purchaseProduct"}, allEntries=true)
    @Transactional
    public void updateProductPrice() {
        PurchaseProductExample example = new PurchaseProductExample();
        example.createCriteria().andProductOriginEqualTo("2").andProductCodeWxIsNotNull();
        List<PurchaseProduct> allPurchaseProduct = this.purchaseProductMapper.selectByExample(example);
        if (CollectionUtils.isNotEmpty(allPurchaseProduct)) {
            List<Object> skuList = new ArrayList();
            HashMap<String, String> params = new HashMap<String, String>();
            List group = Lists.partition(allPurchaseProduct, (int)100);
            for (List list : group) {
                skuList.clear();
                skuList = list.stream().map(p -> p.getProductCodeWx()).collect(Collectors.toList());
                params.clear();
                params.put("token", this.jdTokenUtils.getAccessToken());
                params.put("sku", StringUtils.join(skuList, (String)","));
                params.put("queryExts", JDApiQueryExtsUtils.GET_SHELL_PRICE);
                logger.info("\u4f20\u9012\u7684\u53c2\u6570{}", params);
                String result = HttpUtil.httpPost((String)JdApiUtils.API_GET_JD_PRICE, params);
                logger.info("\u8fd4\u56de\u7684\u5546\u54c1\u4ef7\u683c\u7ed3\u679c=" + result);
                JSONObject jsonObject = JSON.parseObject((String)result);
                this.checkSuccess(jsonObject);
                JSONArray fromObject = JSONArray.fromObject((Object)jsonObject.get((Object)"result"));
                List resultList = JSONArray.toList((JSONArray)fromObject, (Object)new JdSellPriceResultVO(), (JsonConfig)new JsonConfig());
                if (CollectionUtils.isEmpty((Collection)resultList)) {
                    throw new CommonException("\u6279\u91cf\u8f6c\u6362\u5546\u54c1\u4ef7\u683c\u4fe1\u606f\u5f02\u5e38");
                }
                this.purchaseProductMapper.updateProductPrice(resultList);
            }
        }
    }

    private void checkSuccess(JSONObject jsonObject) {
        if (ObjectUtils.isEmpty((Object)jsonObject)) {
            throw new CommonException("\u8bf7\u6c42\u4eac\u4e1c\u8fd4\u56de\u4fe1\u606f\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5");
        }
        boolean success = (Boolean)jsonObject.get((Object)"success");
        if (!success) {
            String resultCode = (String)jsonObject.get((Object)"resultCode");
            String resultMessage = (String)jsonObject.get((Object)"resultMessage");
            throw new CommonException("\u4eac\u4e1c\u8fd4\u56de\u7684\u5931\u8d25\u7f16\u7801\u4e3a:" + resultCode + ",\u5931\u8d25\u4fe1\u606f\u4e3a\uff1a" + resultMessage);
        }
    }
}

