/*
 * Decompiled with CFR 0.152.
 */
package com.els.base.product.web.controller;

import com.els.base.core.entity.IExample;
import com.els.base.core.entity.PageView;
import com.els.base.core.entity.ResponseResult;
import com.els.base.core.utils.Assert;
import com.els.base.core.utils.CriteriaUtils;
import com.els.base.core.utils.query.QueryParamWapper;
import com.els.base.product.entity.PurchaseProductInventory;
import com.els.base.product.entity.PurchaseProductInventoryExample;
import com.els.base.product.service.PurchaseProductInventoryService;
import com.els.comix.entity.QixinBaseGoodsInfo;
import com.els.comix.entity.QixinBaseGoodsInfoExample;
import com.els.comix.service.QixinBaseGoodsInfoService;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiImplicitParam;
import io.swagger.annotations.ApiImplicitParams;
import io.swagger.annotations.ApiOperation;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import javax.annotation.Resource;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Api(value="\u5546\u54c1\u5e93\u5b58")
@Controller
@RequestMapping(value={"purchaseProductInventory"})
public class PurchaseProductInventoryController {
    @Resource
    protected PurchaseProductInventoryService purchaseProductInventoryService;
    @Resource
    protected QixinBaseGoodsInfoService qixinBaseGoodsInfoService;

    @ApiOperation(httpMethod="GET", value="\u4fee\u6b63\u9f50\u5fc3\u4ef7\u683c\u9519\u8bef")
    @RequestMapping(value={"service/fixPrice"})
    @ResponseBody
    public ResponseResult<String> fixPrice() {
        QixinBaseGoodsInfoExample qixinBaseGoodsInfoExample = new QixinBaseGoodsInfoExample();
        List qixinBaseGoodsInfos = this.qixinBaseGoodsInfoService.queryAllObjByExample((IExample)qixinBaseGoodsInfoExample);
        if (CollectionUtils.isNotEmpty((Collection)qixinBaseGoodsInfos)) {
            for (QixinBaseGoodsInfo qixinBaseGoodsInfo : qixinBaseGoodsInfos) {
                BigDecimal pxPrice = qixinBaseGoodsInfo.getPxPrice();
                PurchaseProductInventory purchaseProductInventory = new PurchaseProductInventory();
                purchaseProductInventory.setProductPrice(pxPrice);
                purchaseProductInventory.setProductCodeWx(qixinBaseGoodsInfo.getProductNo());
                PurchaseProductInventoryExample example = new PurchaseProductInventoryExample();
                example.createCriteria().andProductCodeWxEqualTo(qixinBaseGoodsInfo.getProductNo());
                this.purchaseProductInventoryService.updateByExampleSelective(purchaseProductInventory, example);
            }
        }
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="POST", value="\u7f16\u8f91\u5546\u54c1\u5e93\u5b58")
    @RequestMapping(value={"service/edit"})
    @ResponseBody
    public ResponseResult<String> edit(@RequestBody PurchaseProductInventory purchaseProductInventory) {
        Assert.isNotBlank((String)purchaseProductInventory.getId(), (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        PurchaseProductInventory purchaseProductInventory1 = (PurchaseProductInventory)this.purchaseProductInventoryService.queryObjById(purchaseProductInventory.getId());
        Assert.isNotNull((Object)purchaseProductInventory1, (String)"\u5e93\u5b58\u4fe1\u606f\u4e0d\u5b58\u5728\uff0c\u8bf7\u68c0\u67e5\uff01");
        BigDecimal productNumber = purchaseProductInventory.getProductNumber();
        Assert.isNotNull((Object)productNumber, (String)"\u5546\u54c1\u5e93\u5b58\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        BigDecimal productPrice = purchaseProductInventory.getProductPrice();
        Assert.isNotNull((Object)productPrice, (String)"\u5546\u54c1\u4ef7\u683c\u4e0d\u80fd\u4e3a\u7a7a\uff0c\u8bf7\u68c0\u67e5\uff01");
        purchaseProductInventory1.setProductNumber(productNumber);
        purchaseProductInventory1.setProductPrice(productPrice);
        purchaseProductInventory1.setUpdateTime(new Date());
        purchaseProductInventory1.setProductUrl(purchaseProductInventory.getProductUrl());
        this.purchaseProductInventoryService.modifyObj(purchaseProductInventory1);
        return ResponseResult.success();
    }

    @ApiOperation(httpMethod="GET", value="\u67e5\u8be2\u5e93\u5b58\u8be6\u60c5")
    @RequestMapping(value={"service/findById"})
    @ResponseBody
    public ResponseResult<PurchaseProductInventory> findById(@RequestParam String id) {
        Assert.isNotBlank((String)id, (String)"id \u4e3a\u7a7a\uff0c\u4fdd\u5b58\u5931\u8d25");
        PurchaseProductInventory purchaseProductInventory = (PurchaseProductInventory)this.purchaseProductInventoryService.queryObjById(id);
        return ResponseResult.success((Object)purchaseProductInventory);
    }

    @ApiOperation(httpMethod="POST", value="\u67e5\u8be2\u5546\u54c1\u5e93\u5b58")
    @ApiImplicitParams(value={@ApiImplicitParam(name="pageNo", required=false, value="\u6240\u5728\u9875", paramType="query", dataType="String", defaultValue="0"), @ApiImplicitParam(name="pageSize", required=false, value="\u6bcf\u9875\u6570\u91cf", paramType="query", dataType="String", defaultValue="10"), @ApiImplicitParam(name="wapper", required=false, value="\u67e5\u8be2\u6761\u4ef6,\u5c5e\u6027\u540d\u8bf7\u53c2\u8003 PurchaseProductInventory", paramType="body", dataType="QueryParamWapper")})
    @RequestMapping(value={"service/findByPage"})
    @ResponseBody
    public ResponseResult<PageView<PurchaseProductInventory>> findByPage(@RequestParam(defaultValue="0") int pageNo, @RequestParam(defaultValue="10") int pageSize, @RequestBody(required=false) QueryParamWapper wapper) {
        PurchaseProductInventoryExample example = new PurchaseProductInventoryExample();
        example.setPageView((PageView<PurchaseProductInventory>)new PageView(pageNo, pageSize));
        PurchaseProductInventoryExample.Criteria criteria = example.createCriteria();
        if (wapper != null) {
            CriteriaUtils.addExample((IExample)example, (QueryParamWapper)wapper);
        }
        PageView pageData = this.purchaseProductInventoryService.queryObjByPage((IExample)example);
        return ResponseResult.success((Object)pageData);
    }
}

